/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightInfoComposite
extends HighlightInfo {
    @NonNls
    private static final String LINE_BREAK = "<hr size=1 noshade>";

    static HighlightInfoComposite create(@NotNull List<? extends HighlightInfo> infos) {
        HighlightInfo anchorInfo;
        if (infos == null) {
            HighlightInfoComposite.$$$reportNull$$$0(0);
        }
        if ((anchorInfo = (HighlightInfo)ContainerUtil.find(infos, info -> info.getToolTip() != null)) == null) {
            anchorInfo = infos.get(0);
        }
        return new HighlightInfoComposite(infos, anchorInfo);
    }

    private HighlightInfoComposite(@NotNull List<? extends HighlightInfo> infos, @NotNull HighlightInfo anchorInfo) {
        if (infos == null) {
            HighlightInfoComposite.$$$reportNull$$$0(1);
        }
        if (anchorInfo == null) {
            HighlightInfoComposite.$$$reportNull$$$0(2);
        }
        super(null, null, anchorInfo.type, anchorInfo.startOffset, anchorInfo.endOffset, HighlightInfoComposite.createCompositeDescription(infos), HighlightInfoComposite.createCompositeTooltip(infos), anchorInfo.type.getSeverity(null), false, null, false, 0, anchorInfo.getProblemGroup(), anchorInfo.getGutterIconRenderer());
        this.highlighter = anchorInfo.getHighlighter();
        this.setGroup(anchorInfo.getGroup());
        ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> markers = ContainerUtil.emptyList();
        ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> ranges = ContainerUtil.emptyList();
        for (HighlightInfo highlightInfo : infos) {
            if (highlightInfo.quickFixActionMarkers != null) {
                if (markers == ContainerUtil.emptyList()) {
                    markers = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>>();
                }
                markers.addAll(highlightInfo.quickFixActionMarkers);
            }
            if (highlightInfo.quickFixActionRanges == null) continue;
            if (ranges == ContainerUtil.emptyList()) {
                ranges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
            }
            ranges.addAll(highlightInfo.quickFixActionRanges);
        }
        this.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList((Collection)markers);
        this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList((Collection)ranges);
    }

    @Nullable
    private static String createCompositeDescription(List<? extends HighlightInfo> infos) {
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo highlightInfo : infos) {
            String itemDescription = highlightInfo.getDescription();
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    private static String createCompositeTooltip(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfoComposite.$$$reportNull$$$0(3);
        }
        StringBuilder result2 = new StringBuilder();
        for (HighlightInfo highlightInfo : infos) {
            String toolTip = highlightInfo.getToolTip();
            if (toolTip == null) continue;
            if (result2.length() != 0) {
                result2.append(LINE_BREAK);
            }
            toolTip = XmlStringUtil.stripHtml((String)toolTip);
            result2.append(toolTip);
        }
        if (result2.length() == 0) {
            return null;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorInfo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoComposite";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCompositeTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

