/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionTreeUpdater;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.util.containers.WeakInterner;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTreeNode
extends DefaultMutableTreeNode {
    private static final WeakInterner<LevelAndCount[]> LEVEL_AND_COUNT_INTERNER = new WeakInterner((TObjectHashingStrategy)new TObjectHashingStrategy<LevelAndCount[]>(){

        public int computeHashCode(LevelAndCount[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(LevelAndCount[] o1, LevelAndCount[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    final AtomicClearableLazyValue<LevelAndCount[]> myProblemLevels = new AtomicClearableLazyValue<LevelAndCount[]>(){

        @NotNull
        protected LevelAndCount[] compute() {
            TObjectIntHashMap counter = new TObjectIntHashMap();
            InspectionTreeNode.this.visitProblemSeverities((TObjectIntHashMap<HighlightDisplayLevel>)counter);
            LevelAndCount[] arr = new LevelAndCount[counter.size()];
            int[] i = new int[]{0};
            counter.forEachEntry((l, c) -> {
                int n = i[0];
                i[0] = n + 1;
                arr[n] = new LevelAndCount((HighlightDisplayLevel)l, c);
                return true;
            });
            Arrays.sort(arr, Comparator.comparing(levelAndCount -> levelAndCount.getLevel().getSeverity()).reversed());
            LevelAndCount[] levelAndCountArray = InspectionTreeNode.this.doesNeedInternProblemLevels() ? (LevelAndCount[])LEVEL_AND_COUNT_INTERNER.intern((Object)arr) : arr;
            if (levelAndCountArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return levelAndCountArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTreeNode$2", "compute"));
        }
    };
    protected volatile InspectionTreeUpdater myUpdater;

    protected InspectionTreeNode(Object userObject) {
        super(userObject);
    }

    protected boolean doesNeedInternProblemLevels() {
        return false;
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return null;
    }

    @NotNull
    LevelAndCount[] getProblemLevels() {
        if (!this.isProblemCountCacheValid()) {
            this.dropProblemCountCaches();
        }
        LevelAndCount[] levelAndCountArray = (LevelAndCount[])this.myProblemLevels.getValue();
        if (levelAndCountArray == null) {
            InspectionTreeNode.$$$reportNull$$$0(0);
        }
        return levelAndCountArray;
    }

    void dropProblemCountCaches() {
        for (InspectionTreeNode current = this; current != null; current = (InspectionTreeNode)current.getParent()) {
            current.myProblemLevels.drop();
        }
    }

    protected boolean isProblemCountCacheValid() {
        return true;
    }

    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (counter == null) {
            InspectionTreeNode.$$$reportNull$$$0(1);
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)enumeration.nextElement();
            for (LevelAndCount levelAndCount : child2.getProblemLevels()) {
                if (counter.adjustValue((Object)levelAndCount.getLevel(), levelAndCount.getCount())) continue;
                counter.put((Object)levelAndCount.getLevel(), levelAndCount.getCount());
            }
        }
    }

    public int getProblemCount(boolean allowSuppressed) {
        int sum = 0;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)enumeration.nextElement();
            sum += child2.getProblemCount(allowSuppressed);
        }
        return sum;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isExcluded() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)enumeration.nextElement();
            if (child2.isExcluded()) continue;
            return false;
        }
        return this.getChildCount() != 0;
    }

    public boolean appearsBold() {
        return false;
    }

    @Nullable
    public String getTailText() {
        return null;
    }

    public void excludeElement() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)enumeration.nextElement();
            child2.excludeElement();
        }
        this.dropProblemCountCaches();
    }

    public void amnestyElement() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)enumeration.nextElement();
            child2.amnestyElement();
        }
        this.dropProblemCountCaches();
    }

    public InspectionTreeNode insertByOrder(InspectionTreeNode child2, boolean allowDuplication) {
        return (InspectionTreeNode)ReadAction.compute(() -> {
            int index;
            if (!allowDuplication && (index = this.getIndex(child2)) != -1) {
                return (InspectionTreeNode)this.getChildAt(index);
            }
            index = TreeUtil.indexedBinarySearch((TreeNode)this, (TreeNode)child2, (Comparator)InspectionResultsViewComparator.getInstance());
            if (!allowDuplication && index >= 0) {
                return (InspectionTreeNode)this.getChildAt(index);
            }
            this.insert(child2, Math.abs(index + 1));
            return child2;
        });
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        if (this.myUpdater != null) {
            ((InspectionTreeNode)newChild).propagateUpdater(this.myUpdater);
            this.dropProblemCountCaches();
            this.myUpdater.updateWithPreviewPanel();
        }
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        if (this.myUpdater != null) {
            ((InspectionTreeNode)newChild).propagateUpdater(this.myUpdater);
            this.dropProblemCountCaches();
            this.myUpdater.updateWithPreviewPanel();
        }
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.dropProblemCountCaches();
    }

    protected void nodeAddedToTree() {
    }

    private void propagateUpdater(InspectionTreeUpdater updater) {
        if (this.myUpdater != null) {
            return;
        }
        this.myUpdater = updater;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)enumeration.nextElement();
            child2.propagateUpdater(updater);
            child2.nodeAddedToTree();
        }
    }

    public RefEntity getContainingFileLocalEntity() {
        Enumeration<TreeNode> children2 = this.children();
        RefEntity current = null;
        while (children2.hasMoreElements()) {
            InspectionTreeNode child2 = (InspectionTreeNode)children2.nextElement();
            RefEntity entity = child2.getContainingFileLocalEntity();
            if (entity == null || current != null) {
                return null;
            }
            current = entity;
        }
        return current;
    }

    @Override
    public synchronized TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public synchronized void setParent(MutableTreeNode newParent) {
        super.setParent(newParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTreeNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemLevels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitProblemSeverities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

