/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectorRegistryImpl
extends FrameworkDetectorRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FrameworkDetectorRegistryImpl");
    private static final int REGISTRY_VERSION = 0;
    private TObjectIntHashMap<String> myDetectorIds;
    private TIntObjectHashMap<FrameworkDetector> myDetectorById;
    private MultiMap<FileType, Integer> myDetectorsByFileType;
    private int myDetectorsVersion;

    public FrameworkDetectorRegistryImpl() {
        this.loadDetectors();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.saveDetectors();
        }
    }

    private void loadDetectors() {
        HashMap<String, FrameworkDetector> newDetectors = new HashMap<String, FrameworkDetector>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            newDetectors.put(detector.getDetectorId(), detector);
        }
        this.myDetectorIds = new TObjectIntHashMap();
        Path file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        int maxId = 0;
        if (Files.exists(file2, new LinkOption[0])) {
            LOG.debug("loading framework detectors registry from " + file2.toAbsolutePath());
            ArrayList<String> unknownIds = new ArrayList<String>();
            boolean versionChanged = false;
            try (DataInputStream input = new DataInputStream(new BufferedInputStream(Files.newInputStream(file2, new OpenOption[0])));){
                input.readInt();
                this.myDetectorsVersion = input.readInt();
                int size = input.readInt();
                while (size-- > 0) {
                    String stringId = input.readUTF();
                    int intId = input.readInt();
                    maxId = Math.max(maxId, intId);
                    int version = input.readInt();
                    FrameworkDetector detector = (FrameworkDetector)newDetectors.remove(stringId);
                    if (detector != null) {
                        if (version != detector.getDetectorVersion()) {
                            LOG.info("Version of framework detector '" + stringId + "' changed: " + version + " -> " + detector.getDetectorVersion());
                            versionChanged = true;
                        }
                        this.myDetectorIds.put((Object)stringId, intId);
                        continue;
                    }
                    unknownIds.add(stringId);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            if (!unknownIds.isEmpty()) {
                LOG.debug("Unknown framework detectors: " + unknownIds);
            }
            if (versionChanged || !newDetectors.isEmpty()) {
                if (!newDetectors.isEmpty()) {
                    LOG.info("New framework detectors: " + newDetectors.keySet());
                }
                ++this.myDetectorsVersion;
                LOG.info("Framework detection index version changed to " + this.myDetectorsVersion);
            }
        }
        int nextId = maxId + 1;
        for (String newDetector : newDetectors.keySet()) {
            this.myDetectorIds.put((Object)newDetector, nextId++);
        }
        this.myDetectorById = new TIntObjectHashMap();
        this.myDetectorsByFileType = new MultiMap();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            int id = this.myDetectorIds.get((Object)detector.getDetectorId());
            this.myDetectorsByFileType.putValue((Object)detector.getFileType(), (Object)id);
            this.myDetectorById.put(id, (Object)detector);
            LOG.debug("'" + detector.getDetectorId() + "' framework detector: id = " + id);
        }
    }

    private void saveDetectors() {
        Path file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)file2)));){
            output.writeInt(0);
            output.writeInt(this.myDetectorsVersion);
            FrameworkDetector[] detectors = (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions();
            output.writeInt(detectors.length);
            for (FrameworkDetector detector : detectors) {
                output.writeUTF(detector.getDetectorId());
                output.writeInt(this.myDetectorIds.get((Object)detector.getDetectorId()));
                output.writeInt(detector.getDetectorVersion());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static Path getDetectorsRegistryFile() {
        return FrameworkDetectorRegistryImpl.getDetectionDirPath().resolve("detectors-registry.dat");
    }

    @NotNull
    public static Path getDetectionDirPath() {
        Path path = PathManagerEx.getAppSystemDir().resolve("frameworks").resolve("detection");
        if (path == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(0);
        }
        return path;
    }

    @Override
    public FrameworkType findFrameworkType(@NotNull String typeId) {
        if (typeId == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(1);
        }
        for (FrameworkType frameworkType : this.getFrameworkTypes()) {
            if (!typeId.equals(frameworkType.getId())) continue;
            return frameworkType;
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends FrameworkType> getFrameworkTypes() {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            types.add(detector.getFrameworkType());
        }
        ArrayList<FrameworkType> arrayList = types;
        if (arrayList == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public int getDetectorsVersion() {
        return this.myDetectorsVersion;
    }

    @Override
    public int getDetectorId(@NotNull FrameworkDetector detector) {
        if (detector == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(3);
        }
        return this.myDetectorIds.get((Object)detector.getDetectorId());
    }

    @Override
    public FrameworkDetector getDetectorById(int id) {
        return (FrameworkDetector)this.myDetectorById.get(id);
    }

    @Override
    @NotNull
    public Collection<Integer> getDetectorIds(@NotNull FileType fileType) {
        if (fileType == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(4);
        }
        Collection collection = this.myDetectorsByFileType.get((Object)fileType);
        if (collection == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    public Collection<Integer> getAllDetectorIds() {
        int[] ids = this.myDetectorIds.getValues();
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        for (int id : ids) {
            result2.add(id);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectionDirPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDetectorId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDetectorIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

