/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.font.FontDesignMetrics;

public abstract class FontLayoutService {
    private static final Logger LOG = Logger.getInstance(FontLayoutService.class);
    private static final FontLayoutService DEFAULT_INSTANCE;
    private static FontLayoutService INSTANCE;

    public static FontLayoutService getInstance() {
        return INSTANCE;
    }

    @NotNull
    public abstract GlyphVector layoutGlyphVector(@NotNull Font var1, @NotNull FontRenderContext var2, @NotNull char[] var3, int var4, int var5, boolean var6);

    public abstract int charWidth(@NotNull FontMetrics var1, char var2);

    public abstract int charWidth(@NotNull FontMetrics var1, int var2);

    public abstract float charWidth2D(@NotNull FontMetrics var1, int var2);

    public abstract int getHeight(@NotNull FontMetrics var1);

    public abstract int getDescent(@NotNull FontMetrics var1);

    public static void setInstance(@Nullable FontLayoutService fontLayoutService) {
        INSTANCE = fontLayoutService == null ? DEFAULT_INSTANCE : fontLayoutService;
    }

    static {
        INSTANCE = DEFAULT_INSTANCE = new DefaultFontLayoutService();
    }

    private static class DefaultFontLayoutService
    extends FontLayoutService {
        private static final int LAYOUT_NO_PAIRED_CHARS_AT_SCRIPT_SPLIT = 8;
        private final Method myHandleCharWidthMethod = ReflectionUtil.getDeclaredMethod(FontDesignMetrics.class, (String)"handleCharWidth", (Class[])new Class[]{Integer.TYPE});

        private DefaultFontLayoutService() {
            if (this.myHandleCharWidthMethod == null) {
                LOG.warn("Couldn't access FontDesignMetrics.handleCharWidth method");
            }
        }

        @Override
        @NotNull
        public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start2, int end, boolean isRtl) {
            if (font == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(0);
            }
            if (fontRenderContext == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(1);
            }
            if (chars == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(2);
            }
            GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, chars, start2, end, (isRtl ? 1 : 0) | 8);
            if (glyphVector == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(3);
            }
            return glyphVector;
        }

        @Override
        public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
            if (fontMetrics == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(4);
            }
            return fontMetrics.charWidth(c);
        }

        @Override
        public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
            if (fontMetrics == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(5);
            }
            return fontMetrics.charWidth(codePoint);
        }

        @Override
        public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
            if (fontMetrics == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(6);
            }
            if (this.myHandleCharWidthMethod != null && fontMetrics instanceof FontDesignMetrics) {
                try {
                    return ((Float)this.myHandleCharWidthMethod.invoke((Object)fontMetrics, codePoint)).floatValue();
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            return this.charWidth(fontMetrics, codePoint);
        }

        @Override
        public int getHeight(@NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(7);
            }
            return fontMetrics.getHeight();
        }

        @Override
        public int getDescent(@NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                DefaultFontLayoutService.$$$reportNull$$$0(8);
            }
            return fontMetrics.getDescent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "font";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontRenderContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/view/FontLayoutService$DefaultFontLayoutService";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "layoutGlyphVector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "layoutGlyphVector";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "charWidth";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "charWidth2D";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeight";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

