/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class IgnoredFilesComponent {
    private final Set<IgnoredFileBean> myFilesToIgnore;
    private final Map<String, IgnoredFileBean> myFilesMap;
    private final Set<String> myDirectoriesManuallyRemovedFromIgnored;
    private final ReadWriteLock myLock;
    private final Lock myReadLock;
    private final Lock myWriteLock;
    private final Project myProject;

    public IgnoredFilesComponent(@NotNull Project project, boolean registerListener) {
        if (project == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myReadLock = this.myLock.readLock();
        this.myWriteLock = this.myLock.writeLock();
        this.myProject = project;
        this.myFilesToIgnore = new LinkedHashSet<IgnoredFileBean>();
        this.myFilesMap = new THashMap();
        if (registerListener) {
            project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.hasSignificantChanges(events)) {
                        IgnoredFilesComponent.this.resetCaches();
                    }
                }

                private <T extends VFileEvent> boolean hasSignificantChanges(List<T> events) {
                    return ContainerUtil.exists(events, event -> !(event instanceof VFileContentChangeEvent));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent$1", "after"));
                }
            });
        }
        this.myDirectoriesManuallyRemovedFromIgnored = new THashSet();
    }

    private IgnoredFilesComponent(@NotNull IgnoredFilesComponent other) {
        if (other == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(1);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myReadLock = this.myLock.readLock();
        this.myWriteLock = this.myLock.writeLock();
        this.myProject = other.myProject;
        this.myFilesToIgnore = new LinkedHashSet<IgnoredFileBean>(other.myFilesToIgnore);
        this.myFilesMap = new HashMap<String, IgnoredFileBean>(other.myFilesMap);
        this.myDirectoriesManuallyRemovedFromIgnored = new HashSet<String>(other.myDirectoriesManuallyRemovedFromIgnored);
    }

    public void add(IgnoredFileBean ... filesToIgnore) {
        this.myWriteLock.lock();
        try {
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
            this.addIgnoredFiles(filesToIgnore);
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    public Set<String> getDirectoriesManuallyRemovedFromIgnored() {
        return Collections.unmodifiableSet(this.myDirectoriesManuallyRemovedFromIgnored);
    }

    public void setDirectoriesManuallyRemovedFromIgnored(Set<String> directories) {
        this.myDirectoriesManuallyRemovedFromIgnored.clear();
        this.myDirectoriesManuallyRemovedFromIgnored.addAll(directories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoredDirectoryImplicitly(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(2);
        }
        if (project == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(3);
        }
        this.myWriteLock.lock();
        try {
            if (this.myDirectoriesManuallyRemovedFromIgnored.contains(path) || this.myDirectoriesManuallyRemovedFromIgnored.contains(path + "/")) {
                return;
            }
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (bean.getType() != IgnoreSettingsType.UNDER_DIR || !FileUtil.isAncestor((String)bean.getPath(), (String)path, (boolean)false)) continue;
                return;
            }
            this.doRemoveFilesToIgnore(path, true);
            this.myFilesToIgnore.add(IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project));
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(4);
        }
        if (project == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(5);
        }
        this.myWriteLock.lock();
        try {
            this.doRemoveFilesToIgnore(path, false);
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    private void doRemoveFilesToIgnore(@NotNull String path, boolean includingSubpaths) {
        if (path == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(6);
        }
        ArrayList<IgnoredFileBean> toRemove2 = new ArrayList<IgnoredFileBean>();
        for (IgnoredFileBean bean : this.myFilesToIgnore) {
            if (!((bean.getType() == IgnoreSettingsType.UNDER_DIR || bean.getType() == IgnoreSettingsType.FILE) && includingSubpaths ? FileUtil.isAncestor((String)path, (String)bean.getPath(), (boolean)false) : FileUtil.pathsEqual((String)path, (String)bean.getPath()))) continue;
            toRemove2.add(bean);
        }
        this.myFilesToIgnore.removeAll(toRemove2);
    }

    private void addIgnoredFiles(@NotNull IgnoredFileBean[] filesToIgnore) {
        if (filesToIgnore == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(7);
        }
        for (IgnoredFileBean bean : filesToIgnore) {
            Project project;
            VirtualFile baseDir;
            if (!IgnoreSettingsType.FILE.equals((Object)bean.getType()) || (baseDir = (project = bean.getProject()).getBaseDir()) == null) continue;
            this.myFilesMap.put(FilePathsHelper.convertPath((String)baseDir.getPath(), (String)bean.getPath()), bean);
        }
    }

    public void clear() {
        this.myWriteLock.lock();
        try {
            this.myFilesToIgnore.clear();
            this.myFilesMap.clear();
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.myReadLock.lock();
        try {
            boolean bl = this.myFilesToIgnore.isEmpty();
            return bl;
        }
        finally {
            this.myReadLock.unlock();
        }
    }

    public void set(IgnoredFileBean ... filesToIgnore) {
        this.myWriteLock.lock();
        try {
            this.myFilesToIgnore.clear();
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
            this.myFilesMap.clear();
            this.addIgnoredFiles(filesToIgnore);
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    @NotNull
    public IgnoredFileBean[] getFilesToIgnore() {
        IgnoredFileBean[] ignoredFileBeanArray;
        block3: {
            this.myReadLock.lock();
            ignoredFileBeanArray = this.myFilesToIgnore.toArray(new IgnoredFileBean[0]);
            if (ignoredFileBeanArray != null) break block3;
            IgnoredFilesComponent.$$$reportNull$$$0(8);
        }
        return ignoredFileBeanArray;
        finally {
            this.myReadLock.unlock();
        }
    }

    private void resetCaches() {
        this.myWriteLock.lock();
        try {
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                bean.resetCache();
            }
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIgnoredFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            IgnoredFilesComponent.$$$reportNull$$$0(9);
        }
        this.myReadLock.lock();
        try {
            if (this.myFilesToIgnore.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            String path = FilePathsHelper.convertPath((FilePath)filePath);
            IgnoredFileBean fileBean = this.myFilesMap.get(path);
            VirtualFile file2 = filePath.getVirtualFile();
            if (file2 == null) {
                boolean bl = false;
                return bl;
            }
            if (fileBean != null && fileBean.matchesFile(file2)) {
                boolean bl = true;
                return bl;
            }
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (!bean.matchesFile(file2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myReadLock.unlock();
        }
    }

    public IgnoredFilesComponent copy() {
        return new IgnoredFilesComponent(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/IgnoredFilesComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredFilesComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredDirectoryImplicitly";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeImplicitlyIgnoredDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveFilesToIgnore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredFiles";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

