/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DuplicateParentFixer {
    public static <CommitId> AbstractList<? extends GraphCommit<CommitId>> fixDuplicateParentCommits(final List<? extends GraphCommit<CommitId>> finalCommits) {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                return DuplicateParentFixer.fixParentsDuplicate((GraphCommit)finalCommits.get(index));
            }

            @Override
            public int size() {
                return finalCommits.size();
            }
        };
    }

    @NotNull
    private static <CommitId> GraphCommit<CommitId> fixParentsDuplicate(@NotNull GraphCommit<CommitId> commit) {
        List parents;
        if (commit == null) {
            DuplicateParentFixer.$$$reportNull$$$0(0);
        }
        if ((parents = commit.getParents()).size() <= 1) {
            GraphCommit<CommitId> graphCommit = commit;
            if (graphCommit == null) {
                DuplicateParentFixer.$$$reportNull$$$0(1);
            }
            return graphCommit;
        }
        if (parents.size() == 2) {
            Object commitId0 = parents.get(0);
            if (!commitId0.equals(parents.get(1))) {
                GraphCommit<CommitId> graphCommit = commit;
                if (graphCommit == null) {
                    DuplicateParentFixer.$$$reportNull$$$0(2);
                }
                return graphCommit;
            }
            DelegateGraphCommit delegateGraphCommit = new DelegateGraphCommit(commit, Collections.singletonList(commitId0));
            if (delegateGraphCommit == null) {
                DuplicateParentFixer.$$$reportNull$$$0(3);
            }
            return delegateGraphCommit;
        }
        HashSet allParents = new HashSet(parents);
        if (parents.size() == allParents.size()) {
            GraphCommit<CommitId> graphCommit = commit;
            if (graphCommit == null) {
                DuplicateParentFixer.$$$reportNull$$$0(4);
            }
            return graphCommit;
        }
        ArrayList correctParents = ContainerUtil.newArrayList();
        for (Object commitId : parents) {
            if (!allParents.remove(commitId)) continue;
            correctParents.add(commitId);
        }
        DelegateGraphCommit delegateGraphCommit = new DelegateGraphCommit(commit, correctParents);
        if (delegateGraphCommit == null) {
            DuplicateParentFixer.$$$reportNull$$$0(5);
        }
        return delegateGraphCommit;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fixParentsDuplicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixParentsDuplicate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegateGraphCommit<CommitId>
    implements GraphCommit<CommitId> {
        @NotNull
        private final GraphCommit<CommitId> myDelegate;
        @NotNull
        private final List<CommitId> myParents;

        private DelegateGraphCommit(@NotNull GraphCommit<CommitId> delegate, @NotNull List<CommitId> parents) {
            if (delegate == null) {
                DelegateGraphCommit.$$$reportNull$$$0(0);
            }
            if (parents == null) {
                DelegateGraphCommit.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate;
            this.myParents = parents;
        }

        @NotNull
        public CommitId getId() {
            Object object = this.myDelegate.getId();
            if (object == null) {
                DelegateGraphCommit.$$$reportNull$$$0(2);
            }
            return (CommitId)object;
        }

        @NotNull
        public List<CommitId> getParents() {
            List<CommitId> list2 = this.myParents;
            if (list2 == null) {
                DelegateGraphCommit.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public long getTimestamp() {
            return this.myDelegate.getTimestamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parents";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

