/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiQualifiedReference;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/inspection/JSObjectNullOrUndefinedInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "intellij.javascript.impl"})
public class JSObjectNullOrUndefinedInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return (PsiElementVisitor)new JSElementVisitor(this, holder){
            final /* synthetic */ JSObjectNullOrUndefinedInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiElement parent = node.getParent();
                if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node || parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == node) {
                    this.checkNullabilityState(node);
                }
            }

            private final void checkNullabilityState(JSReferenceExpression candidate) {
                if (!JSTypeGuardChecker.isNarrowableReference((JSExpression)candidate)) {
                    return;
                }
                JSType jSType = JSTypeGuardChecker.getExactType(JSResolveUtil.getElementJSTypeWithInferredDecorators((PsiElement)candidate));
                if (jSType == null) {
                    return;
                }
                JSType expressionJSType = jSType;
                if (TypeScriptTypeRelations.hasExplicitDecorators(expressionJSType, JSTypeGuardChecker.NULL_OR_UNDEFINED)) {
                    JSReferenceExpression jSReferenceExpression = candidate;
                    if (jSReferenceExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                    }
                    this.$holder.registerProblem((PsiElement)jSReferenceExpression, JSBundle.message((String)"javascript.object.is.null.or.undefined", (Object[])new Object[]{this.getReferenceName(candidate)}), this.this$0.problemHighlightType(), new LocalQuickFix[0]);
                    return;
                }
                if (TypeScriptTypeRelations.hasExplicitDecorators(expressionJSType, (Set<JSDecoratedType.TypeDecoration>)EnumSet.of((Enum)JSDecoratedType.TypeDecoration.INFERRED_NULL))) {
                    JSReferenceExpression jSReferenceExpression = candidate;
                    if (jSReferenceExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                    }
                    this.$holder.registerProblem((PsiElement)jSReferenceExpression, JSBundle.message((String)"javascript.object.is.null", (Object[])new Object[]{this.getReferenceName(candidate)}), this.this$0.problemHighlightType(), new LocalQuickFix[0]);
                    return;
                }
                if (TypeScriptTypeRelations.hasExplicitDecorators(expressionJSType, (Set<JSDecoratedType.TypeDecoration>)EnumSet.of((Enum)JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED))) {
                    JSReferenceExpression jSReferenceExpression = candidate;
                    if (jSReferenceExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                    }
                    this.$holder.registerProblem((PsiElement)jSReferenceExpression, JSBundle.message((String)"javascript.object.is.undefined", (Object[])new Object[]{this.getReferenceName(candidate)}), this.this$0.problemHighlightType(), new LocalQuickFix[0]);
                    return;
                }
            }

            @NotNull
            public final String getReferenceName(@NotNull JSReferenceExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                Object object = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression);
                if (object == null || (object = object.getQualifiedName()) == null) {
                    object = "Object";
                }
                return object;
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    protected ProblemHighlightType problemHighlightType() {
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }
}

