/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6MakeFunctionAsyncFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PossiblyAsyncFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSFunction parentFunction;
                if (!DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.ASYNC_AWAIT)) {
                    return;
                }
                if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "await") && (parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null && node.resolve() == null) {
                    this.registerProblem((PsiElement)node, parentFunction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
                super.visitJSReferenceExpression(node);
            }

            private void registerProblem(@NotNull PsiElement node, @Nullable JSFunction parentFunction, ProblemHighlightType severity) {
                LocalQuickFix[] localQuickFixArray;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parentFunction != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new ES6MakeFunctionAsyncFix(parentFunction);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                holder.registerProblem(node, JSBundle.message((String)"js.possibly.async.function.error.description", (Object[])new Object[0]), severity, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection$1", "registerProblem"));
            }
        };
        if (jSElementVisitor == null) {
            ES6PossiblyAsyncFunctionInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6PossiblyAsyncFunctionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

