/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.util.ProcessingContext;
import java.math.BigInteger;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBigIntLiteralTypeImpl
extends JSBigIntType
implements JSPrimitiveLiteralType<BigInteger> {
    private final BigInteger myLiteral;
    private final boolean myAllowWidening;
    @Nullable
    private final String myValueAsString;

    public JSBigIntLiteralTypeImpl(BigInteger literal, boolean allowWidening, @NotNull JSTypeSource source, @Nullable String valueAsString) {
        if (source == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
        this.myValueAsString = valueAsString;
    }

    public JSBigIntLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource, inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
        String value = JSTypeSerializer.readString(inputStream);
        BigInteger bigInt = JSNumberParser.tryParseBigInt(value);
        this.myLiteral = bigInt != null ? bigInt : BigInteger.ZERO;
        this.myValueAsString = value;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
        JSTypeSerializer.writeString(this.getValueAsString(), outputStream);
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("BigInt" == null) {
                JSBigIntLiteralTypeImpl.$$$reportNull$$$0(4);
            }
            return "BigInt";
        }
        String stringVal = this.getValueAsString();
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string = this.isTypeScript() && (!this.allowWidening() || format != JSType.TypeTextFormat.CODE) ? stringVal : "bigint";
            if (string == null) {
                JSBigIntLiteralTypeImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = "BigInt(" + stringVal + ")";
        if (string == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (elementType instanceof JSBigIntLiteralTypeImpl && this.isSourceStrict() && !this.myAllowWidening) {
            return this.myLiteral.equals(((JSBigIntLiteralTypeImpl)elementType).myLiteral);
        }
        if (!this.myAllowWidening && elementType instanceof JSBigIntType) {
            return this.isJavaScript();
        }
        if (!this.myAllowWidening && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                BigInteger numericValue = value.getBigIntValue();
                return numericValue != null && numericValue.equals(this.myLiteral);
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myLiteral.equals(((JSBigIntLiteralTypeImpl)type).myLiteral);
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.getValueAsString();
        if (string == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getValueAsString() {
        String string = this.myValueAsString != null ? this.myValueAsString : this.myLiteral.toString();
        if (string == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public BigInteger getLiteral() {
        BigInteger bigInteger = this.myLiteral;
        if (bigInteger == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return bigInteger;
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        if ("bigint" == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(13);
        }
        return "bigint";
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    public boolean isWidened() {
        return false;
    }

    @Override
    @NotNull
    protected JSBigIntLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(14);
        }
        JSBigIntLiteralTypeImpl jSBigIntLiteralTypeImpl = new JSBigIntLiteralTypeImpl(this.getLiteral(), this.myAllowWidening, source, this.myValueAsString);
        if (jSBigIntLiteralTypeImpl == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(15);
        }
        return jSBigIntLiteralTypeImpl;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSBigIntLiteralTypeImpl jSBigIntLiteralTypeImpl = this;
            if (jSBigIntLiteralTypeImpl == null) {
                JSBigIntLiteralTypeImpl.$$$reportNull$$$0(16);
            }
            return jSBigIntLiteralTypeImpl;
        }
        JSBigIntLiteralTypeImpl jSBigIntLiteralTypeImpl = new JSBigIntLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource(), this.myValueAsString);
        if (jSBigIntLiteralTypeImpl == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(17);
        }
        return jSBigIntLiteralTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBigIntLiteralTypeImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBigIntLiteralTypeImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

