/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipExceptionData;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.WipProtocolReader;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u001f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00105\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u00106\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u001e\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u000f2\b\u0010<\u001a\u0004\u0018\u00010=R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\t0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R\u0011\u0010(\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R(\u0010*\u001a\u0004\u0018\u00010\u00022\b\u0010)\u001a\u0004\u0018\u00010\u0002@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006>"}, d2={"Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "data", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "(Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/protocol/debugger/PausedEventData;)V", "_asyncFrames", "", "Lorg/jetbrains/wip/WipAsyncCallFrame;", "[Lorg/jetbrains/wip/WipAsyncCallFrame;", "_frames", "[Lorg/jetbrains/wip/WipCallFrame;", "breakpointsHit", "", "Lorg/jetbrains/debugger/Breakpoint;", "getBreakpointsHit", "()Ljava/util/List;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getExceptionData", "()Lorg/jetbrains/debugger/ExceptionData;", "setExceptionData", "(Lorg/jetbrains/debugger/ExceptionData;)V", "frames", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/CallFrame;", "getFrames", "()Lorg/jetbrains/concurrency/Promise;", "framesLoader", "org/jetbrains/wip/WipSuspendContext$framesLoader$1", "Lorg/jetbrains/wip/WipSuspendContext$framesLoader$1;", "hasUnresolvedBreakpointsHit", "", "getHasUnresolvedBreakpointsHit", "()Z", "hitBreakpoints", "", "isBreakOnFirstStatement", "isBreakOnStart", "value", "topFrame", "getTopFrame", "()Lorg/jetbrains/wip/WipCallFrame;", "setTopFrame", "(Lorg/jetbrains/wip/WipCallFrame;)V", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "getValueManager", "()Lorg/jetbrains/wip/WipValueManager;", "getVm", "()Lorg/jetbrains/wip/WipVm;", "isInstrumentationBreakpoint", "isMeteorOnStartDebuggerStatement", "reloadFrames", "setFrames", "", "frameDataList", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "asyncFrameDataList", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "intellij.javascript.wip.backend"})
public final class WipSuspendContext
implements SuspendContext<WipCallFrame> {
    @NotNull
    private final WipValueManager valueManager;
    private final List<String> hitBreakpoints;
    @Nullable
    private volatile WipCallFrame topFrame;
    private volatile WipCallFrame[] _frames;
    private volatile WipAsyncCallFrame[] _asyncFrames;
    @Nullable
    private ExceptionData exceptionData;
    private final boolean isBreakOnStart;
    private final boolean isBreakOnFirstStatement;
    private final framesLoader.1 framesLoader;
    @NotNull
    private final WipVm vm;

    @NotNull
    public WipValueManager getValueManager() {
        return this.valueManager;
    }

    @Nullable
    public WipCallFrame getTopFrame() {
        return this.topFrame;
    }

    private void setTopFrame(WipCallFrame value) {
        this.topFrame = value;
    }

    @Nullable
    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public void setExceptionData(@Nullable ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    public final boolean isBreakOnStart() {
        return this.isBreakOnStart;
    }

    public final boolean isBreakOnFirstStatement() {
        return this.isBreakOnFirstStatement;
    }

    @NotNull
    public Promise<CallFrame[]> getFrames() {
        Promise promise2 = this.framesLoader.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"framesLoader.get()");
        return promise2;
    }

    private final boolean isInstrumentationBreakpoint(PausedEventData data) {
        block6: {
            PausedEventData.Data additionalData = data.getData();
            if (data.reason() == PausedEventData.Reason.EVENT_LISTENER && additionalData != null) {
                try {
                    JsonReaderEx reader = additionalData.getDeferredReader();
                    if (reader.peek() != JsonToken.BEGIN_OBJECT) break block6;
                    reader.beginObject();
                    while (reader.peek() == JsonToken.NAME) {
                        String name = reader.nextName();
                        if (Intrinsics.areEqual((Object)name, (Object)"eventName")) {
                            if (reader.peek() == JsonToken.STRING && Intrinsics.areEqual((Object)reader.nextString(), (Object)"instrumentation:scriptFirstStatement")) {
                                return true;
                            }
                            break;
                        }
                        reader.skipValue();
                    }
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private final boolean isMeteorOnStartDebuggerStatement(PausedEventData data) {
        WipScript script;
        org.jetbrains.wip.protocol.debugger.CallFrameValue topFrame;
        if (Intrinsics.areEqual((Object)((Boolean)this.getVm().getUserData(WipSuspendContextKt.getIS_METEOR())), (Object)true) ^ true) {
            return false;
        }
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        if (!callFrames.isEmpty() && Intrinsics.areEqual((Object)(topFrame = callFrames.get(0)).functionName(), (Object)"exports.pause") && (script = (WipScript)this.getVm().getScriptManager().findScriptById(topFrame.location().scriptId())) != null) {
            String string = script.getUrl().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.url.path");
            if (StringsKt.endsWith$default((String)string, (String)"/debug.js", (boolean)false, (int)2, null)) {
                Thread.sleep(102L);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrames(@NotNull List<? extends org.jetbrains.wip.protocol.debugger.CallFrameValue> frameDataList, @Nullable StackTraceValue asyncFrameDataList) {
        void $receiver$iv;
        int n;
        WipCallFrame wipCallFrame;
        Object object;
        Intrinsics.checkParameterIsNotNull(frameDataList, (String)"frameDataList");
        int size$iv22 = frameDataList.size();
        WipCallFrame[] result$iv = new WipCallFrame[size$iv22];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            void it;
            void i$iv;
            void var8_18 = i$iv;
            void var18_14 = i$iv++;
            object = result$iv;
            object[var18_14] = wipCallFrame = new WipCallFrame(this.getValueManager(), frameDataList.get((int)it));
        }
        WipCallFrame[] frames = result$iv;
        WipCallFrame[] size$iv22 = frames;
        if (!((result$iv = size$iv22).length == 0)) {
            this.setTopFrame(frames[0]);
        }
        this._frames = frames;
        List asyncFrames = new ArrayList();
        for (StackTraceValue currentStackTrace = asyncFrameDataList; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            String description = currentStackTrace.getDescription();
            Iterable $receiver$iv2 = currentStackTrace.callFrames();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                void callFrameValue;
                if ((n = index$iv++) < 0) {
                    throw (Throwable)new ArithmeticException("Index overflow has happened.");
                }
                int n4 = n;
                CallFrameValue callFrameValue2 = (CallFrameValue)item$iv;
                int i = n4;
                asyncFrames.add(new WipAsyncCallFrame((CallFrameValue)callFrameValue, i == 0 ? description : null));
            }
        }
        Collection description = asyncFrames;
        object = this;
        void thisCollection$iv = $receiver$iv;
        WipAsyncCallFrame[] wipAsyncCallFrameArray = thisCollection$iv.toArray(new WipAsyncCallFrame[0]);
        if (wipAsyncCallFrameArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        WipAsyncCallFrame[] wipAsyncCallFrameArray2 = wipAsyncCallFrameArray;
        object._asyncFrames = wipAsyncCallFrameArray2;
        int size$iv = frames.length + asyncFrames.size();
        CallFrame[] result$iv2 = new CallFrame[size$iv];
        int n5 = 0;
        int n6 = result$iv2.length;
        while (n5 < n6) {
            void it;
            void i$iv;
            n = i$iv;
            void var18_16 = i$iv;
            object = result$iv2;
            object[var18_16] = wipCallFrame = it < frames.length ? (CallFrame)frames[it] : (CallFrame)asyncFrames.get((int)(it - frames.length));
            ++i$iv;
        }
        CallFrame[] result = result$iv2;
        this.framesLoader.set(result);
    }

    public boolean getHasUnresolvedBreakpointsHit() {
        if (UtilKt.isNullOrEmpty((Collection)this.hitBreakpoints)) {
            return false;
        }
        THashSet hitVmBreakpoints = new THashSet((Collection)this.hitBreakpoints);
        for (WipBreakpoint breakpoint : this.getValueManager().getVm().getBreakpointManager().getBreakpoints()) {
            hitVmBreakpoints.remove((Object)breakpoint.getVmId());
        }
        Collection collection = (Collection)hitVmBreakpoints;
        return !collection.isEmpty();
    }

    @NotNull
    public List<Breakpoint> getBreakpointsHit() {
        Set breakpoints = this.getValueManager().getVm().getBreakpointManager().getBreakpoints();
        if (this.hitBreakpoints != null) {
            SmartList result = new SmartList();
            for (WipBreakpoint breakpoint : breakpoints) {
                String vmId = breakpoint.getVmId();
                if (vmId == null || !this.hitBreakpoints.contains(vmId)) continue;
                result.add((Object)breakpoint);
            }
            return (List)result;
        }
        WipCallFrame wipCallFrame = this.getTopFrame();
        if (wipCallFrame == null) {
            return CollectionsKt.emptyList();
        }
        WipCallFrame topFrame = wipCallFrame;
        int line = topFrame.getLine();
        int column = topFrame.getColumn();
        List result = null;
        block1: for (WipBreakpoint breakpoint : breakpoints) {
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                int actualColumnNumber = actualLocation.getColumnNumber();
                if (!Intrinsics.areEqual((Object)actualLocation.scriptId(), (Object)topFrame.getScriptId()) || actualLocation.getLineNumber() != line || actualColumnNumber != column && actualColumnNumber > 0) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(breakpoint);
                continue block1;
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> reloadFrames() {
        this.framesLoader.markDirty();
        SmartList promises = new SmartList();
        if (this._frames == null) {
            Intrinsics.throwNpe();
        }
        for (WipCallFrame frame : this._frames) {
            for (ScopeValue scopeValue : frame.getScopesData()) {
                WipCommandProcessor wipCommandProcessor = this.getValueManager().getCommandProcessor();
                String string = scopeValue.object().getObjectId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                promises.add((Object)wipCommandProcessor.send((Request)RuntimeKt.ReleaseObject(string)));
            }
        }
        promises.add((Object)this.framesLoader.get());
        Promise $receiver$iv = Promises.all((Collection)((Collection)promises));
        Promise promise2 = $receiver$iv.then(new Function<Unit, SUB_RESULT>(this){
            final /* synthetic */ WipSuspendContext this$0;
            {
                this.this$0 = wipSuspendContext;
            }

            public final Unit fun(@Nullable Object it) {
                this.this$0.getValueManager().clearCaches();
                return Unit.INSTANCE;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"(this as Promise<Any?>).then { handler() }");
        return promise2;
    }

    @NotNull
    public WipVm getVm() {
        return this.vm;
    }

    public WipSuspendContext(@NotNull WipVm vm, @NotNull PausedEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.vm = vm;
        this.valueManager = new WipValueManager(this.getVm(), null);
        this.framesLoader = new AsyncValueLoader<CallFrame[]>(this){
            final /* synthetic */ WipSuspendContext this$0;

            @NotNull
            protected Promise<CallFrame[]> load(@NotNull AsyncPromise<CallFrame[]> result) {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                WipCallFrame[] wipCallFrameArray = WipSuspendContext.access$get_frames$p(this.this$0);
                if (wipCallFrameArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.CallFrame>");
                }
                WipAsyncCallFrame[] wipAsyncCallFrameArray = WipSuspendContext.access$get_asyncFrames$p(this.this$0);
                if (wipAsyncCallFrameArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.CallFrame>");
                }
                return Promises.resolvedPromise((Object)ArraysKt.plus((Object[])wipCallFrameArray, (Object[])wipAsyncCallFrameArray));
            }
            {
                this.this$0 = $outer;
            }
        };
        PausedEventData.Data additionalData = data.getData();
        if (data.reason() == PausedEventData.Reason.EXCEPTION && additionalData != null) {
            WipValueManager wipValueManager = this.getValueManager();
            WipProtocolReader wipProtocolReader = WipReaderService.get();
            JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonReaderEx, (String)"additionalData.deferredReader");
            this.setExceptionData(new WipExceptionData(wipValueManager.createValue(wipProtocolReader.parseRemoteObjectValue(jsonReaderEx))));
        } else {
            this.setExceptionData(null);
        }
        Object isFirstPauseMarker = new Object();
        boolean isFirstPause = UtilKt.isNullOrEmpty((Collection)data.getHitBreakpoints()) && Intrinsics.areEqual((Object)this.getVm().putUserDataIfAbsent(WipSuspendContextKt.access$getIS_FIRST_PAUSE$p(), isFirstPauseMarker), (Object)isFirstPauseMarker);
        this.isBreakOnStart = data.reason() == PausedEventData.Reason.BREAK_ON_START || isFirstPause && Intrinsics.areEqual((Object)((Boolean)this.getVm().getUserData(WipSuspendContextKt.getSKIP_FIRST_PAUSE())), (Object)true);
        this.isBreakOnFirstStatement = this.isInstrumentationBreakpoint(data) || this.isMeteorOnStartDebuggerStatement(data);
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        this.setFrames(callFrames, data.getAsyncStackTrace());
        this.hitBreakpoints = data.getHitBreakpoints();
    }

    @Nullable
    public Script getScript() {
        return SuspendContext.DefaultImpls.getScript((SuspendContext)this);
    }

    @Nullable
    public static final /* synthetic */ WipCallFrame[] access$get_frames$p(WipSuspendContext $this) {
        return $this._frames;
    }

    public static final /* synthetic */ void access$set_frames$p(WipSuspendContext $this, @Nullable WipCallFrame[] wipCallFrameArray) {
        $this._frames = wipCallFrameArray;
    }

    @Nullable
    public static final /* synthetic */ WipAsyncCallFrame[] access$get_asyncFrames$p(WipSuspendContext $this) {
        return $this._asyncFrames;
    }

    public static final /* synthetic */ void access$set_asyncFrames$p(WipSuspendContext $this, @Nullable WipAsyncCallFrame[] wipAsyncCallFrameArray) {
        $this._asyncFrames = wipAsyncCallFrameArray;
    }
}

