/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001TB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0015\u0010\t\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR!\u0010E\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030G\u0012\u0004\u0012\u00020\u00010F\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0013\u0010J\u001a\u0004\u0018\u00010K8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0013\u0010N\u001a\u0004\u0018\u00010O8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010S\u00a8\u0006U"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "helper", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/script/generator/ScriptingTask;Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;)V", "adapter", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "getAdapter", "()Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "builder", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/script/generator/CodeTextBuilder;", "bySource", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/ElementDelta;", "getBySource", "()Ljava/util/HashMap;", "byTarget", "getByTarget", "currentDatabaseName", "", "getCurrentDatabaseName", "()Ljava/lang/String;", "setCurrentDatabaseName", "(Ljava/lang/String;)V", "currentSchemaName", "getCurrentSchemaName", "setCurrentSchemaName", "getHelper", "()Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "getLocus", "()Lcom/intellij/database/script/generator/ScriptLocus;", "setLocus", "(Lcom/intellij/database/script/generator/ScriptLocus;)V", "model", "Lcom/intellij/database/model/basic/BasicModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "naming", "Lcom/intellij/database/script/generator/NamingService;", "getNaming", "()Lcom/intellij/database/script/generator/NamingService;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/script/generator/ScriptingOptions;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "result", "Lcom/intellij/database/script/generator/ScriptingResult;", "getResult", "()Lcom/intellij/database/script/generator/ScriptingResult;", "setResult", "(Lcom/intellij/database/script/generator/ScriptingResult;)V", "script", "", "Lcom/intellij/database/script/CompositeText;", "getScript", "()Ljava/util/List;", "sharedData", "", "Lcom/intellij/openapi/util/Key;", "getSharedData", "()Ljava/util/Map;", "sqlDef", "Lcom/intellij/lang/ParserDefinition;", "getSqlDef", "()Lcom/intellij/lang/ParserDefinition;", "sqlLang", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSqlLang", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getTask", "()Lcom/intellij/database/script/generator/ScriptingTask;", "NewCodingAdapter", "intellij.database.dialects"})
public final class ScriptingContext {
    @Nullable
    private String currentDatabaseName;
    @Nullable
    private String currentSchemaName;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private final List<CompositeText> script;
    @Nullable
    private ScriptingResult result;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private final NewCodingAdapter adapter;
    @NotNull
    private ScriptLocus locus;
    @NotNull
    private final NamingService naming;
    @NotNull
    private final Map<Key<?>, Object> sharedData;
    @NotNull
    private final HashMap<BasicElement, ElementDelta<?>> bySource;
    @NotNull
    private final HashMap<BasicElement, ElementDelta<?>> byTarget;
    @NotNull
    private final Project project;
    @NotNull
    private final ScriptingTask task;
    @NotNull
    private final ScriptGeneratorHelper helper;

    @NotNull
    public final BasicModel getModel() {
        BasicModel basicModel = ScriptingTaskKt.getAnyModel(this.task);
        if (basicModel == null) {
            Intrinsics.throwNpe();
        }
        return basicModel;
    }

    @Nullable
    public final String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    public final void setCurrentDatabaseName(@Nullable String string) {
        this.currentDatabaseName = string;
    }

    @Nullable
    public final String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public final void setCurrentSchemaName(@Nullable String string) {
        this.currentSchemaName = string;
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final List<CompositeText> getScript() {
        return this.script;
    }

    @Nullable
    public final ScriptingResult getResult() {
        return this.result;
    }

    public final void setResult(@Nullable ScriptingResult scriptingResult) {
        this.result = scriptingResult;
    }

    @NotNull
    public final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final NewCodingAdapter getAdapter() {
        return this.adapter;
    }

    @NotNull
    public final ScriptLocus getLocus() {
        return this.locus;
    }

    public final void setLocus(@NotNull ScriptLocus scriptLocus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)scriptLocus), (String)"<set-?>");
        this.locus = scriptLocus;
    }

    @NotNull
    public final NamingService getNaming() {
        return this.naming;
    }

    @Nullable
    public final SqlLanguageDialect getSqlLang() {
        return this.helper.getSqlLang();
    }

    @Nullable
    public final ParserDefinition getSqlDef() {
        return this.helper.getSqlDef();
    }

    @NotNull
    public final Map<Key<?>, Object> getSharedData() {
        return this.sharedData;
    }

    @NotNull
    public final HashMap<BasicElement, ElementDelta<?>> getBySource() {
        return this.bySource;
    }

    @NotNull
    public final HashMap<BasicElement, ElementDelta<?>> getByTarget() {
        return this.byTarget;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptingTask getTask() {
        return this.task;
    }

    @NotNull
    public final ScriptGeneratorHelper getHelper() {
        return this.helper;
    }

    public ScriptingContext(@NotNull Project project, @NotNull ScriptingTask task, @NotNull ScriptGeneratorHelper helper) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        this.project = project;
        this.task = task;
        this.helper = helper;
        BasicDatabase basicDatabase = ScriptingTaskKt.getAnyCurrentDatabase(this.task);
        this.currentDatabaseName = basicDatabase != null ? basicDatabase.getRealName() : null;
        BasicSchema basicSchema = ScriptingTaskKt.getAnyCurrentSchema(this.task);
        this.currentSchemaName = basicSchema != null ? basicSchema.getRealName() : null;
        this.options = this.task.getOptions();
        this.script = new ArrayList();
        this.builder = new CodeTextBuilder(0, 1, null);
        this.adapter = new NewCodingAdapter();
        this.locus = ScriptLocus.OUTSIDE;
        this.naming = this.helper.getNamingService$intellij_database_dialects(ScriptingTaskKt.getAnyModel(this.task), ScriptingTaskKt.getAnyCurrentDatabase(this.task));
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap()");
        this.sharedData = hashMap;
        this.bySource = new HashMap();
        this.byTarget = new HashMap();
        ScriptingTask scriptingTask = this.task;
        if (!(scriptingTask instanceof ScriptingAlterTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingAlterTask)scriptingTask) != null && (object = ((ScriptingAlterTask)object).getCorrespondence()) != null) {
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                ElementDelta elementDelta;
                Map map;
                Object it;
                Object t;
                ElementDelta d2 = (ElementDelta)element$iv;
                if (d2.getSourceElement() != null) {
                    it = t;
                    map = this.bySource;
                    elementDelta = d2;
                    map.put(it, elementDelta);
                }
                if (d2.getTargetElement() != null) {
                    it = t;
                    map = this.byTarget;
                    elementDelta = d2;
                    map.put(it, elementDelta);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u0006\u0010)\u001a\u00020\u0005J\u001a\u0010*\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010+\u001a\u00020(J\u0006\u0010,\u001a\u00020\u0005J\u0019\u0010-\u001a\u00020\u00052\u000e\b\u0004\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ\u0019\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u00100\u001a\u0004\u0018\u00010(H\u0086\bJ\u0006\u00101\u001a\u00020\u0005J\u0006\u00102\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\b\u00103\u001a\u00020\u0005H\u0002J)\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010#\u001a\u0004\u0018\u00010(2\u000e\b\u0004\u00105\u001a\b\u0012\u0004\u0012\u00020(0\u0004H\u0086\bJ\u001c\u00106\u001a\u0004\u0018\u00010(2\u0006\u00107\u001a\u0002082\n\b\u0002\u0010/\u001a\u0004\u0018\u00010(J\u001a\u00106\u001a\u0004\u0018\u00010(2\b\u0010#\u001a\u0004\u0018\u00010(2\u0006\u00109\u001a\u00020\tJ\u0019\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010;\u001a\u0004\u0018\u000108H\u0086\bJ!\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010#\u001a\u0004\u0018\u00010(2\u0006\u00109\u001a\u00020\tH\u0086\bJ!\u0010<\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ\u0013\u0010=\u001a\u00020\u00052\b\u0010>\u001a\u0004\u0018\u00010?H\u0086\bJ\u0006\u0010@\u001a\u00020\u0005J\u001d\u0010A\u001a\u00060\u0000R\u00020B2\u000e\b\u0004\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ\u0006\u0010C\u001a\u00020\u0005J!\u0010D\u001a\u00020\u00052\b\b\u0002\u0010E\u001a\u00020\t2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ?\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010G*\b\u0012\u0004\u0012\u0002HG0H2\b\b\u0002\u0010I\u001a\u00020(2\u0014\b\u0004\u0010J\u001a\u000e\u0012\u0004\u0012\u0002HG\u0012\u0004\u0012\u00020\u00050KH\u0086\bJ%\u0010L\u001a\u00060\u0000R\u00020B*\u00060\u0000R\u00020B2\u000e\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\u0002J\u001f\u0010L\u001a\u00060\u0000R\u00020B*\u00060\u0000R\u00020B2\b\u0010J\u001a\u0004\u0018\u00010?H\u0086\u0002J\u001f\u0010L\u001a\u00060\u0000R\u00020B*\u00060\u0000R\u00020B2\b\u0010N\u001a\u0004\u0018\u00010$H\u0086\u0002J%\u0010O\u001a\u00060\u0000R\u00020B*\u00060\u0000R\u00020B2\u000e\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\u0002J\u001f\u0010O\u001a\u00060\u0000R\u00020B*\u00060\u0000R\u00020B2\b\u0010J\u001a\u0004\u0018\u00010?H\u0086\u0002J\u001f\u0010O\u001a\u00060\u0000R\u00020B*\u00060\u0000R\u00020B2\b\u0010N\u001a\u0004\u0018\u00010$H\u0086\u0002J\u0019\u0010P\u001a\u00060\u0000R\u00020B*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\nJ\u0013\u0010P\u001a\u00060\u0000R\u00020B*\u0004\u0018\u00010?H\u0086\u0002J\u0013\u0010P\u001a\u00060\u0000R\u00020B*\u0004\u0018\u00010$H\u0086\u0002J\u0019\u0010Q\u001a\u00060\u0000R\u00020B*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u0086\nJ\u0013\u0010Q\u001a\u00060\u0000R\u00020B*\u0004\u0018\u00010?H\u0086\u0002J\u0013\u0010Q\u001a\u00060\u0000R\u00020B*\u0004\u0018\u00010$H\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\rR\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\r\u00a8\u0006R"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "EOLN", "Lkotlin/Function0;", "", "getEOLN", "()Lkotlin/jvm/functions/Function0;", "blockStart", "", "getBlockStart", "()Z", "setBlockStart", "(Z)V", "builder", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/script/generator/CodeTextBuilder;", "noSpace", "getNoSpace", "setNoSpace", "onNewLine", "getOnNewLine", "setOnNewLine", "separator", "", "getSeparator", "()Ljava/lang/Character;", "setSeparator", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "startWithNewLine", "getStartWithNewLine", "setStartWithNewLine", "appendSimple", "text", "", "kind", "Lcom/intellij/database/script/CompositeText$Kind;", "error", "", "blankLine", "comment", "msg", "indent", "indenting", "block", "name", "quotedName", "newLine", "noNewLine", "onStart", "orError", "err", "quote", "e", "Lcom/intellij/database/model/basic/BasicElement;", "plain", "scr", "element", "separated", "source", "src", "Lcom/intellij/database/script/CompositeText$Fragment;", "space", "startBlock", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "unindent", "withNewLines", "nl", "joined", "T", "", "sep", "t", "Lkotlin/Function1;", "minus", "op", "s", "plus", "unaryMinus", "unaryPlus", "intellij.database.dialects"})
    public final class NewCodingAdapter {
        @NotNull
        private final CodeTextBuilder builder;
        @NotNull
        private final Function0<Unit> EOLN;
        private boolean noSpace;
        private boolean blockStart;
        private boolean startWithNewLine;
        private boolean onNewLine;
        @Nullable
        private Character separator;

        @NotNull
        public final CodeTextBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        public final Function0<Unit> getEOLN() {
            return this.EOLN;
        }

        public final boolean getNoSpace() {
            return this.noSpace;
        }

        public final void setNoSpace(boolean bl) {
            this.noSpace = bl;
        }

        public final boolean getBlockStart() {
            return this.blockStart;
        }

        public final void setBlockStart(boolean bl) {
            this.blockStart = bl;
        }

        public final boolean getStartWithNewLine() {
            return this.startWithNewLine;
        }

        public final void setStartWithNewLine(boolean bl) {
            this.startWithNewLine = bl;
        }

        public final boolean getOnNewLine() {
            return this.onNewLine;
        }

        public final void setOnNewLine(boolean bl) {
            this.onNewLine = bl;
        }

        @Nullable
        public final Character getSeparator() {
            return this.separator;
        }

        public final void setSeparator(@Nullable Character c2) {
            this.separator = c2;
        }

        public final void withNewLines(boolean nl, @NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            boolean prev = this.getStartWithNewLine();
            this.setStartWithNewLine(nl);
            block.invoke();
            this.setStartWithNewLine(prev);
        }

        public static /* synthetic */ void withNewLines$default(NewCodingAdapter this_, boolean nl, Function0 block, int n, Object object) {
            if ((n & 1) != 0) {
                nl = true;
            }
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            boolean prev = this_.getStartWithNewLine();
            this_.setStartWithNewLine(nl);
            block.invoke();
            this_.setStartWithNewLine(prev);
        }

        public final void separated(char separator, @NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            Character prev = this.getSeparator();
            this.setSeparator(Character.valueOf(separator));
            block.invoke();
            this.setSeparator(prev);
        }

        public static /* synthetic */ void separated$default(NewCodingAdapter this_, char separator, Function0 block, int n, Object object) {
            if ((n & 1) != 0) {
                separator = (char)44;
            }
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            Character prev = this_.getSeparator();
            this_.setSeparator(Character.valueOf(separator));
            block.invoke();
            this_.setSeparator(prev);
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $receiver, @Nullable CompositeText.Fragment t) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            return $receiver.plus($receiver, (Function0<? extends Object>)((Function0)new Function0<CompositeText.Fragment>($receiver, t){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ CompositeText.Fragment $t;

                @Nullable
                public final CompositeText.Fragment invoke() {
                    CompositeText.Fragment fragment;
                    CompositeText.Fragment fragment2 = this.$t;
                    if (fragment2 != null) {
                        CompositeText.Fragment fragment3;
                        CompositeText.Fragment $receiver = fragment3 = fragment2;
                        this.receiver$0.appendSimple($receiver.getText(), $receiver.getKind(), $receiver.getError());
                        fragment = fragment3;
                    } else {
                        fragment = null;
                    }
                    return fragment;
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$t = fragment;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $receiver, @Nullable CompositeText.Fragment t) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            return $receiver.minus($receiver, (Function0<? extends Object>)((Function0)new Function0<CompositeText.Fragment>($receiver, t){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ CompositeText.Fragment $t;

                @Nullable
                public final CompositeText.Fragment invoke() {
                    CompositeText.Fragment fragment;
                    CompositeText.Fragment fragment2 = this.$t;
                    if (fragment2 != null) {
                        CompositeText.Fragment fragment3;
                        CompositeText.Fragment $receiver = fragment3 = fragment2;
                        this.receiver$0.appendSimple($receiver.getText(), $receiver.getKind(), $receiver.getError());
                        fragment = fragment3;
                    } else {
                        fragment = null;
                    }
                    return fragment;
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$t = fragment;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $receiver, @Nullable CharSequence s) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            return $receiver.plus($receiver, (Function0<? extends Object>)((Function0)new Function0<Unit>($receiver, s){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ CharSequence $s;

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    CharSequence charSequence = this.$s;
                    if (charSequence != null) {
                        CharSequence charSequence2;
                        CharSequence it = charSequence2 = charSequence;
                        NewCodingAdapter.appendSimple$default(this.receiver$0, it, null, null, 6, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$s = charSequence;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $receiver, @Nullable CharSequence s) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            return $receiver.minus($receiver, (Function0<? extends Object>)((Function0)new Function0<Unit>($receiver, s){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ CharSequence $s;

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    CharSequence charSequence = this.$s;
                    if (charSequence != null) {
                        CharSequence charSequence2;
                        CharSequence it = charSequence2 = charSequence;
                        NewCodingAdapter.appendSimple$default(this.receiver$0, it, null, null, 6, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$s = charSequence;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $receiver, @NotNull Function0<? extends Object> op) {
            NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull(op, (String)"op");
            NewCodingAdapter $receiver2 = newCodingAdapter = $receiver;
            op.invoke();
            return newCodingAdapter;
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $receiver, @NotNull Function0<? extends Object> op) {
            NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull(op, (String)"op");
            NewCodingAdapter $receiver2 = newCodingAdapter = $receiver;
            $receiver2.noSpace = true;
            op.invoke();
            return newCodingAdapter;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryPlus(@Nullable CharSequence $receiver) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            this.plus(this, $receiver);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryMinus(@Nullable CharSequence $receiver) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            this.minus(this, $receiver);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryPlus(@Nullable CompositeText.Fragment $receiver) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            this.plus(this, $receiver);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryMinus(@Nullable CompositeText.Fragment $receiver) {
            void var2_2;
            NewCodingAdapter this_$iv = this;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            this.minus(this, $receiver);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryPlus(@NotNull Function0<? extends Object> $receiver) {
            void var3_2;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
            NewCodingAdapter this_$iv = this;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            this.plus(this, $receiver);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var3_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NewCodingAdapter unaryMinus(@NotNull Function0<? extends Object> $receiver) {
            void var3_2;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
            NewCodingAdapter this_$iv = this;
            boolean prev$iv = this_$iv.getBlockStart();
            this_$iv.setBlockStart(true);
            this.minus(this, $receiver);
            if (this_$iv.getBlockStart()) {
                this_$iv.setBlockStart(prev$iv);
            }
            return var3_2;
        }

        @NotNull
        public final NewCodingAdapter startBlock(@NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            boolean prev = this.getBlockStart();
            this.setBlockStart(true);
            block.invoke();
            if (this.getBlockStart()) {
                this.setBlockStart(prev);
            }
            return this;
        }

        @NotNull
        public final <T> Function0<Unit> joined(@NotNull Iterable<? extends T> $receiver, @NotNull String sep, @NotNull Function1<? super T, Unit> t) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)sep, (String)"sep");
            Intrinsics.checkParameterIsNotNull(t, (String)"t");
            return (Function0)new Function0<Unit>(this, $receiver, t, sep){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ Iterable receiver$0;
                final /* synthetic */ Function1 $t;
                final /* synthetic */ String $sep;

                public final void invoke() {
                    Iterator<T> it = this.receiver$0.iterator();
                    if (it.hasNext()) {
                        this.$t.invoke(it.next());
                        while (it.hasNext()) {
                            this.this$0.noSpace();
                            NewCodingAdapter.appendSimple$default(this.this$0, this.$sep, null, null, 6, null);
                            this.$t.invoke(it.next());
                        }
                    }
                }
                {
                    this.this$0 = newCodingAdapter;
                    this.receiver$0 = iterable;
                    this.$t = function1;
                    this.$sep = string;
                    super(0);
                }
            };
        }

        @NotNull
        public static /* synthetic */ Function0 joined$default(NewCodingAdapter this_, Iterable $receiver, String sep, Function1 t, int n, Object object) {
            if ((n & 1) != 0) {
                sep = ", ";
            }
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)sep, (String)"sep");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            return (Function0)new /* invalid duplicate definition of identical inner class */;
        }

        public final void noSpace() {
            this.noSpace = true;
        }

        public final void comment(@NotNull CharSequence text2, @Nullable String error2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            this.appendSimple("-- " + text2 + '\n', CompositeText.Kind.COMMENT, error2);
        }

        public static /* synthetic */ void comment$default(NewCodingAdapter newCodingAdapter, CharSequence charSequence, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            newCodingAdapter.comment(charSequence, string);
        }

        public final void appendSimple(@NotNull CharSequence text2, @NotNull CompositeText.Kind kind, @Nullable String error2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            CharSequence charSequence = text2;
            if (!(charSequence.length() == 0)) {
                if (this.blockStart) {
                    this.onStart();
                }
                if (this.onNewLine) {
                    CodeTextBuilder.ensureEoln$default(this.builder, null, 1, null);
                    this.onNewLine = false;
                }
                if (!this.noSpace) {
                    this.space();
                } else {
                    this.noSpace = false;
                }
            }
            this.builder.appendSimple(text2, kind, error2);
        }

        public static /* synthetic */ void appendSimple$default(NewCodingAdapter newCodingAdapter, CharSequence charSequence, CompositeText.Kind kind, String string, int n, Object object) {
            if ((n & 2) != 0) {
                kind = CompositeText.Kind.PLAIN_TEXT;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            newCodingAdapter.appendSimple(charSequence, kind, string);
        }

        public final void space() {
            char last;
            CharSequence text2 = this.builder.getText();
            Character c2 = StringsKt.lastOrNull((CharSequence)text2);
            char c3 = last = c2 != null ? c2.charValue() : (char)'\n';
            if (last == '\n') {
                this.builder.appendIndent();
            }
            if (CharsKt.isWhitespace((char)last)) {
                return;
            }
            CodeTextBuilder.appendSimple$default(this.builder, " ", null, null, 6, null);
        }

        private final void onStart() {
            this.blockStart = false;
            if (this.separator != null) {
                Character c2 = this.separator;
                if (c2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!this.builder.endsWithIgnoreSpace(String.valueOf(c2.charValue()))) {
                    Character c3 = this.separator;
                    if (c3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.builder.addSuffixToTheLastLine(c3.charValue());
                }
            }
            if (this.startWithNewLine) {
                CodeTextBuilder.ensureEoln$default(this.builder, null, 1, null);
            }
        }

        public final void newLine() {
            this.onNewLine = true;
        }

        public final void noNewLine() {
            this.onNewLine = false;
        }

        public final void blankLine() {
            CodeTextBuilder.ensureBlankLine$default(this.builder, null, 1, null);
        }

        public final void error(@NotNull String msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            this.comment(msg, msg);
        }

        public final void indenting(@NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            boolean prev = this.getOnNewLine();
            int length = this.getBuilder().getLength();
            this.newLine();
            this.indent();
            block.invoke();
            this.unindent();
            if (length == this.getBuilder().getLength()) {
                this.setOnNewLine(prev);
            }
        }

        public final void indent() {
            CodeTextBuilder.indent$default(this.builder, null, 1, null);
        }

        public final void unindent() {
            this.builder.unindent();
        }

        @NotNull
        public final Function0<Unit> orError(@Nullable String text2, @NotNull Function0<String> err) {
            Intrinsics.checkParameterIsNotNull(err, (String)"err");
            return (Function0)new Function0<Unit>(this, text2, err){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                final /* synthetic */ Function0 $err;

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        NewCodingAdapter.appendSimple$default(this.this$0, "???", null, (String)this.$err.invoke(), 2, null);
                    }
                }
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    this.$err = function0;
                    super(0);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function0<Unit> scr(@Nullable BasicElement element2) {
            void quotedName$iv;
            void this_$iv;
            String string;
            BasicElement basicElement;
            NewCodingAdapter newCodingAdapter = this;
            BasicElement basicElement2 = element2;
            if (basicElement2 != null) {
                BasicElement it = basicElement = basicElement2;
                string = NewCodingAdapter.quote$default(this, it, null, 2, null);
            } else {
                string = null;
            }
            basicElement = string;
            void this_$iv$iv = this_$iv;
            return (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, (String)quotedName$iv){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function0<Unit> scr(@Nullable String text2, boolean plain) {
            void this_$iv;
            NewCodingAdapter newCodingAdapter = this;
            String quotedName$iv = this.quote(text2, plain);
            void this_$iv$iv = this_$iv;
            return (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, quotedName$iv){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        @NotNull
        public final Function0<Unit> name(@Nullable String quotedName) {
            NewCodingAdapter this_$iv = this;
            return (Function0)new Function0<Unit>(this_$iv, quotedName){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        public final void source(@Nullable CompositeText.Fragment src) {
            if (src != null) {
                this.appendSimple(src.getText(), src.getKind(), src.getError());
            } else {
                this.error("missing source code");
            }
        }

        @Nullable
        public final String quote(@NotNull BasicElement e, @Nullable String name) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            String string2 = name;
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                string = ScriptingContext.this.getNaming().nameToScript(it, e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted());
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public static /* synthetic */ String quote$default(NewCodingAdapter newCodingAdapter, BasicElement basicElement, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = basicElement.getRealName();
            }
            return newCodingAdapter.quote(basicElement, string);
        }

        @Nullable
        public final String quote(@Nullable String text2, boolean plain) {
            String string;
            String string2 = text2;
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                string = ScriptingContext.this.getNaming().nameToScript(it, plain);
            } else {
                string = null;
            }
            return string;
        }

        public NewCodingAdapter() {
            this.builder = ScriptingContext.this.getBuilder();
            this.EOLN = (Function0)new Function0<Unit>(this){
                final /* synthetic */ NewCodingAdapter this$0;

                public final void invoke() {
                    this.this$0.newLine();
                }
                {
                    this.this$0 = newCodingAdapter;
                    super(0);
                }
            };
        }
    }
}

