/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.slim.SlimFileType;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;
import org.jetbrains.plugins.slim.psi.impl.SlimFilterImpl;
import org.jetbrains.plugins.slim.psi.impl.SlimTagImpl;

public class SlimCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    private static boolean isWhiteSpace(char c) {
        return c == '\t' || c == ' ';
    }

    private static int getMinIndent(String text, int tabSize) {
        String[] lines = text.split("\n");
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            int indent = 0;
            for (int i = 0; i < line.length() && SlimCopyPasteProcessor.isWhiteSpace(line.charAt(i)); ++i) {
                if (line.charAt(i) == ' ') {
                    ++indent;
                    continue;
                }
                indent += tabSize;
            }
            minIndent = Math.min(minIndent, indent);
        }
        return minIndent;
    }

    private static boolean startsTheLine(Document document, int caretOffset) {
        int i;
        for (i = caretOffset - 1; i >= 0 && SlimCopyPasteProcessor.isWhiteSpace(document.getText().charAt(i)); --i) {
        }
        return i < 0 || document.getText().charAt(i) == '\n';
    }

    private static String trimLeadingSpaces(String text, int tabSize) {
        String[] lines = text.split("\n");
        int minIndent = SlimCopyPasteProcessor.getMinIndent(text, tabSize);
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append(line.substring(minIndent)).append("\n");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private static int getIndentSize(String indent, int tabSize) {
        int result = 0;
        for (int i = 0; i < indent.length(); ++i) {
            if (indent.charAt(i) == ' ') {
                ++result;
                continue;
            }
            result += tabSize;
        }
        return result;
    }

    private static int getFilterIndent(PsiElement element, int tabSize) {
        PsiElement indent;
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{SlimTagImpl.class, SlimFilterImpl.class});
        if (container != null && (indent = container.getPrevSibling()) != null && indent.getNode().getElementType() == SlimTokenTypes.INDENT) {
            return SlimCopyPasteProcessor.getIndentSize(indent.getText(), tabSize);
        }
        return 0;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int indent;
        int caretIndent;
        if (file.getLanguage() != SlimLanguage.INSTANCE) {
            String string = text;
            if (string == null) {
                SlimCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (!text.contains("\n")) {
            String string = text;
            if (string == null) {
                SlimCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file);
        boolean useTabs = codeStyleSettings.useTabCharacter((FileType)SlimFileType.SLIM);
        char indentChar = useTabs ? (char)'\t' : ' ';
        int indentSize = codeStyleSettings.getIndentSize((FileType)SlimFileType.SLIM);
        String oneIndentString = StringUtil.repeatSymbol((char)indentChar, (int)indentSize);
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        PsiElement element = file.findElementAt(Math.max(caretOffset - 1, 0));
        if (element == null) {
            String string = text;
            if (string == null) {
                SlimCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        text = useTabs ? SlimCopyPasteProcessor.convertIndentToTabs(text, indentSize) : SlimCopyPasteProcessor.convertTabsToIndents(text, oneIndentString);
        int lineNumber = editor.getDocument().getLineNumber(caretOffset);
        int lineStart = editor.getDocument().getLineStartOffset(lineNumber);
        boolean startsTheLine = SlimCopyPasteProcessor.startsTheLine(document, caretOffset);
        int minIndent = SlimCopyPasteProcessor.getMinIndent(text, indentSize);
        String newText = "";
        text = SlimCopyPasteProcessor.trimLeadingSpaces(text, indentSize);
        boolean isAfterFilterName = SlimCopyPasteProcessor.isAfterFilterName(file, caretOffset);
        if (isAfterFilterName) {
            newText = newText + "\n";
            lineStart = caretOffset;
            startsTheLine = true;
        }
        String lineIndent = document.getText().substring(lineStart, caretOffset);
        int n = caretIndent = startsTheLine ? SlimCopyPasteProcessor.getIndentSize(lineIndent, indentSize) : 0;
        if (SlimCopyPasteProcessor.isInsideFilterOrStaticContent(file, caretOffset)) {
            int filterIndent = SlimCopyPasteProcessor.getFilterIndent(element, indentSize);
            indent = Math.max(filterIndent + indentSize, caretIndent);
        } else {
            indent = minIndent + caretIndent;
        }
        List strings = StringUtil.split((String)text, (String)"\n", (boolean)false);
        boolean firstLine = true;
        for (String s : strings) {
            String indentString = firstLine ? (startsTheLine ? StringUtil.repeatSymbol((char)indentChar, (int)(indent - caretIndent)) : "") : StringUtil.repeatSymbol((char)indentChar, (int)indent);
            newText = newText + indentString + s;
            firstLine = false;
        }
        String string = newText;
        if (string == null) {
            SlimCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isAfterFilterName(PsiFile file, int caretOffset) {
        PsiElement element;
        PsiElement psiElement = element = caretOffset > 0 ? file.findElementAt(caretOffset - 1) : null;
        while (element != null && element.getNode().getElementType() == SlimTokenTypes.WHITESPACE) {
            element = element.getPrevSibling();
        }
        return element != null && element.getNode().getElementType() == SlimTokenTypes.FILTER;
    }

    private static boolean isInsideFilterOrStaticContent(PsiFile file, int caretOffset) {
        PsiElement element;
        PsiElement psiElement = element = caretOffset > 0 ? file.findElementAt(caretOffset - 1) : null;
        if (element == null) {
            return false;
        }
        PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{SlimTagImpl.class, SlimFilterImpl.class});
        PsiElement child = tag != null ? tag.getFirstChild() : null;
        return child != null && (child.getNode().getElementType() == SlimTokenTypes.FILTER || child.getNode().getElementType() == SlimTokenTypes.STATIC_CONTENT_START);
    }

    private static int getIndentSize(String line) {
        int i;
        for (i = 0; i < line.length() && SlimCopyPasteProcessor.isWhiteSpace(line.charAt(i)); ++i) {
        }
        return i;
    }

    private static String convertIndentToTabs(String text, int indentSize) {
        int i;
        String[] lines = text.split("\n");
        int[] indents = new int[lines.length];
        for (i = 0; i < lines.length; ++i) {
            indents[i] = SlimCopyPasteProcessor.getIndentSize(lines[i]);
        }
        for (i = indentSize; i > 0; --i) {
            for (int j = 0; j < lines.length; ++j) {
                String newLine;
                String line = lines[j];
                String tabIndent = StringUtil.repeatSymbol((char)'\t', (int)indents[j]);
                lines[j] = newLine = tabIndent + line.trim();
            }
        }
        return StringUtil.join((String[])lines, (String)"\n");
    }

    private static String convertTabsToIndents(String text, String oneIndentString) {
        return text.replaceAll("\t", oneIndentString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/slim/SlimCopyPasteProcessor", "preprocessOnPaste"));
    }
}

