/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Weighted;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.xml.breadcrumbs.BreadcrumbsItem;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsComponent<T extends BreadcrumbsItem>
extends JComponent
implements Disposable,
Weighted {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.breadcrumbs.BreadcrumbsComponent");
    private static final Painter DEFAULT_PAINTER = new DefaultPainter(new ButtonSettings());
    private static final int EXTRA_WIDTH = 10;
    private List<BreadcrumbsItemListener<T>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Crumb myHovered;
    private PagedImage myBuffer;
    private List<Crumb> myCrumbs = new ArrayList<Crumb>();
    private final CrumbLineMouseListener myMouseListener = new CrumbLineMouseListener(this);
    private List<T> myItems;
    private int myOffset;

    public BreadcrumbsComponent() {
        this.addMouseListener(this.myMouseListener);
        this.addMouseMotionListener(this.myMouseListener);
        this.setToolTipText("");
    }

    public void setItems(@Nullable List<T> itemsList) {
        if (this.myItems != itemsList) {
            this.myItems = itemsList;
            this.myCrumbs = null;
        }
        this.repaint();
    }

    public void setOffset(int offset) {
        if (this.myOffset != offset) {
            this.myOffset = offset;
            this.repaint();
        }
    }

    public void addBreadcrumbsItemListener(@NotNull BreadcrumbsItemListener<T> listener) {
        if (listener == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener);
    }

    public void removeBreadcrumbsItemListener(@NotNull BreadcrumbsItemListener<T> listener) {
        if (listener == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(1);
        }
        this.myListeners.remove(listener);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Crumb c = this.getCrumb(event.getPoint());
        if (c != null) {
            String text = c.getTooltipText();
            return text == null ? super.getToolTipText(event) : text;
        }
        return super.getToolTipText(event);
    }

    @Nullable
    public Crumb getCrumb(@NotNull Point p) {
        if (p == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(2);
        }
        if (this.myCrumbs != null) {
            Rectangle r = this.getBounds();
            p.translate(r.x, r.y);
            if (!r.contains(p)) {
                return null;
            }
            if (this.myBuffer == null) {
                return null;
            }
            int offset = this.myBuffer.getPageOffset();
            for (Crumb each : this.myCrumbs) {
                if (p.x + offset < each.getOffset() || p.x + offset >= each.getOffset() + each.getWidth()) continue;
                return each;
            }
        }
        return null;
    }

    public void setHoveredCrumb(@Nullable Crumb crumb) {
        if (crumb != null) {
            crumb.setHovered(true);
        }
        if (this.myHovered != null) {
            this.myHovered.setHovered(false);
        }
        this.myHovered = crumb;
        for (BreadcrumbsItemListener<BreadcrumbsItem> breadcrumbsItemListener : this.myListeners) {
            breadcrumbsItemListener.itemHovered(this.myHovered != null ? this.myHovered.myItem : null);
        }
        this.repaint();
    }

    public void nextPage() {
        int page;
        if (this.myBuffer != null && (page = this.myBuffer.getPage()) + 1 < this.myBuffer.getPageCount()) {
            this.myBuffer.setPage(page + 1);
        }
        this.repaint();
    }

    public void previousPage() {
        int page;
        if (this.myBuffer != null && (page = this.myBuffer.getPage()) - 1 >= 0) {
            this.myBuffer.setPage(page - 1);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        FontMetrics fm = g2.getFontMetrics();
        if (this.myItems != null) {
            List<Crumb> crumbList;
            boolean veryDirty = this.myCrumbs == null || this.myBuffer != null && !this.myBuffer.isValid(d.width);
            List<Crumb> list = crumbList = veryDirty ? this.createCrumbList(fm, this.myItems, d.width) : this.myCrumbs;
            if (crumbList != null) {
                if (veryDirty) {
                    this.myBuffer = new PagedImage(BreadcrumbsComponent.getTotalWidth(crumbList), d.width);
                    this.myBuffer.setPage(this.myBuffer.getPageCount() - 1);
                }
                assert (this.myBuffer != null);
                super.paint(g2);
                this.myBuffer.paintPage(g2, crumbList, DEFAULT_PAINTER, d.height);
                this.myCrumbs = crumbList;
            }
        } else {
            super.paint(g2);
        }
    }

    private void setSelectedCrumb(@NotNull Crumb<T> c, int modifiers) {
        if (c == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(3);
        }
        T selectedElement = c.getItem();
        HashSet items = new HashSet();
        boolean light = false;
        for (Crumb each : this.myCrumbs) {
            Object item = each.getItem();
            if (item != null && items.contains(item)) {
                light = false;
            }
            each.setLight(light);
            if (item != null && !light) {
                items.add(item);
            }
            if (selectedElement == item) {
                each.setSelected(true);
                light = true;
                continue;
            }
            each.setSelected(false);
        }
        this.fireItemSelected(selectedElement, modifiers);
        this.repaint();
    }

    private void fireItemSelected(@Nullable T item, int modifiers) {
        if (item != null) {
            for (BreadcrumbsItemListener<T> listener : this.myListeners) {
                listener.itemSelected(item, modifiers);
            }
        }
    }

    @Nullable
    private List<Crumb> createCrumbList(@NotNull FontMetrics fm, @NotNull List<T> elements, int width) {
        if (fm == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(5);
        }
        if (elements.size() == 0) {
            return null;
        }
        LinkedList<Crumb> result2 = new LinkedList<Crumb>();
        int screenWidth = 0;
        Crumb<BreadcrumbsItem> rightmostCrumb = null;
        NavigationCrumb fwd = new NavigationCrumb(this, fm, true, DEFAULT_PAINTER);
        for (int i = elements.size() - 1; i >= 0; --i) {
            NavigationCrumb forward = new NavigationCrumb(this, fm, true, DEFAULT_PAINTER);
            NavigationCrumb backward = new NavigationCrumb(this, fm, false, DEFAULT_PAINTER);
            BreadcrumbsItem element = (BreadcrumbsItem)elements.get(i);
            String s = element.getDisplayText();
            Dimension d = DEFAULT_PAINTER.getSize(s, fm, width - forward.getWidth() - backward.getWidth());
            Crumb<BreadcrumbsItem> crumb = new Crumb<BreadcrumbsItem>(this, s, d.width + 10, element);
            if (screenWidth + d.width > width) {
                Crumb<BreadcrumbsItem> first = null;
                if (screenWidth + backward.getWidth() > width && !result2.isEmpty()) {
                    first = result2.removeFirst();
                    screenWidth -= first.getWidth();
                }
                result2.addFirst(backward);
                int dummyWidth = width - (screenWidth += backward.getWidth() - this.myOffset);
                if (dummyWidth > 0) {
                    DummyCrumb dummy = new DummyCrumb(dummyWidth);
                    if (rightmostCrumb != null) {
                        result2.add(result2.indexOf(rightmostCrumb) + 1, dummy);
                    } else {
                        result2.addLast(dummy);
                    }
                }
                screenWidth = forward.getWidth();
                result2.addFirst(forward);
                if (first != null) {
                    result2.addFirst(first);
                    screenWidth += first.getWidth();
                }
                rightmostCrumb = first != null ? first : crumb;
            }
            result2.addFirst(crumb);
            screenWidth += d.width;
        }
        if (rightmostCrumb != null && screenWidth < width) {
            result2.add(result2.indexOf(rightmostCrumb) + 2, new DummyCrumb(width - screenWidth - fwd.getWidth() - 8));
        }
        int offset = this.myOffset;
        for (Crumb each : result2) {
            each.setOffset(offset);
            offset += each.getWidth();
        }
        if (result2.size() > 0) {
            for (int i = result2.size() - 1; i >= 0; --i) {
                Crumb c = result2.get(i);
                if (c instanceof DummyCrumb) continue;
                c.setSelected(true);
                break;
            }
        }
        return result2;
    }

    private static int getTotalWidth(@NotNull List<Crumb> crumbList) {
        if (crumbList == null) {
            BreadcrumbsComponent.$$$reportNull$$$0(6);
        }
        int totalWidth = 0;
        for (Crumb each : crumbList) {
            totalWidth += each.getWidth();
        }
        return totalWidth;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics2D g2 = (Graphics2D)GraphicsUtil.safelyGetGraphics((Component)this);
        Dimension dim = new Dimension(Integer.MAX_VALUE, g2 != null ? BreadcrumbsComponent.DEFAULT_PAINTER.getSize((String)"DUMMY", (FontMetrics)g2.getFontMetrics(), (int)Integer.MAX_VALUE).height + 1 : 1);
        JBInsets.addTo((Dimension)dim, (Insets)this.getInsets());
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void dispose() {
        this.removeMouseListener(this.myMouseListener);
        this.removeMouseMotionListener(this.myMouseListener);
        this.myListeners = null;
    }

    @Override
    public double getWeight() {
        return Double.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fm";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crumbList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addBreadcrumbsItemListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeBreadcrumbsItemListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCrumb";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedCrumb";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createCrumbList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalWidth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DefaultPainter
    extends Painter {
        DefaultPainter(@NotNull PainterSettings s) {
            if (s == null) {
                DefaultPainter.$$$reportNull$$$0(0);
            }
            super(s);
        }

        @Override
        public void paint(@NotNull Crumb c, @NotNull Graphics2D g2, int height, int pageOffset) {
            String string;
            FontMetrics fm;
            Font font;
            if (c == null) {
                DefaultPainter.$$$reportNull$$$0(1);
            }
            if (g2 == null) {
                DefaultPainter.$$$reportNull$$$0(2);
            }
            PainterSettings s = this.getSettings();
            Font oldFont = g2.getFont();
            int offset = c.getOffset() - pageOffset;
            int width = c.getWidth();
            RectanglePainter.paint((Graphics2D)g2, (int)(offset + 2), (int)2, (int)(width - 4), (int)(height - 4), (int)4, (Paint)s.getBackgroundColor(c), (Paint)s.getBorderColor(c));
            Color textColor = s.getForegroundColor(c);
            if (textColor != null) {
                g2.setColor(textColor);
            }
            if ((font = s.getFont(g2, c)) != null) {
                g2.setFont(font);
            }
            if ((fm = g2.getFontMetrics()).stringWidth(string = c.getString()) > width) {
                int charWidth;
                int dotsWidth = fm.stringWidth("...");
                StringBuilder sb = new StringBuilder();
                int length = 0;
                for (int i = 0; i < string.length() && length + (charWidth = fm.charWidth(string.charAt(i))) + dotsWidth <= width; ++i) {
                    length += charWidth;
                    sb.append(string.charAt(i));
                }
                string = sb.append("...").toString();
            }
            g2.drawString(string, offset + 2 + 5, height - fm.getDescent() - 5);
            g2.setFont(oldFont);
        }

        @Override
        @NotNull
        Dimension getSize(@NotNull @NonNls String s, @NotNull FontMetrics fm, int maxWidth) {
            int width;
            if (s == null) {
                DefaultPainter.$$$reportNull$$$0(3);
            }
            if (fm == null) {
                DefaultPainter.$$$reportNull$$$0(4);
            }
            Dimension dimension = new Dimension((width = fm.stringWidth(s) + 4) > maxWidth ? maxWidth : width, fm.getHeight() + 4);
            if (dimension == null) {
                DefaultPainter.$$$reportNull$$$0(5);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fm";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSize";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class Painter {
        public static final int ROUND_VALUE = 2;
        private final PainterSettings mySettings;

        Painter(@NotNull PainterSettings s) {
            if (s == null) {
                Painter.$$$reportNull$$$0(0);
            }
            this.mySettings = s;
        }

        protected PainterSettings getSettings() {
            return this.mySettings;
        }

        abstract void paint(@NotNull Crumb var1, @NotNull Graphics2D var2, int var3, int var4);

        @NotNull
        Dimension getSize(@NotNull @NonNls String s, @NotNull FontMetrics fm, int maxWidth) {
            int w;
            if (s == null) {
                Painter.$$$reportNull$$$0(1);
            }
            if (fm == null) {
                Painter.$$$reportNull$$$0(2);
            }
            Dimension dimension = new Dimension((w = fm.stringWidth(s)) > maxWidth ? maxWidth : w, fm.getHeight());
            if (dimension == null) {
                Painter.$$$reportNull$$$0(3);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fm";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Painter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Painter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSize";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ButtonSettings
    extends PainterSettings {
        ButtonSettings() {
        }

        static Color getBackgroundColor(boolean selected, boolean hovered, boolean light, boolean navigationCrumb) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(hovered ? EditorColors.BREADCRUMBS_HOVERED : (selected ? EditorColors.BREADCRUMBS_CURRENT : (light && !navigationCrumb ? EditorColors.BREADCRUMBS_INACTIVE : EditorColors.BREADCRUMBS_DEFAULT))).getBackgroundColor();
        }

        @Override
        @Nullable
        Color getBackgroundColor(@NotNull Crumb c) {
            CrumbPresentation presentation;
            Object item;
            if (c == null) {
                ButtonSettings.$$$reportNull$$$0(0);
            }
            if ((item = c.getItem()) != null && (presentation = ((BreadcrumbsItem)item).getPresentation()) != null) {
                return presentation.getBackgroundColor(c.isSelected(), c.isHovered(), c.isLight());
            }
            return super.getBackgroundColor(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$ButtonSettings", "getBackgroundColor"));
        }
    }

    static abstract class PainterSettings {
        PainterSettings() {
        }

        @Nullable
        Color getBackgroundColor(@NotNull Crumb c) {
            if (c == null) {
                PainterSettings.$$$reportNull$$$0(0);
            }
            return PainterSettings.getAttributes(c).getBackgroundColor();
        }

        @Nullable
        Color getForegroundColor(@NotNull Crumb c) {
            if (c == null) {
                PainterSettings.$$$reportNull$$$0(1);
            }
            return PainterSettings.getAttributes(c).getForegroundColor();
        }

        @Nullable
        Color getBorderColor(@NotNull Crumb c) {
            if (c == null) {
                PainterSettings.$$$reportNull$$$0(2);
            }
            return PainterSettings.getAttributes(c).getEffectColor();
        }

        @Nullable
        Font getFont(@NotNull Graphics g2, @NotNull Crumb c) {
            if (g2 == null) {
                PainterSettings.$$$reportNull$$$0(3);
            }
            if (c == null) {
                PainterSettings.$$$reportNull$$$0(4);
            }
            return null;
        }

        @NotNull
        static TextAttributesKey getKey(Crumb c) {
            TextAttributesKey textAttributesKey = c.isHovered() ? EditorColors.BREADCRUMBS_HOVERED : (c.isSelected() ? EditorColors.BREADCRUMBS_CURRENT : (c.isLight() && !(c instanceof NavigationCrumb) ? EditorColors.BREADCRUMBS_INACTIVE : EditorColors.BREADCRUMBS_DEFAULT));
            if (textAttributesKey == null) {
                PainterSettings.$$$reportNull$$$0(5);
            }
            return textAttributesKey;
        }

        @NotNull
        static TextAttributes getAttributes(Crumb c) {
            TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PainterSettings.getKey(c));
            if (textAttributes == null) {
                PainterSettings.$$$reportNull$$$0(6);
            }
            return textAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBackgroundColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getForegroundColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getBorderColor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFont";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DummyCrumb
    extends Crumb {
        DummyCrumb(int width) {
            super(null, width);
        }

        @Override
        public void paint(@NotNull Graphics2D g2, @NotNull Painter painter, int height, int pageOffset) {
            if (g2 == null) {
                DummyCrumb.$$$reportNull$$$0(0);
            }
            if (painter == null) {
                DummyCrumb.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void performAction(int modifiers) {
        }

        @Override
        public String toString() {
            return "DUMMY";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "painter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DummyCrumb";
            objectArray[2] = "paint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NavigationCrumb
    extends Crumb {
        @NonNls
        private static final String FORWARD = ">>";
        @NonNls
        private static final String BACKWARD = "<<";
        private final boolean myForward;
        private final BreadcrumbsComponent myLine;

        NavigationCrumb(@NotNull BreadcrumbsComponent line, @NotNull FontMetrics fm, boolean forward, @NotNull Painter p) {
            if (line == null) {
                NavigationCrumb.$$$reportNull$$$0(0);
            }
            if (fm == null) {
                NavigationCrumb.$$$reportNull$$$0(1);
            }
            if (p == null) {
                NavigationCrumb.$$$reportNull$$$0(2);
            }
            super(forward ? FORWARD : BACKWARD, p.getSize((String)(forward ? FORWARD : BACKWARD), (FontMetrics)fm, (int)Integer.MAX_VALUE).width + 10);
            this.myForward = forward;
            this.myLine = line;
        }

        @Override
        public void performAction(int modifiers) {
            if (this.myForward) {
                this.myLine.nextPage();
            } else {
                this.myLine.previousPage();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "line";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fm";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$NavigationCrumb";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Crumb<T extends BreadcrumbsItem> {
        private final String myString;
        private int myOffset = -1;
        private final int myWidth;
        private T myItem;
        private BreadcrumbsComponent myLine;
        private boolean mySelected;
        private boolean myHovered;
        private boolean myLight;

        Crumb(BreadcrumbsComponent line, String string, int width, T item) {
            this(string, width);
            this.myLine = line;
            this.myItem = item;
        }

        Crumb(String string, int width) {
            this.myString = string;
            this.myWidth = width;
        }

        public String getString() {
            return this.myString;
        }

        public int getOffset() {
            LOG.assertTrue(this.myOffset != -1, (Object)("Negative offet for crumb: " + this.myString));
            return this.myOffset;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public void setOffset(int offset) {
            this.myOffset = offset;
        }

        public String toString() {
            return this.getString();
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }

        public void setLight(boolean light) {
            this.myLight = light;
        }

        public boolean isHovered() {
            return this.myHovered;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public boolean isLight() {
            return this.myLight;
        }

        public void paint(@NotNull Graphics2D g2, @NotNull Painter painter, int height, int pageOffset) {
            if (g2 == null) {
                Crumb.$$$reportNull$$$0(0);
            }
            if (painter == null) {
                Crumb.$$$reportNull$$$0(1);
            }
            painter.paint(this, g2, height, pageOffset);
        }

        @Nullable
        public String getTooltipText() {
            T element = this.getItem();
            if (element != null) {
                return ((BreadcrumbsItem)element).getTooltip();
            }
            return null;
        }

        public T getItem() {
            return this.myItem;
        }

        public void performAction(int modifiers) {
            this.myLine.setSelectedCrumb(this, modifiers);
        }

        public void setHovered(boolean b) {
            this.myHovered = b;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "painter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Crumb";
            objectArray[2] = "paint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CrumbLineMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private final BreadcrumbsComponent myBreadcrumbs;
        private Crumb myHoveredCrumb;

        CrumbLineMouseListener(@NotNull BreadcrumbsComponent line) {
            if (line == null) {
                CrumbLineMouseListener.$$$reportNull$$$0(0);
            }
            this.myBreadcrumbs = line;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Crumb crumb = this.myBreadcrumbs.getCrumb(e.getPoint());
            if (crumb != this.myHoveredCrumb) {
                this.myBreadcrumbs.setHoveredCrumb(crumb);
                this.myHoveredCrumb = crumb;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Crumb crumb = this.myBreadcrumbs.getCrumb(e.getPoint());
            if (crumb != null) {
                crumb.performAction(e.getModifiers());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$CrumbLineMouseListener", "<init>"));
        }
    }

    private static class PagedImage {
        private final int myPageWidth;
        private int myPage;
        private final int myTotalWidth;

        PagedImage(int totalWidth, int pageWidth) {
            this.myPageWidth = pageWidth;
            this.myTotalWidth = totalWidth;
        }

        public int getPageCount() {
            if (this.myTotalWidth < this.myPageWidth) {
                return 1;
            }
            return this.myTotalWidth / this.myPageWidth;
        }

        public void setPage(int page) {
            assert (page >= 0);
            assert (page < this.getPageCount());
            this.myPage = page;
        }

        public int getPage() {
            return this.myPage;
        }

        private void repaint(@NotNull Graphics2D g2, @NotNull List<Crumb> crumbList, @NotNull Painter painter, int height) {
            if (g2 == null) {
                PagedImage.$$$reportNull$$$0(0);
            }
            if (crumbList == null) {
                PagedImage.$$$reportNull$$$0(1);
            }
            if (painter == null) {
                PagedImage.$$$reportNull$$$0(2);
            }
            UISettings.setupAntialiasing(g2);
            int pageOffset = this.getPageOffset();
            for (Crumb each : crumbList) {
                if (each.getOffset() < pageOffset || each.getOffset() >= pageOffset + this.myPageWidth) continue;
                each.paint(g2, painter, height, pageOffset);
            }
        }

        public int getPageOffset() {
            return this.myPage * this.myPageWidth;
        }

        public void paintPage(@NotNull Graphics2D g2, @NotNull List<Crumb> list, @NotNull Painter p, int height) {
            if (g2 == null) {
                PagedImage.$$$reportNull$$$0(3);
            }
            if (list == null) {
                PagedImage.$$$reportNull$$$0(4);
            }
            if (p == null) {
                PagedImage.$$$reportNull$$$0(5);
            }
            this.repaint(g2, list, p, height);
        }

        public boolean isValid(int width) {
            return width == this.myPageWidth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "crumbList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "painter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "repaint";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintPage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

