# $Id: default.tcl 954 2007-02-20 18:35:54Z sergei $

if {$tcl_platform(platform) == "windows"} {
    package require dde
}

proc postload {} {}

proc menuload {menudesc} { return $menudesc }

proc finload  {} {}

proc browser_loadopt {} {
    custom::defvar webbrowser "" \
	[::msgcat::mc "Command to be run when you click a URL\
in a message.  '%s' will be replaced with this URL (e.g. \"galeon -n %s\")."]\
	-group IFace -type string
}
hook::add postload_hook browser_loadopt


proc browseurl {url} {
    global env tcl_platform

    set_status $url
    update

    if {[info exists ::webbrowser] && \
	    $::webbrowser != ""} {
	# If user specified a browser, use it
	eval exec [format $::webbrowser [list $url]] &
	return
    }

    # Set the clipboard value to this url in-case the user needs to paste the 
    # url in (some windows systems).
    clipboard clear
    clipboard append $url

    switch -- $tcl_platform(platform) {
        windows {
            # DDE uses commas to separate command parts
            set url [string map {, %2c} $url]

            # See if we can use dde and an existing browser.
            set handled 0
            foreach app {Firefox {Mozilla Firebird} Mozilla Netscape IExplore} {
                if {[set srv [dde services $app WWW_OpenURL]] != {}} {
                    if {[catch {dde execute $app WWW_OpenURL $url} msg]} {
                        debugmsg browseurl "dde exec $app failed: \"$msg\""
                    } else {
                        set handled 1
                        break
                    }
                }
	    }

	    # The windows NT shell treats '&' as a special character. Using
	    # a '^' will escape it. See http://wiki.tcl.tk/557 for more info. 
            if {! $handled} {
                if {[string compare $tcl_platform(os) "Windows NT"] == 0} { 
                    set url [string map {& ^&} $url]
                }
                if {[catch {eval exec [auto_execok start] [list $url] &} emsg]} {
                    MessageDlg .browse_err -aspect 50000 -icon info \
			-buttons ok -default 0 -cancel 0 -type user \
                        -message \
			    [format \
				 [::msgcat::mc "Error displaying %s in browser\n\n%s"] \
				 $url $emsg]
                }
            }
        }

        macintosh {
            if {![info exists env(BROWSER)]} {
                set env(BROWSER) "Browse the Internet"
                AppleScript execute \
                "tell application \"env(BROWSER)\"\nopen url \"$url\"\nend tell\n"
            }
        }

        default {
            if {![info exists env(BROWSER)]} {
                foreach b [list firefox galeon konqueror mozilla-firefox \
                               mozilla-firebird mozilla netscape \
                               iexplorer opera] {
                    if {[llength [set e [auto_execok $b]]] > 0} {
                        set env(BROWSER) [lindex $e 0]
                        break
                    }
                }
                if {![info exists env(BROWSER)]} {
		    if {[cequal $tcl_platform(os) Darwin]} {
			exec open $url &
			set_status ""
			return
		    }
                    MessageDlg .browse_err -aspect 50000 -icon info \
                        -message [::msgcat::mc "Please define environment variable BROWSER"] \
			-type user \
			-buttons ok -default 0 -cancel 0
                    return
                }
            }

            if {[catch { eval exec $env(BROWSER) -remote \"openURL($url, new-tab)\" }]} {
		if {[catch { exec $env(BROWSER) -remote $url }]} {
		    exec $env(BROWSER) $url &
		}
	    }
	}
    }

    set_status ""
}


