/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleMap;
import writer2latex.latex.style.TableFormatter;
import writer2latex.office.TableGridModel;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class BlockConverter
extends ConverterHelper {
    public BlockConverter(Config config, ConverterPalette palette) {
        super(config, palette);
    }

    public void traverseBlockText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        StyleMap blockMap = this.config.getParBlockStyleMap();
        String sBlockName = null;
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int nLen = list.getLength();
            int i = 0;
            while (i < nLen) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() == 1) {
                    Element child = (Element)childNode;
                    String sTagName = child.getTagName();
                    this.palette.getInfo().addDebugInfo(child, ldp);
                    if (sTagName.equals("text:p")) {
                        String sBefore;
                        String sStyleName = child.getAttribute("text:style-name");
                        if (sBlockName != null && !blockMap.isNext(sBlockName, sStyleName)) {
                            String sAfter = blockMap.getAfter(sBlockName);
                            if (sAfter.length() > 0) {
                                ldp.append(sAfter).nl();
                            }
                            sBlockName = null;
                        }
                        if (sBlockName == null && blockMap.contains(sStyleName) && (sBefore = blockMap.getBefore(sBlockName = sStyleName)).length() > 0) {
                            ldp.append(sBefore).nl();
                        }
                    } else if (sBlockName != null) {
                        String sAfter = blockMap.getAfter(sBlockName);
                        if (sAfter.length() > 0) {
                            ldp.append(sAfter).nl();
                        }
                        sBlockName = null;
                    }
                    if (sTagName.equals("text:p")) {
                        this.handleParagraph(child, ldp, oc, i == nLen - 1);
                    } else if (sTagName.equals("text:h")) {
                        this.handleHeading(child, ldp, oc);
                    } else if (sTagName.equals("text:unordered-list")) {
                        this.handleList(child, ldp, oc, false);
                    } else if (sTagName.equals("text:ordered-list")) {
                        this.handleList(child, ldp, oc, true);
                    } else if (sTagName.equals("table:table")) {
                        this.handleTable(child, ldp, oc);
                    } else if (sTagName.equals("table:sub-table")) {
                        this.handleTable(child, ldp, oc);
                    } else if (sTagName.equals("text:section")) {
                        this.handleSection(child, ldp, oc);
                    } else if (sTagName.startsWith("draw:")) {
                        this.palette.getDrawCv().handleDrawElement(child, ldp, oc);
                    } else if (sTagName.equals("text:table-of-content")) {
                        this.palette.getIndexCv().handleTOC(child, ldp, oc);
                    } else if (sTagName.equals("text:illustration-index")) {
                        this.palette.getIndexCv().handleLOF(child, ldp, oc);
                    } else if (sTagName.equals("text:table-index")) {
                        this.palette.getIndexCv().handleLOT(child, ldp, oc);
                    } else if (sTagName.equals("text:object-index")) {
                        this.palette.getIndexCv().handleObjectIndex(child, ldp, oc);
                    } else if (sTagName.equals("text:user-index")) {
                        this.palette.getIndexCv().handleUserIndex(child, ldp, oc);
                    } else if (sTagName.equals("text:alphabetical-index")) {
                        this.palette.getIndexCv().handleAlphabeticalIndex(child, ldp, oc);
                    } else if (sTagName.equals("text:bibliography")) {
                        this.palette.getIndexCv().handleBibliography(child, ldp, oc);
                    } else if (sTagName.equals("text:sequence_decls")) {
                        // empty if block
                    }
                }
                ++i;
            }
        }
        if (sBlockName != null) {
            String sAfter = blockMap.getAfter(sBlockName);
            if (sAfter.length() > 0) {
                ldp.append(sAfter).nl();
            }
            sBlockName = null;
        }
    }

    public void handleSection(Element node, LaTeXDocumentPortion ldp, Context oc) {
        this.palette.getFieldCv().addTarget(node, "|region", ldp);
        String sStyleName = node.getAttribute("text:style-name");
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.palette.getSectionSc().applySectionStyle(sStyleName, ba, ic);
        if (ba.getBefore().length() > 0) {
            ldp.append(ba.getBefore()).nl();
        }
        this.traverseBlockText(node, ldp, ic);
        if (ba.getAfter().length() > 0) {
            ldp.append(ba.getAfter()).nl();
        }
    }

    public void handleTable(Element node, LaTeXDocumentPortion ldp, Context oc) {
        TableGridModel table = new TableGridModel(node);
        Context ic = (Context)oc.clone();
        ic.setInTable(true);
        boolean bApplyCellFormat = this.config.formatting() >= 3;
        TableFormatter formatter = this.palette.getTableSc().getTableFormatter(table, !ic.isInMulticols(), bApplyCellFormat);
        if (!formatter.isSubtable()) {
            this.palette.getFieldCv().addTarget(node, "|table", ldp);
        }
        BeforeAfter baTable = new BeforeAfter();
        formatter.applyTableStyle(baTable);
        ldp.append(baTable.getBefore()).nl();
        if (bApplyCellFormat || !formatter.isLongtable()) {
            ic.setNoFootnotes(true);
        }
        int nRowCount = table.getRowCount();
        int nColCount = table.getColCount();
        boolean bInHeader = false;
        ldp.append(formatter.getInterrowMaterial(0)).nl();
        int nRow = 0;
        while (nRow < nRowCount) {
            if (formatter.isLongtable()) {
                if (nRow == 0 && table.getRow(nRow).isHeader()) {
                    bInHeader = true;
                    if (!bApplyCellFormat) {
                        ic.setNoFootnotes(true);
                    }
                } else if (bInHeader && !table.getRow(nRow).isHeader()) {
                    bInHeader = false;
                    if (!bApplyCellFormat) {
                        ic.setNoFootnotes(false);
                    }
                    this.palette.getNoteCv().flushFootnotes(ldp, oc);
                    ldp.append("\\endhead").nl();
                }
            }
            int nCol = 0;
            while (nCol < nColCount) {
                int nColSpan;
                Element cell = (Element)table.getCell(nRow, nCol);
                if ("table:table-cell".equals(cell.getNodeName())) {
                    BeforeAfter baCell = new BeforeAfter();
                    formatter.applyCellStyle(nRow, nCol, baCell);
                    ldp.append(baCell.getBefore());
                    this.traverseBlockText(cell, ldp, ic);
                    ldp.append(baCell.getAfter());
                }
                if (nCol + (nColSpan = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1)) < nColCount) {
                    ldp.append("&").nl();
                }
                nCol += nColSpan;
            }
            ldp.append("\\\\").append(formatter.getInterrowMaterial(nRow + 1)).nl();
            ++nRow;
        }
        ldp.append(baTable.getAfter()).nl();
        if (bApplyCellFormat || !formatter.isLongtable()) {
            this.palette.getNoteCv().flushFootnotes(ldp, oc);
        }
    }

    public void handleList(Element node, LaTeXDocumentPortion ldp, Context oc, boolean bOrdered) {
        Context ic = (Context)oc.clone();
        ic.incListLevel();
        if (ic.isIgnoreLists() || this.listContainsHeadings(node)) {
            ic.setIgnoreLists(true);
            this.traverseList(node, ldp, ic);
            return;
        }
        if (ic.getListStyleName() == null) {
            ic.setListStyleName(node.getAttribute("text:style-name"));
        }
        BeforeAfter ba = new BeforeAfter();
        this.palette.getListSc().applyListStyle(ic.getListStyleName(), ic.getListLevel(), bOrdered, "true".equals(node.getAttribute("text:continue-numbering")), ba);
        if (ba.getBefore().length() > 0) {
            ldp.append(ba.getBefore()).nl();
        }
        this.traverseList(node, ldp, ic);
        if (ba.getAfter().length() > 0) {
            ldp.append(ba.getAfter()).nl();
        }
    }

    private void traverseList(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int nLen = list.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = list.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    this.palette.getInfo().addDebugInfo((Element)child, ldp);
                    if (nodeName.equals("text:list-item")) {
                        this.handleListItem((Element)child, ldp, oc);
                    }
                    if (nodeName.equals("text:list-header")) {
                        this.handleListItem((Element)child, ldp, oc);
                    }
                }
                ++i;
            }
        }
    }

    private void handleListItem(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (oc.isIgnoreLists()) {
            this.traverseBlockText(node, ldp, oc);
            return;
        }
        BeforeAfter ba = new BeforeAfter();
        this.palette.getListSc().applyListItemStyle(oc.getListStyleName(), oc.getListLevel(), node.getNodeName().equals("text:list-header"), "true".equals(node.getAttribute("text:restart-numbering")), Misc.getPosInteger(node.getAttribute("text:start-value"), 1) - 1, ba);
        if (ba.getBefore().length() > 0) {
            ldp.append(ba.getBefore());
            if (this.config.formatting() >= 3) {
                ldp.nl();
            }
        }
        this.traverseBlockText(node, ldp, oc);
        if (ba.getAfter().length() > 0) {
            ldp.append(ba.getAfter()).nl();
        }
    }

    private boolean listContainsHeadings(Node node) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:list-item") && this.listItemContainsHeadings(child)) {
                        return true;
                    }
                    if (nodeName.equals("text:list-header") && this.listItemContainsHeadings(child)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private boolean listItemContainsHeadings(Node node) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:h")) {
                        return true;
                    }
                    if (nodeName.equals("text:ordered-list") && this.listContainsHeadings(child)) {
                        return true;
                    }
                    if (nodeName.equals("text:unordered-list") && this.listContainsHeadings(child)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public void handleHeading(Element node, LaTeXDocumentPortion ldp, Context oc) {
        int nLevel = Misc.getPosInteger(node.getAttribute("text:level"), 1);
        HeadingMap hm = this.config.getHeadingMap();
        String sStyleName = node.getAttribute("text:style-name");
        if (nLevel <= hm.getMaxLevel()) {
            this.palette.getI18n().pushSpecialTable(this.palette.getParSc().getFontName(sStyleName));
            BeforeAfter baHardPage = new BeforeAfter();
            BeforeAfter baHardChar = new BeforeAfter();
            Context ic = (Context)oc.clone();
            this.palette.getParSc().applyHardHeadingStyle(nLevel, sStyleName, baHardPage, baHardChar, ic);
            ldp.append(baHardPage.getBefore());
            ldp.append("\\" + hm.getName(nLevel));
            if (baHardChar.getBefore().length() > 0 || this.containsElements(node)) {
                ldp.append("[");
                this.palette.getInlineCv().traversePlainInlineText(node, ldp, ic);
                ldp.append("]");
            }
            ldp.append("{").append(baHardChar.getBefore());
            this.palette.getInlineCv().traverseInlineText(node, ldp, ic, false);
            ldp.append(baHardChar.getAfter()).append("}").nl();
            ldp.append(baHardPage.getAfter());
            this.palette.getDrawCv().flushFloatingFrames(ldp, ic);
            this.palette.getI18n().popSpecialTable();
        } else {
            this.handleParagraph(node, ldp, oc, false);
        }
    }

    private boolean containsElements(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList list = node.getChildNodes();
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = list.item(i);
            if (child.getNodeType() == 1 && !child.getNodeName().startsWith("text:reference-mark")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void handleParagraph(Element node, LaTeXDocumentPortion ldp, Context oc, boolean bLastInBlock) {
        if (!node.hasChildNodes()) {
            if (!this.config.ignoreEmptyParagraphs()) {
                ldp.nl().append("\\bigskip").nl();
                if (!bLastInBlock) {
                    ldp.nl();
                }
            }
            return;
        }
        String sStyleName = node.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getParSc().getFontName(sStyleName));
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.palette.getParSc().applyParStyle(sStyleName, ba, ic);
        ldp.append(ba.getBefore());
        if (ic.isVerbatim()) {
            this.palette.getInlineCv().traverseVerbatimInlineText(node, ldp, ic, false);
        } else {
            this.palette.getInlineCv().traverseInlineText(node, ldp, ic, false);
        }
        ldp.append(ba.getAfter());
        if (!bLastInBlock && !ic.isVerbatim()) {
            ldp.nl();
        }
        this.palette.getDrawCv().flushFloatingFrames(ldp, ic);
        this.palette.getI18n().popSpecialTable();
    }
}

