# Seta/Allumer X1-010

the X1-010 is a chip used by Seta (and Allumer) in the Seta 1 and 2 arcade boards.

it has 16 channels of wavetable sound with some support for 8-bit samples up to 128KB in length.
the sample frequency resolution is pretty bad in the low end though...

even though this chip has stereo output, no board (as far as we know) uses the two outputs that it has... instead, only one output is connected, effectively being used as a mono chip.

the chip also has some (complicated) hardware volume envelope capabilities, with half of its memory being usable for that purpose. the shape of a volume envelope is defined by user-provided 128×16 waveforms.

the chip can store up to 32 sound waveforms and envelope waveforms at once.

this chip was the inspiration for Organya/PxTone (the former being used in a well-known game called Cave Story).

## effects

- `10xx`: **change wave.**
- `11xx`: **change envelope shape.** also wavetable.
- `17xx`: **toggle LEGACY sample mode.**
  - **this effect exists only for compatibility reasons! its use is NOT recommented. use Sample type instruments instead.**
- `20xx`: **set PCM frequency.** range is `1` to `FF`.
  - PCM frequency formula: `step * (clock / 8192)`.
  - range is 1.95KHz to 498KHz if the chip clock is 16MHz.
- `22xx`: **set envelope mode.**
  - bit 0 sets whether envelope will affect this channel.
  - bit 1 sets whether envelope will run once instead of looping.
  - bit 2 sets whether split mode is used. I don't know what it does.
  - bit 3/5 sets whether the right/left shape will mirror the original one.
  - bit 4/6 sets whether the right/left output will mirror the original one.
- `23xx`: **set envelope period.**
- `25xx`: **slide envelope period up.**
- `26xx`: **slide envelope period down.**
- `29xy`: **enable auto-envelope mode.**
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.

## info

this chip uses the [X1-010](../4-instrument/x1_010.md) instrument editor.

## chip config

the following options are available in the Chip Manager window:

- **Clock rate**: sets the rate at which the chip will run.
- **Stereo**: enables stereo output. the chip supports this, but none of the actual boards use it.
- **Bankswitched**: don't worry about it for now...
