/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.ColorWellButton;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SlideshowPanel
extends PreferencePanel
implements PreferenceNames {
    public static final String MODULE = "SlidePa";
    JLabel icon = new JLabel(GRI18n.getString("SlidePa", "icon"));
    JPanel progressionPanel = new JPanel();
    JPanel locationPanel = new JPanel();
    public JPanel spacerPanel = new JPanel();
    JLabel delay = new JLabel();
    JTextField jDelay = new JTextField();
    JLabel help = new JLabel();
    JLabel progress = new JLabel();
    JLabel caption = new JLabel();
    JLabel extra = new JLabel();
    JLabel url = new JLabel();
    JCheckBox jOverride = new JCheckBox();
    JPanel apperancePanel = new JPanel();
    JComboBox jProgress;
    JComboBox jCaption;
    JComboBox jExtra;
    JComboBox jUrl;
    JCheckBox jLowRez = new JCheckBox();
    JCheckBox jRandom = new JCheckBox();
    JCheckBox jNoStretch = new JCheckBox();
    JCheckBox jPreloadAll = new JCheckBox();
    JCheckBox jLoop = new JCheckBox();
    JPanel spacerPanel1 = new JPanel();
    ColorWellButton jBackgroundColor = new ColorWellButton(Color.red);

    public JLabel getIcon() {
        return this.icon;
    }

    public void readProperties(PropertiesFile props) {
        this.jProgress.setSelectedItem(new LocationItem(props.getIntProperty("slideshowProgressLocation")));
        this.jCaption.setSelectedItem(new LocationItem(props.getIntProperty("slideshowCaptionLocation")));
        this.jExtra.setSelectedItem(new LocationItem(props.getIntProperty("slideshowExtraLocation")));
        this.jUrl.setSelectedItem(new LocationItem(props.getIntProperty("slideshowUrlLocation")));
        this.jLowRez.setSelected(props.getBooleanProperty("slideshowLowRez"));
        this.jRandom.setSelected(props.getBooleanProperty("slideshowRandom"));
        this.jNoStretch.setSelected(props.getBooleanProperty("slideshowNoStretch"));
        this.jPreloadAll.setSelected(props.getBooleanProperty("slideshowPreloadAll"));
        this.jLoop.setSelected(props.getBooleanProperty("slideshowLoop"));
        this.jDelay.setText("" + props.getIntProperty("slideshowDelay"));
        Color color = props.getColorProperty("slideshowColor");
        this.jOverride.setSelected(color != null);
        this.jBackgroundColor.setSelectedColor(color);
        this.jProgress.setEnabled(!props.isOverridden("slideshowProgressLocation"));
        this.jCaption.setEnabled(!props.isOverridden("slideshowCaptionLocation"));
        this.jExtra.setEnabled(!props.isOverridden("slideshowExtraLocation"));
        this.jUrl.setEnabled(!props.isOverridden("slideshowUrlLocation"));
        this.jLowRez.setEnabled(!props.isOverridden("slideshowLowRez"));
        this.jRandom.setEnabled(!props.isOverridden("slideshowRandom"));
        this.jNoStretch.setEnabled(!props.isOverridden("slideshowNoStretch"));
        this.jPreloadAll.setEnabled(!props.isOverridden("slideshowPreloadAll"));
        this.jLoop.setEnabled(!props.isOverridden("slideshowLoop"));
        this.jDelay.setEnabled(!props.isOverridden("slideshowDelay"));
        this.jOverride.setEnabled(!props.isOverridden("slideshowColor"));
        this.jBackgroundColor.setEnabled(!props.isOverridden("slideshowColor"));
    }

    public void writeProperties(PropertiesFile props) {
        int delay;
        if (this.jNoStretch.isSelected() != props.getBooleanProperty("slideshowNoStretch")) {
            ImageUtils.purgeTemp();
            GalleryRemote._().getCore().flushMemory();
        }
        props.setIntProperty("slideshowProgressLocation", ((LocationItem)this.jProgress.getSelectedItem()).id);
        props.setIntProperty("slideshowCaptionLocation", ((LocationItem)this.jCaption.getSelectedItem()).id);
        props.setIntProperty("slideshowExtraLocation", ((LocationItem)this.jExtra.getSelectedItem()).id);
        props.setIntProperty("slideshowUrlLocation", ((LocationItem)this.jUrl.getSelectedItem()).id);
        props.setBooleanProperty("slideshowLowRez", this.jLowRez.isSelected());
        props.setBooleanProperty("slideshowRandom", this.jRandom.isSelected());
        props.setBooleanProperty("slideshowNoStretch", this.jNoStretch.isSelected());
        props.setBooleanProperty("slideshowPreloadAll", this.jPreloadAll.isSelected());
        props.setBooleanProperty("slideshowLoop", this.jLoop.isSelected());
        try {
            delay = (int)Float.parseFloat(this.jDelay.getText());
        }
        catch (NumberFormatException e) {
            Log.logException(1, MODULE, e);
            delay = 7;
        }
        props.setIntProperty("slideshowDelay", delay);
        if (this.jOverride.isSelected()) {
            props.setColorProperty("slideshowColor", this.jBackgroundColor.getSelectedColor());
        } else {
            props.remove("slideshowColor");
        }
        GalleryRemoteCore core = GalleryRemote._().getCore();
        if (!GalleryRemote._().isAppletMode()) {
            ((MainFrame)core).previewFrame.repaint();
        }
    }

    public void buildUI() {
        this.jbInit();
    }

    private void jbInit() {
        Vector<LocationItem> locationItems = new Vector<LocationItem>();
        locationItems.add(new LocationItem(0));
        locationItems.add(new LocationItem(12));
        locationItems.add(new LocationItem(10));
        locationItems.add(new LocationItem(14));
        locationItems.add(new LocationItem(22));
        locationItems.add(new LocationItem(20));
        locationItems.add(new LocationItem(24));
        locationItems.add(new LocationItem(32));
        locationItems.add(new LocationItem(30));
        locationItems.add(new LocationItem(34));
        this.jProgress = new JComboBox(locationItems);
        this.jCaption = new JComboBox(locationItems);
        this.jExtra = new JComboBox(locationItems);
        this.jUrl = new JComboBox(locationItems);
        this.setLayout(new GridBagLayout());
        this.progressionPanel.setLayout(new GridBagLayout());
        this.progressionPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "progressionTitle")));
        this.locationPanel.setLayout(new GridBagLayout());
        this.locationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "locationTitle")));
        this.apperancePanel.setLayout(new GridBagLayout());
        this.apperancePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "appearanceTitle")));
        this.delay.setText(GRI18n.getString(MODULE, "delay"));
        this.delay.setLabelFor(this.jDelay);
        this.delay.setToolTipText(GRI18n.getString(MODULE, "delayHelp"));
        this.help.setText(GRI18n.getString(MODULE, "delayDesc"));
        this.jRandom.setText(GRI18n.getString(MODULE, "random"));
        this.jRandom.setToolTipText(GRI18n.getString(MODULE, "randomHelp"));
        this.jNoStretch.setText(GRI18n.getString(MODULE, "noStretch"));
        this.jNoStretch.setToolTipText(GRI18n.getString(MODULE, "noStretchHelp"));
        this.jPreloadAll.setText(GRI18n.getString(MODULE, "preloadAll"));
        this.jPreloadAll.setToolTipText(GRI18n.getString(MODULE, "preloadAllHelp"));
        this.jLoop.setText(GRI18n.getString(MODULE, "loop"));
        this.jLoop.setToolTipText(GRI18n.getString(MODULE, "loopHelp"));
        this.progress.setText(GRI18n.getString(MODULE, "progress"));
        this.progress.setLabelFor(this.jProgress);
        this.progress.setToolTipText(GRI18n.getString(MODULE, "progressHelp"));
        this.caption.setText(GRI18n.getString(MODULE, "caption"));
        this.caption.setLabelFor(this.jCaption);
        this.caption.setToolTipText(GRI18n.getString(MODULE, "captionHelp"));
        this.extra.setText(GRI18n.getString(MODULE, "extra"));
        this.extra.setLabelFor(this.jExtra);
        this.extra.setToolTipText(GRI18n.getString(MODULE, "extraHelp"));
        this.url.setText(GRI18n.getString(MODULE, "url"));
        this.url.setLabelFor(this.jUrl);
        this.url.setToolTipText(GRI18n.getString(MODULE, "urlHelp"));
        this.jLowRez.setText(GRI18n.getString(MODULE, "lowRez"));
        this.jLowRez.setToolTipText(GRI18n.getString(MODULE, "lowRezHelp"));
        this.jOverride.setText(GRI18n.getString(MODULE, "backgroundColor"));
        this.add((Component)this.progressionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.locationPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.apperancePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.help, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.delay, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.progressionPanel.add((Component)this.jDelay, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.jRandom, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.jPreloadAll, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.jLoop, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jLowRez, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jNoStretch, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jOverride, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jBackgroundColor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.progress, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jProgress, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.caption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jCaption, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.extra, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.url, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jExtra, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.jUrl, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    class LocationItem {
        String name;
        int id;

        public LocationItem(int id) {
            this.id = id;
            this.name = GRI18n.getString(SlideshowPanel.MODULE, "locationItem." + id);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocationItem)) {
                return false;
            }
            return this.id == ((LocationItem)o).id;
        }
    }
}

