/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer.dot;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.claribole.zgrviewer.dot.BasicNode;
import net.claribole.zgrviewer.dot.Cluster;
import net.claribole.zgrviewer.dot.DotUtils;
import net.claribole.zgrviewer.dot.Edge;
import net.claribole.zgrviewer.dot.Graph;
import net.claribole.zgrviewer.dot.Node;
import net.claribole.zgrviewer.dot.Point;
import net.claribole.zgrviewer.dot.Record;
import net.claribole.zgrviewer.dot.Rectangle;
import net.claribole.zgrviewer.dot.SubRecord;

public class SubGraph
extends Node {
    static final int SAME = 0;
    static final int MIN = 1;
    static final int SOURCE = 2;
    static final int MAX = 3;
    static final int SINK = 4;
    static final String[] attributeNames = new String[]{"same", "min", "source", "max", "sink"};
    static final String[] ratioAttributeNames = new String[]{"", "fill", "compress", "expand", "auto"};
    int rank;
    Node[] nodes;
    Edge[] edges;
    Rectangle bb;
    Color bgcolor;
    boolean concentrate = false;
    double defaultdist;
    int dim = 2;
    boolean directed;
    Edge genericEdge = null;
    BasicNode genericNode = new BasicNode(this, "node");
    Record genericRecord = new Record(this, "node");
    Graph genericGraph = null;
    int labeljust = 12;
    int labelloc = 16;
    Point lp;
    double nodesep = 0.25;
    boolean normalize = false;
    int ordering = 42;
    int outputorder = 17;
    int overlap = 35;
    boolean pack = false;
    int packmode = 20;
    int packValue = 8;
    Point2D.Double page;
    int pagedir = 4;
    double quantum = 0.0;
    int rankdir = 0;
    double ranksep;
    double ratio = -1.0;
    boolean record = false;
    boolean remincross = false;
    int rotate = 0;
    int samplepoints = 8;
    int searchsize = 30;
    double sep = 0.01;
    int showboxes = 0;
    Point2D.Double size;
    String stylesheet;
    double voro_margin = 0.05;

    public SubGraph(Object root, String id) throws Exception {
        super(root, id);
        this.genericEdge = new Edge(this, this.genericNode, this.genericRecord);
        this.genericGraph = new Graph();
        if (root instanceof Graph) {
            ((Graph)root).addNode(this);
        } else {
            ((SubGraph)root).addNode(this);
        }
    }

    public SubGraph(Object root) throws Exception {
        super(root);
        this.genericEdge = new Edge(this, this.genericNode, this.genericRecord);
        this.genericGraph = new Graph();
        if (root instanceof Graph) {
            ((Graph)root).addNode(this);
        } else {
            ((SubGraph)root).addNode(this);
        }
    }

    public void addNode(Node node) {
        Graph graph = this.getRootGraph();
        if (graph.genericNodes == null) {
            this.nodes = new Node[1];
            this.nodes[0] = node;
            graph.genericNodes = this.nodes;
        } else {
            boolean addNode = !(node instanceof SubRecord);
            for (int i = 0; i < graph.genericNodes.length; ++i) {
                if (graph.genericNodes[i].id != null) {
                    addNode &= !graph.genericNodes[i].id.equals(node.id);
                }
                if (!addNode) break;
            }
            if (addNode) {
                if (this.nodes == null) {
                    this.nodes = new Node[1];
                    this.nodes[0] = node;
                } else {
                    Node[] tmp = new Node[this.nodes.length + 1];
                    System.arraycopy(this.nodes, 0, tmp, 0, this.nodes.length);
                    tmp[tmp.length - 1] = node;
                    this.nodes = tmp;
                }
                graph.addGenericNode(node);
            }
        }
    }

    public void addEdge(Edge edge) {
        if (this.edges == null) {
            this.edges = new Edge[1];
            this.edges[0] = edge;
        } else {
            boolean addEdge = true;
            for (int i = 0; i < this.edges.length && (addEdge &= this.edges[i].start != edge.start && this.edges[i].end != edge.end); ++i) {
            }
            if (addEdge) {
                Edge[] tmp = new Edge[this.edges.length + 1];
                System.arraycopy(this.edges, 0, tmp, 0, this.edges.length);
                tmp[tmp.length - 1] = edge;
                this.edges = tmp;
            }
        }
        Graph.addNode(edge.start.root, edge.start);
        Graph.addNode(edge.end.root, edge.end);
    }

    public void removeNode(Node node) {
        int i;
        Edge[] in = node.getIn();
        Edge[] out = node.getOut();
        for (i = 0; i < in.length; ++i) {
            this.removeEdge(in[i]);
        }
        for (i = 0; i < out.length; ++i) {
            this.removeEdge(out[i]);
        }
        if (this.nodes != null) {
            for (i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] != node) continue;
                Node[] tmp = new Node[this.nodes.length - 1];
                System.arraycopy(this.nodes, 0, tmp, 0, i);
                System.arraycopy(this.nodes, i + 1, tmp, i, this.nodes.length - i - 1);
                this.nodes = tmp;
                break;
            }
            if (this.nodes.length == 0) {
                this.nodes = null;
            }
        }
    }

    public void removeEdge(Edge edge) {
        if (this.edges != null) {
            for (int i = 0; i < this.edges.length; ++i) {
                if (this.edges[i] != edge) continue;
                Edge[] tmp = new Edge[this.edges.length - 1];
                System.arraycopy(this.edges, 0, tmp, 0, i);
                System.arraycopy(this.edges, i + 1, tmp, i, this.edges.length - i - 1);
                this.edges = tmp;
                break;
            }
            if (this.edges.length == 0) {
                this.edges = null;
            }
        }
    }

    public String toString() {
        int i;
        String g = this.id == null ? "{\n" : "subgraph " + (this instanceof Cluster ? "cluster" : "") + this.id + " {\n";
        if (this.nodes != null) {
            for (i = 0; i < this.nodes.length; ++i) {
                g = g + this.nodes[i];
            }
        }
        if (this.edges != null) {
            for (i = 0; i < this.edges.length; ++i) {
                g = g + this.edges[i];
            }
        }
        return g + "}\n";
    }

    public void changeOption(String name, String value) throws Exception {
        block43: {
            try {
                super.changeOption(name, value);
            }
            catch (Exception e) {
                String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
                v = v.replaceAll("\\\\\\n", "");
                if (name.equals("bb")) {
                    this.bb = DotUtils.readRectangle(v);
                }
                if (name.equals("bgcolor")) {
                    this.bgcolor = DotUtils.readColor(v);
                }
                if (name.equals("concentrate")) {
                    this.concentrate = DotUtils.readBoolean(v);
                }
                if (name.equals("defaultdist")) {
                    this.defaultdist = DotUtils.readDouble(v);
                }
                if (name.equals("dim")) {
                    this.dim = DotUtils.readInteger(v);
                }
                if (name.equals("fontcolor")) {
                    this.fontcolor = DotUtils.readColor(v);
                }
                if (name.equals("fontname")) {
                    this.fontname = v;
                }
                if (name.equals("fontsize")) {
                    this.fontsize = DotUtils.readDouble(v);
                }
                if (name.equals("label")) {
                    this.label = v;
                }
                if (name.equals("labeljust")) {
                    this.labeljust = this.readAttributeNumber(v);
                }
                if (name.equals("labelloc")) {
                    this.labelloc = this.readAttributeNumber(v);
                }
                if (name.equals("lp")) {
                    this.lp = DotUtils.readPoint(v);
                }
                if (name.equals("nodesep")) {
                    this.nodesep = DotUtils.readDouble(v);
                }
                if (name.equals("nojustify")) {
                    this.nojustify = DotUtils.readBoolean(v);
                }
                if (name.equals("normalize")) {
                    this.normalize = DotUtils.readBoolean(v);
                }
                if (name.equals("ordering")) {
                    this.ordering = this.readAttributeNumber(v);
                }
                if (name.equals("outputorder")) {
                    this.outputorder = this.readAttributeNumber(v);
                }
                if (name.equals("overlap")) {
                    this.overlap = this.readAttributeNumber(v);
                }
                if (name.equals("pack")) {
                    try {
                        this.packValue = DotUtils.readInteger(v);
                        this.pack = true;
                    }
                    catch (NumberFormatException ex) {
                        this.pack = DotUtils.readBoolean(v);
                    }
                }
                if (name.equals("packmode")) {
                    this.packmode = this.readAttributeNumber(v);
                }
                if (name.equals("page")) {
                    this.page = DotUtils.readPointf(v);
                }
                if (name.equals("pagedir")) {
                    this.pagedir = this.readAttributeNumber(v);
                }
                if (name.equals("quantum")) {
                    this.quantum = DotUtils.readDouble(v);
                }
                if (name.equals("rankdir")) {
                    this.rankdir = this.readAttributeNumber(v);
                }
                if (name.equals("ranksep")) {
                    this.ranksep = DotUtils.readDouble(v);
                }
                if (name.equals("ratio")) {
                    this.ratio = this.readRatio(v);
                }
                if (name.equals("remincross")) {
                    this.remincross = DotUtils.readBoolean(v);
                }
                if (name.equals("rotate")) {
                    this.rotate = DotUtils.readInteger(v);
                }
                if (!name.equals("orientation")) break block43;
                if (this.rotate == 0) {
                    this.rotate = DotUtils.readOrientation(v);
                }
                if (name.equals("samplepoints")) {
                    this.samplepoints = DotUtils.readInteger(v);
                }
                if (name.equals("searchsize")) {
                    this.searchsize = DotUtils.readInteger(v);
                }
                if (name.equals("sep")) {
                    this.sep = DotUtils.readDouble(v);
                }
                if (name.equals("showboxes")) {
                    this.showboxes = DotUtils.readInteger(v);
                }
                if (name.equals("size")) {
                    this.size = DotUtils.readPointf(v);
                }
                if (name.equals("start")) break block43;
                if (name.equals("stylesheet")) {
                    this.stylesheet = v;
                }
                if (name.equals("target")) {
                    this.target = v;
                }
                if (name.equals("URL") || name.equals("href")) {
                    this.URL = v;
                }
                if (name.equals("voro_margin")) {
                    this.voro_margin = DotUtils.readDouble(v);
                }
                if (name.equals("rank")) {
                    this.rank = this.readAttributeNumber(v);
                }
                System.err.println("SubGraph attribute \"" + name + "\" does not exist");
            }
        }
    }

    private double readRatio(String v) {
        for (int i = 0; i < ratioAttributeNames.length; ++i) {
            if (!ratioAttributeNames[i].equalsIgnoreCase(v)) continue;
            return -i;
        }
        return -1.0;
    }

    private int readAttributeNumber(String v) {
        int value;
        boolean found = false;
        for (value = 0; value < attributeNames.length && !(found = v.equals(attributeNames[value])); ++value) {
        }
        if (found) {
            return value;
        }
        return -1;
    }
}

