# jQuery Mask Plugin
A jQuery Plugin to make masks on form fields and HTML elements.

[![Build Status](https://travis-ci.org/igorescobar/jQuery-Mask-Plugin.png)](https://travis-ci.org/igorescobar/jQuery-Mask-Plugin)
[![Code Climate](https://codeclimate.com/github/igorescobar/jQuery-Mask-Plugin.png)](https://codeclimate.com/github/igorescobar/jQuery-Mask-Plugin)
[![jsDelivr Hits](https://data.jsdelivr.com/v1/package/npm/jquery-mask-plugin/badge?style=rounded)](https://www.jsdelivr.com/package/npm/jquery-mask-plugin)
[![CDNJS](https://img.shields.io/cdnjs/v/jquery.mask.svg)](https://cdnjs.com/libraries/jquery.mask)

# Documentation, Demos & Usage Examples
https://igorescobar.github.io/jQuery-Mask-Plugin/

## Features

  * Lightweight (~2kb minified, ~1kb gziped).
  * Built-in support for dynamically added elements.
  * Masks on any HTML element (no need to server-side mask anymore!)!
  * HTML notation support (data-mask, data-mask-recursive, data-mask-clearifnotmatch).
  * String/Numeric/Alpha/Mixed masks.
  * Reverse mask support for masks on numeric fields.
  * Sanitization.
  * Optional digits.
  * Recursive Digits.
  * Fallback Digits.
  * Advanced mask initialization.
  * Advanced Callbacks.
  * On-the-fly mask change.
  * Mask removal.
  * Full customization.
  * Compatibility with React/UMD/Zepto.js/Angular.JS.
  * HTML5 placeholder support.
  * Clear the field if it not matches support.

## Want to buy me a beer? :heart_eyes:
http://paypal.me/igorcescobar

## Install it via Package Managers
### Bower
`bower install jquery-mask-plugin`
### NPM
`npm i jquery-mask-plugin`
### Meteor
`meteor add igorescobar:jquery-mask-plugin`
### Packagist/Composer
`composer require igorescobar/jquery-mask-plugin`

## CDNs
### CDNjs
https://cdnjs.com/libraries/jquery.mask
### JSDelivr
http://www.jsdelivr.com/projects/jquery.mask

## RubyGems
```ruby
gem 'jquery_mask_rails' # more details at http://bit.ly/jquery-mask-gem
```

## Tutorials
### English
  * [Masks with jQuery Mask Plugin](http://bit.ly/masks-with-jquery-mask-plugin)
  * [Using jQuery Mask Plugin With Zepto.js](http://bit.ly/using-jquery-mask-plugin-with-zeptojs)

### Portuguese
  * [Mascaras com JQuery Mask Plugin](http://bit.ly/mascaras-com-jquery-mask-plugin)
  * [Mascara Javascript para os novos telefones de São Paulo](http://bit.ly/mascara-javascript-para-os-novos-telefones-de-sao-paulo)

### Fun (or not) facts
  * [I’ve had the chance to troll Donald Trump. But I didn’t.](http://www.igorescobar.com/blog/2016/08/21/ive-the-chance-to-troll-donald-trump-but-i-didnt/)

## Compatibility
jQuery Mask Plugin has been tested with jQuery 1.7+ on all major browsers:

 * Firefox 2+ (Win, Mac, Linux);
 * IE7+ (Win);
 * Chrome 6+ (Win, Mac, Linux, Android, iPhone);
 * Safari 3.2+ (Win, Mac, iPhone);
 * Opera 8+ (Win, Mac, Linux, Android, iPhone).
 * Android Default Browser v4+

## Typescript support
Definition can be found [here](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/jquery-mask-plugin).

To install, open terminal and navigate to your working directory.

### Typescript 1.x users
  * Install [typings](https://github.com/typings/typings) by running `npm install typings --global`.
  * Then install the definition by running `typings install dt~jquery-mask-plugin --global --save`.
### Typescript 2.x users
  * Use npm `npm install --save-dev @types/jquery-mask-plugin`.

For configuration options and troubleshooting refer to these repositories:
* [Typings](https://github.com/typings/typings)
* [DefinitelyTyped](https://github.com/DefinitelyTyped/DefinitelyTyped)
* [Typescript](https://github.com/Microsoft/TypeScript)


## Problems or Questions?
Before opening a new [issue](https://github.com/igorescobar/jQuery-Mask-Plugin/issues) take a look on those frequently asked questions:
#### [How to integrate with React.js?](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/498)
#### [How to integrate with Angular.js?](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/499)
#### [How to integrate with Vue.js?](https://github.com/ankurk91/vue-jquery-mask)
#### [Problems with old versions of Android keyboard](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/135)
#### [Negative numbers, or currency related problems](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/436#issuecomment-253176511)
#### [Prefix or sufix on the Mask](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/166)
#### [Add validation?](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/387#issuecomment-192998092)
#### [Field type number, email not working?](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/450#issuecomment-253225719)
#### [Want to keep the placeholder as the user types?](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/633#issuecomment-350819224)
#### [E-mail mask?](https://github.com/igorescobar/jQuery-Mask-Plugin/issues/582)

## Bugs?
Did you read our [docs](https://igorescobar.github.io/jQuery-Mask-Plugin/docs.html)? Yes? Cool! So now... make sure that you have a *functional* [jsfiddle](http://jsfiddle.net/) exemplifying your problem and open an [issue](https://github.com/igorescobar/jQuery-Mask-Plugin/issues) for us. Don't know how to do it? Use this [fiddle example](http://jsfiddle.net/igorescobar/6pco4om7/).

## Contributing
 * **Bug Reporting**: Yes! You can contribute opening [issues](https://github.com/igorescobar/jQuery-Mask-Plugin/issues)!
 * **Documenting**: Do you think that something in our [docs](https://github.com/igorescobar/jQuery-Mask-Plugin/tree/gh-pages) should be better? Do you have a cool idea to increase the awesomeness? Summit your pull request with your idea!
 * **Bug Fixing**: No time to lose? Fix it and help others! Write some [tests](https://github.com/igorescobar/jQuery-Mask-Plugin/tree/master/test) to make sure that everything are working propertly.
 * **Improving**: Open an [issue](https://github.com/igorescobar/jQuery-Mask-Plugin/issues) and lets discuss it. Just to make sure that you're on the right track.
 * **Sharing**: Yes! Have we saved some of your time? Are you enjoying our mask plugin? Sharing is caring! Tweet it! Facebook it! Linkedin It(?!) :D
 * **Donating**: Hey, now that you don't need to worry about masks again... buy me a coffee, beer or a PlayStation 4 (Xbox One also accepted!) :o)

### Unit Tests
We use [QUnit](http://qunitjs.com/) and [GruntJS](http://gruntjs.com/). To run our test suit is just run: ```grunt test``` in your console or you can open those ```test-for*.html``` files inside of our ```test/``` folder.

In case you're familiar with [Docker](https://www.docker.com/) here is how you can use it:
```bash
docker build -t jquery-mask .
CONTAINER_ID=$(docker run -d -v $PWD:/app/jquery-mask-plugin jquery-mask)
docker exec $CONTAINER_ID sh -c "npm install"
docker exec -it $CONTAINER_ID /bin/bash
grunt test
```

## Contributors
 * [Igor Lima](https://github.com/igorlima)
 * [Mark Simmons](https://github.com/Markipelago)
 * [Gabriel Schammah](https://github.com/gschammah)
 * [Marcelo Manzan](https://github.com/kawamanza)
 * [See the full list](https://github.com/igorescobar/jQuery-Mask-Plugin/graphs/contributors)
