/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as b,css as g,html as p}from"lit";import{property as l,state as m,customElement as v}from"lit/decorators.js";import{EditorView as u,lineNumbers as w,highlightSpecialChars as k,drawSelection as E,placeholder as S,keymap as M}from"@codemirror/view";import{Compartment as C,EditorState as c}from"@codemirror/state";import{syntaxHighlighting as x,defaultHighlightStyle as D}from"@codemirror/language";import{defaultKeymap as V,indentWithTab as z}from"@codemirror/commands";import{oneDark as K}from"@codemirror/theme-one-dark";import{executeJavaScriptModuleInstruction as f,loadModule as O,resolveSubjectRef as R}from"@typo3/core/java-script-item-processor.js";import"@typo3/backend/element/spinner-element.js";var i=function(h,e,o,r){var n=arguments.length,a=n<3?e:r===null?r=Object.getOwnPropertyDescriptor(e,o):r,s;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")a=Reflect.decorate(h,e,o,r);else for(var d=h.length-1;d>=0;d--)(s=h[d])&&(a=(n<3?s(a):n>3?s(e,o,a):s(e,o))||a);return n>3&&a&&Object.defineProperty(e,o,a),a};let t=class extends b{constructor(){super(...arguments),this.mode=null,this.addons=[],this.keymaps=[],this.lineDigits=0,this.autoheight=!1,this.nolazyload=!1,this.readonly=!1,this.fullscreen=!1,this.panel="bottom",this.editorTheme=null,this.editorView=null}static{this.styles=g`:host{position:relative;display:block}:host([fullscreen]){position:fixed;inset:64px 0 0;z-index:9}:host([fullscreen]) .cm-scroller{min-height:auto;max-height:100%}:host([autoheight]) .cm-scroller{max-height:none}.codemirror-label{font-size:.875em;opacity:.75}.codemirror-label-top{margin-bottom:.25rem}.codemirror-label-bottom{margin-top:.25rem}typo3-backend-spinner{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%)}.cm-editor{overflow:hidden;border-radius:var(--typo3-input-border-radius);border:var(--typo3-input-border-width) solid var(--typo3-input-border-color);transition:outline-color .15s ease-in-out,box-shadow .15s ease-in-out}.cm-focused{border-color:var(--typo3-input-focus-border-color);outline-offset:0;outline:.25rem solid color-mix(in srgb,var(--typo3-form-control-focus-border-color),transparent 25%)}.cm-gutters{height:auto!important;position:relative!important}.cm-content{min-height:calc(8px + 16.8px*var(--rows, 18))!important}.cm-scroller{min-height:100%;max-height:calc(100dvh - 10rem)}`}setContent(e){this.editorView!==null&&this.editorView.dispatch({changes:{from:0,to:this.editorView.state.doc.length,insert:e}})}getContent(){return this.editorView.state.doc.toString()}render(){return p`${this.label&&this.panel==="top"?p`<div class="codemirror-label codemirror-label-top">${this.label}</div>`:""}<div id=codemirror-parent @keydown=${e=>this.onKeydown(e)}></div>${this.label&&this.panel==="bottom"?p`<div class="codemirror-label codemirror-label-bottom">${this.label}</div>`:""} ${this.editorView===null?p`<typo3-backend-spinner size=large></typo3-backend-spinner>`:""}`}firstUpdated(){if(this.nolazyload){this.initializeEditor(this.firstElementChild);return}const e={root:document.body},o=new IntersectionObserver(r=>{r.forEach(n=>{n.intersectionRatio>0&&(o.unobserve(n.target),this.firstElementChild&&this.firstElementChild.nodeName.toLowerCase()==="textarea"&&this.initializeEditor(this.firstElementChild))})},e);o.observe(this)}onKeydown(e){e.ctrlKey&&e.altKey&&e.key==="f"&&(e.preventDefault(),this.fullscreen=!0),e.key==="Escape"&&this.fullscreen&&(e.preventDefault(),this.fullscreen=!1)}async initializeEditor(e){const o=u.updateListener.of(s=>{s.docChanged&&(e.value=s.state.doc.toString(),e.dispatchEvent(new CustomEvent("change",{bubbles:!0})))});this.lineDigits>0?this.style.setProperty("--rows",this.lineDigits.toString()):e.getAttribute("rows")&&this.style.setProperty("--rows",e.getAttribute("rows")),this.editorTheme=new C;const r=[this.editorTheme.of([]),o,w(),k(),E(),c.allowMultipleSelections.of(!0),x(D,{fallback:!0})];if(this.readonly&&r.push(c.readOnly.of(!0)),this.placeholder&&r.push(S(this.placeholder)),this.mode){const s=await f(this.mode);r.push(...s)}this.addons.length>0&&r.push(...await Promise.all(this.addons.map(s=>f(s))));const n=[...V,z];this.keymaps.length>0&&(await Promise.all(this.keymaps.map(d=>O(d).then(y=>R(y,d))))).forEach(d=>n.push(...d)),r.push(M.of(n)),this.editorView=new u({state:c.create({doc:e.value,extensions:r}),parent:this.renderRoot.querySelector("#codemirror-parent"),root:this.renderRoot}),this.toggleDarkMode(this.darkModeEnabled()),window.matchMedia("(prefers-color-scheme: dark)").addEventListener("change",()=>{this.toggleDarkMode(this.darkModeEnabled())})}darkModeEnabled(){const o=window.getComputedStyle(this).colorScheme;return o==="light only"||o==="light"?!1:o==="dark only"||o==="dark"?!0:window.matchMedia("(prefers-color-scheme: dark)").matches}toggleDarkMode(e){this.editorView.dispatch({effects:this.editorTheme.reconfigure(e?K:[])})}};i([l({type:Object})],t.prototype,"mode",void 0),i([l({type:Array})],t.prototype,"addons",void 0),i([l({type:Array})],t.prototype,"keymaps",void 0),i([l({type:Number})],t.prototype,"lineDigits",void 0),i([l({type:Boolean,reflect:!0})],t.prototype,"autoheight",void 0),i([l({type:Boolean})],t.prototype,"nolazyload",void 0),i([l({type:Boolean})],t.prototype,"readonly",void 0),i([l({type:Boolean,reflect:!0})],t.prototype,"fullscreen",void 0),i([l({type:String})],t.prototype,"label",void 0),i([l({type:String})],t.prototype,"placeholder",void 0),i([l({type:String})],t.prototype,"panel",void 0),i([m()],t.prototype,"editorTheme",void 0),i([m()],t.prototype,"editorView",void 0),t=i([v("typo3-t3editor-codemirror")],t);export{t as CodeMirrorElement};
