<?php

declare(strict_types=1);

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace TYPO3\CMS\Install\ViewHelpers\Format;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * ViewHelper to remove all spaces in a string.
 *
 * ```
 *   <i:format.noSpace value="category-{extensionKey}-{categoryName}" />
 * ```
 *
 * @internal
 */
final class NoSpaceViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('value', 'string', '', true);
    }

    /**
     * Render a string with whitespaces stripped.
     */
    public function render(): string
    {
        return preg_replace('/\s+/', '', $this->arguments['value']);
    }
}
