/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as P,html as R}from"lit";import{property as T,queryAssignedElements as A,customElement as O}from"lit/decorators.js";import M from"@typo3/core/ajax/ajax-request.js";import L from"@typo3/core/event/debounce-event.js";import{prefixAndRebaseCss as j}from"@typo3/rte-ckeditor/css-prefixer.js";import{ClassicEditor as K}from"@ckeditor/ckeditor5-editor-classic";var x=function(l,e,o,t){var s=arguments.length,r=s<3?e:t===null?t=Object.getOwnPropertyDescriptor(e,o):t,a;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(l,e,o,t);else for(var i=l.length-1;i>=0;i--)(a=l[i])&&(r=(s<3?a(r):s>3?a(e,o,r):a(e,o))||r);return s>3&&r&&Object.defineProperty(e,o,r),r};const N=[{module:"@ckeditor/ckeditor5-block-quote",exports:["BlockQuote"]},{module:"@ckeditor/ckeditor5-essentials",exports:["Essentials"]},{module:"@ckeditor/ckeditor5-find-and-replace",exports:["FindAndReplace"]},{module:"@ckeditor/ckeditor5-heading",exports:["Heading"]},{module:"@ckeditor/ckeditor5-indent",exports:["Indent","IndentBlock"]},{module:"@ckeditor/ckeditor5-link",exports:["Link"]},{module:"@ckeditor/ckeditor5-list",exports:["List"]},{module:"@ckeditor/ckeditor5-paragraph",exports:["Paragraph"]},{module:"@ckeditor/ckeditor5-clipboard",exports:["PastePlainText"]},{module:"@ckeditor/ckeditor5-paste-from-office",exports:["PasteFromOffice"]},{module:"@ckeditor/ckeditor5-remove-format",exports:["RemoveFormat"]},{module:"@ckeditor/ckeditor5-table",exports:["Table","TableToolbar","TableProperties","TableCellProperties","TableCaption"]},{module:"@ckeditor/ckeditor5-typing",exports:["TextTransformation"]},{module:"@ckeditor/ckeditor5-source-editing",exports:["SourceEditing"]},{module:"@ckeditor/ckeditor5-alignment",exports:["Alignment"]},{module:"@ckeditor/ckeditor5-style",exports:["Style"]},{module:"@ckeditor/ckeditor5-html-support",exports:["GeneralHtmlSupport"]},{module:"@ckeditor/ckeditor5-basic-styles",exports:["Bold","Italic","Subscript","Superscript","Strikethrough","Underline"]},{module:"@ckeditor/ckeditor5-special-characters",exports:["SpecialCharacters","SpecialCharactersEssentials"]},{module:"@ckeditor/ckeditor5-horizontal-line",exports:["HorizontalLine"]}];let h=class extends P{constructor(){super(...arguments),this.options={},this.styleSheets=new Map}connectedCallback(){super.connectedCallback(),this.prefixAndLoadContentsCss()}disconnectedCallback(){super.disconnectedCallback(),document.adoptedStyleSheets=document.adoptedStyleSheets.filter(e=>!this.styleSheets.has(e)),this.styleSheets.clear()}firstUpdated(){this.target[0]instanceof HTMLTextAreaElement?this.initCKEditor():this.renderRoot.querySelector('slot[name="textarea"]').addEventListener("slotchange",()=>this.initCKEditor(),{once:!0})}async initCKEditor(){if(!(this.target[0]instanceof HTMLTextAreaElement))throw new Error("No rich-text <textarea> content target found.");const{importModules:e,removeImportModules:o,width:t,height:s,readOnly:r,debug:a,toolbar:i,placeholder:u,htmlSupport:n,wordCount:c,typo3link:p,removePlugins:g,...m}=this.options;"extraPlugins"in m&&delete m.extraPlugins,"contentsCss"in m&&delete m.contentsCss;const S=await this.resolvePlugins(N,e,o),f={licenseKey:"GPL",...m,toolbar:i,plugins:S,placeholder:u,wordCount:c,typo3link:p||null,removePlugins:g||[]};n!==void 0&&(f.htmlSupport=C(n)),f?.typing?.transformations!==void 0&&(f.typing.transformations=C(f.typing.transformations)),K.create(this.target[0],f).then(d=>{if(this.applyEditableElementStyles(d,t,s),this.handleWordCountPlugin(d,c),this.applyReadOnly(d,r),d.model.document.on("change:data",()=>{d.updateSourceElement(),this.target[0].dispatchEvent(new Event("change",{bubbles:!0,cancelable:!0}))}),d.plugins.has("SourceEditing")){const y=d.plugins.get("SourceEditing");y.on("change:isSourceEditingMode",(H,I,v)=>{for(const[w]of d.editing.view.domRoots)if(v){const E=d.ui.getEditableElement(`sourceEditing:${w}`);if(E instanceof HTMLTextAreaElement)new L("input",()=>{y.updateEditorData()},100).bindTo(E);else throw new Error("Cannot find textarea related to source editing. Has CKEditor been upgraded?")}})}a&&import("@ckeditor/ckeditor5-inspector").then(({default:y})=>y.attach(d,{isCollapsed:!0}))})}render(){return R`<slot name=textarea></slot><slot></slot>`}async resolvePlugins(e,o,t){const s=b(t||[]),r=b([...e,...o||[]]).map(n=>{const{module:c}=n;let{exports:p}=n;for(const g of s)g.module===c&&(p=p.filter(m=>!g.exports.includes(m)));return{module:c,exports:p}}),a=await Promise.all(r.map(async n=>{try{return{module:await import(n.module),exports:n.exports}}catch(c){return console.error(`Failed to load CKEditor5 module ${n.module}`,c),{module:null,exports:[]}}})),i=[];a.forEach(({module:n,exports:c})=>{for(const p of c)p in n?i.push(n[p]):console.error(`CKEditor5 plugin export "${p}" not available in`,n)});const u=i.filter(n=>n.overrides?.length>0).map(n=>n.overrides).flat(1);return i.filter(n=>!u.includes(n))}async prefixAndLoadContentsCss(){if(!Array.isArray(this.options.contentsCss))return;const o=(await Promise.allSettled(this.options.contentsCss.map(t=>this.prefixContentsCss(t,this.getAttribute("id"))))).map(t=>t.status==="fulfilled"?t.value:null).filter(t=>t!==null);o.forEach(t=>this.styleSheets.set(t,!0)),document.adoptedStyleSheets=[...document.adoptedStyleSheets,...o]}async prefixContentsCss(e,o){let t;try{t=await(await new M(e).get()).resolve()}catch(i){throw console.error(`Failed to fetch CSS content for CKEditor5 prefixing: "${e}"`,i),new Error}const s=`#${o} .ck-content`,r=j(t,e,s),a=new CSSStyleSheet;return await a.replace(r),a}applyEditableElementStyles(e,o,t){const s=e.editing.view,r={"min-height":t,"min-width":o};Object.keys(r).forEach(a=>{const i=r[a];if(!i)return;let u;typeof i=="number"||!Number.isNaN(Number(u))?u=`${i}px`:u=i,s.change(n=>{n.setStyle(a,u,s.document.getRoot())})})}handleWordCountPlugin(e,o){if(e.plugins.has("WordCount")&&(o?.displayWords||o?.displayCharacters)){const t=e.plugins.get("WordCount");this.appendChild(t.wordCountContainer)}}applyReadOnly(e,o){o&&e.enableReadOnlyMode("typo3-lock")}};x([T({type:Object})],h.prototype,"options",void 0),x([A({slot:"textarea"})],h.prototype,"target",void 0),h=x([O("typo3-rte-ckeditor-ckeditor5")],h);function k(l,e){if(typeof l=="object"){if(Array.isArray(l))return l.map(t=>e(t)??k(t,e));const o={};for(const[t,s]of Object.entries(l))o[t]=e(s)??k(s,e);return o}return l}function C(l){return k(l,e=>{if(typeof e=="object"&&"pattern"in e&&typeof e.pattern=="string"){const o=e;return new RegExp(o.pattern,o.flags||void 0)}return null})}function b(l){return l.map(e=>typeof e=="string"?{module:e,exports:["default"]}:e)}export{h as CKEditor5Element};
