--
-- (C) 2019-24 - ntop.org
--

-- ##############################################

local flow_alert_keys = require "flow_alert_keys"

-- Import the classes library.
local classes = require "classes"
-- Make sure to import the Superclass!
local alert = require "alert"
-- Import Mitre Att&ck utils
local mitre = require "mitre_utils"

-- ##############################################

local alert_ndpi_malware_host_contacted = classes.class(alert)

-- ##############################################

alert_ndpi_malware_host_contacted.meta = {
  alert_key = flow_alert_keys.flow_alert_ndpi_malware_host_contacted,
  i18n_title = "flow_checks_config.ndpi_malware_host_contacted",
  icon = "fas fa-fw fa-exclamation",

   -- Mitre Att&ck Matrix values
   mitre_values = {
      mitre_tactic = mitre.tactic.reconnaissance,
      mitre_technique = mitre.technique.phishing_info,
      mitre_sub_technique = mitre.sub_technique.spearphishing_service,
      mitre_id = "T1598.001"
   },
}

-- ##############################################

-- @brief Prepare an alert table used to generate the alert
-- @return A table with the alert built
function alert_ndpi_malware_host_contacted:init()
   -- Call the parent constructor
   self.super:init()
end

-- #######################################################

function alert_ndpi_malware_host_contacted.format(ifid, alert, alert_type_params)
   return i18n("flow_risk.ndpi_malware_host_contacted_alert_descr")
end

-- #######################################################

return alert_ndpi_malware_host_contacted

