/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
const Dashboard={dashboards:{},getActiveDashboard:function(){var t="";$.each(this.dashboards,function(e,a){if($(a.elem_dom).is(":visible")){t=e;return false}});return this.dashboards[t]}};class GLPIDashboard{constructor(t){const e=this;this.grid=null;this.elem_id="";this.element=null;this.elem_dom=null;this.rand=null;this.interval=null;this.current_name=null;this.markdown_editors=[];this.all_cards=[];this.all_widgets=[];this.edit_mode=false;this.embed=false;this.ajax_cards=false;this.context="core";this.markdown_contents=[];this.dash_width=0;this.cell_margin=3;this.cols=26;this.cache_key="";this.filters="{}";this.filters_selector="";var a=typeof t!=="undefined"?t:{};var i={cols:24,rows:24,cell_length:40,cell_margin:5,rand:"",embed:false,token:null,entities_id:null,is_recursive:null,ajax_cards:true,all_cards:[],context:"core"};a=Object.assign({},i,a);this.rand=a.rand;this.elem_id="#dashboard-"+a.rand;this.element=$(this.elem_id);this.elem_dom=this.element[0];this.current_name=$(this.elem_id+" .dashboard_select").val()||a.current;this.embed=a.embed;this.token=a.token;this.entities_id=a.entities_id;this.is_recursive=a.is_recursive;this.ajax_cards=a.ajax_cards;this.all_cards=a.all_cards;this.all_widgets=a.all_widgets;this.context=a.context;this.dash_width=this.element.width();this.cell_margin=a.cell_margin;this.cols=a.cols;this.cache_key=a.cache_key||"";this.filters_selector=this.elem_id+" .filters";var r=this.elem_dom.getBoundingClientRect();var s=r.left+(window.innerWidth-r.right)+.02;this.grid=GridStack.init({column:a.cols,maxRow:a.rows+1,margin:this.cell_margin,float:true,animate:false,draggable:{cancel:"textarea"},minWidth:768-s},"#grid-stack-"+a.rand);this.grid.setStatic(true);this.generateCss();this.resizeSelect();this.initFilters();this.refreshDashboard();if(!this.ajax_cards){this.fitNumbers();this.animateNumbers()}$("#dashboard-"+a.rand+" .toolbar .dashboard_select").change(function(){e.current_name=$(this).val();var t=$(this).find("option:selected").text();$(".dashboard-name").val(t);e.refreshDashboard();e.setLastDashboard();e.initFilters()});$("#dashboard-"+a.rand+" .toolbar .add-dashboard").click(function(){e.addForm()});$(document).on("submit",".display-add-dashboard-form",function(t){t.preventDefault();glpi_close_all_dialogs();var a=$(this);var i={};$.each(a.closest(".display-add-dashboard-form").serializeArray(),function(){i[this.name]=this.value});e.addNew(i)});$("#dashboard-"+a.rand+" .toolbar .delete-dashboard").click(function(){e.delete()});$("#dashboard-"+a.rand+" .toolbar .clone-dashboard").click(function(){e.clone()});$("#dashboard-"+a.rand+" .toolbar .open-embed").click(function(){glpi_ajax_dialog({title:__("Share or embed this dashboard"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_embed_form",dashboard:e.current_name}})});$("#dashboard-"+a.rand+" .toolbar .edit-dashboard").click(function(){var t=!$(this).hasClass("active");e.setEditMode(t)});var d="#dashboard-"+a.rand+" .toggle-fullscreen";$(d).click(function(){e.toggleFullscreenMode($(this))});$(document).on("fullscreenchange webkitfullscreenchange mozfullscreenchange MSFullscreenChange",function(){if(!document.webkitIsFullScreen&&!document.mozFullScreen&&!document.msFullscreenElement!==null){e.disableFullscreenMode()}});$("#dashboard-"+a.rand+" .toolbar .night-mode").click(function(){$(this).toggleClass("active");e.element.toggleClass("theme-dark")});$("#dashboard-"+a.rand+" .toolbar .auto-refresh").click(function(){$(this).toggleClass("active");var t=$(this).hasClass("active");if(t){var a=parseInt(CFG_GLPI.refresh_views);if(a==0||Number.isNaN(a)){a=30}var i=a*60;e.interval=setInterval(function(){e.refreshDashboard()},i*1e3)}else{clearInterval(e.interval)}});var n;$(window).on("resize",function(t){if(t.target.constructor.name!=="Window"){return}window.clearTimeout(n);n=window.setTimeout(function(){e.generateCss();e.fitNumbers()},200)});$(document).on("click",".display-rights-form .save_rights",function(){glpi_close_all_dialogs();var t=$(this);var a={};var i;$.each(t.closest(".display-rights-form").serializeArray(),function(){var t=this.value.split("-");if(t.length!==2){return}var e=t[0];var i=t[1];if(!(e in a)){a[e]=[]}a[e].push(i)});i=t.closest(".display-rights-form").find('select[name="is_private"]').val();$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_rights",dashboard:e.current_name,rights:a,is_private:i}})});this.grid.on("dragstop",function(){e.saveDashboard()});this.grid.on("resizestop",function(t,a){e.saveDashboard();var i=$(a).find(".ct-chart");if(i.length>0&&i[0].__chartist__!=undefined){i[0].__chartist__.update()}e.resetComputedWidth($("body").find(".big-number").find(".formatted-number"));e.resetComputedWidth($("body").find(".big-number").find(".label"));e.fitNumbers($(a));e.animateNumbers($(a))});$(document).on("click","#dashboard-"+a.rand+" .delete-item",function(){var t=$(this);var a=t.closest(".grid-stack-item")[0];e.grid.removeWidget(a);e.saveDashboard()});$(document).on("click","#dashboard-"+a.rand+" .refresh-item",function(){var t=$(this);var a=t.closest(".grid-stack-item");var i=a.attr("gs-id");e.getCardsAjax("[gs-id="+i+"]")});$(document).on("click","#dashboard-"+a.rand+" .edit-item",function(){var t=$(this);var a=t.parent().parent(".grid-stack-item");var i=a.data("card-options");glpi_ajax_dialog({title:__("Edit this card"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_edit_widget",dashboard:e.current_name,gridstack_id:a.attr("gs-id"),card_id:i.card_id,x:a.attr("gs-x"),y:a.attr("gs-y"),width:a.attr("gs-w"),height:a.attr("gs-h"),card_options:i}})});$(document).on("click","#dashboard-"+a.rand+" .cell-add",function(){var t=$(this);glpi_ajax_dialog({title:__("Add a card"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_add_widget",dashboard:e.current_name,x:t.data("x"),y:t.data("y")}})});$(document).on("submit",".display-widget-form ",function(t){t.preventDefault();e.setWidgetFromForm($(this))});$(document).on("click","#dashboard-"+a.rand+" .filters_toolbar .add-filter",function(){glpi_close_all_dialogs();var t=e.getFiltersFromDB();var a=Object.keys(t);glpi_ajax_dialog({title:__("Add a filter"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_add_filter",dashboard:e.current_name,used:a}})});$(document).on("submit",".display-filter-form ",function(t){t.preventDefault();var a=$(this);e.setFilterFromForm(a)});$(document).on("click","#dashboard-"+a.rand+" .filters_toolbar .delete-filter",function(){var t=$(this).closest(".filter");var a=t.data("filter-id");t.remove();var i=e.getFiltersFromDB();delete i[a];e.setFiltersInDB(i);e.refreshCardsImpactedByFilter(a)});$(document).on("click",".save-dashboard-name ",function(t){t.preventDefault();$(".dashboard_select option[value="+e.current_name+"]").text($(".dashboard-name").val());e.saveDashboard();$(".display-message").addClass("success").text(__("Saved")).show("fade").delay(2e3).hide("fade")});$(document).on("select2:select",".display-widget-form select[name=card_id]",function(t){var a=t.params.data;var i=a.id;var r=$(this).closest(".display-widget-form").find(".widgettype_field");var s=e.all_cards[i].widgettype;var d=s.length===1;r.show().find("input[type=radio]").next("label").css("display","none").end().filter("[value='"+s.join("'],[value='")+"']").prop("checked",d).trigger("change").next("label").css("display","inline-block")});$(document).on("change",".display-widget-form [name=widgettype]",function(){var t=$(this);var a=t.val();var i=e.all_widgets[a];var r=i.gradient||false;var s=i.pointlbl||false;var d=i.limit||false;var n=i.width||2;var o=i.height||2;var l=t.closest(".display-widget-form");l.find(".gradient_field").toggle(r);l.find(".pointlbl_field").toggle(s);l.find(".limit_field").toggle(d);var c=l.find('[name="width"]');var h=l.find('[name="height"]');if(c.val()==0){c.val(n)}if(h.val()==0){h.val(o)}});$(document).on("input",".card.markdown textarea.markdown_content",function(){e.saveMarkdown($(this))});$(window).on("resize.fittext",function(){e.computeWidth($("body").find(".big-number").find(".formatted-number"));e.computeWidth($("body").find(".big-number").find(".label"))});Dashboard.dashboards[a.rand]=this}saveMarkdown(t){var e=t.closest(".grid-stack-item");var a=t.val();var i=e.attr("gs-id");e.addClass("dirty");this.markdown_contents[i]=a}setWidgetFromForm(t){const e=this;glpi_close_all_dialogs();var a={};$.each(t.serializeArray(),function(){a[this.name]=this.value});if(a.card_id==="0"){return false}a.card_options=a.card_options||{};if(typeof a.card_options==="string"){a.card_options=JSON.parse(a.card_options)}var i="old_id"in a&&a.old_id.length>0;a.card_options.color=a.color||null;a.card_options.widgettype=a.widgettype||null;a.card_options.use_gradient=a.use_gradient||0;a.card_options.point_labels=a.point_labels||0;a.card_options.limit=a.limit||7;if(a.card_id==="markdown_editable"&&!("markdown_content"in a.card_options)){a.card_options.markdown_content=""}if(i===true){if(a.old_id==="0"){return false}var r=$(".grid-stack-item[gs-id="+a.old_id+"]")[0];this.grid.removeWidget(r)}var s=getUuidV4();a.gridstack_id=a.card_id+"_"+s;a.card_options.card_id=a.card_id;a.card_options.gridstack_id=a.gridstack_id;var d=a.card_options;d.force=true;d.apply_filters=this.getFiltersFromDB();var n=this.addWidget(a);$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"get_card",dashboard:this.current_name,card_id:a.card_id,cache_key:this.cache_key,args:d}}).done(function(t){n.children(".grid-stack-item-content").append(t);e.fitNumbers(n);e.animateNumbers(n);e.saveDashboard()})}addWidget(t){var e=t.gridstack_id;var a=parseInt(t.x||-1);var i=parseInt(t.y||-1);var r=parseInt(t.width||2);var s=parseInt(t.height||2);var d=t.card_options||{};var n='       <div class="grid-stack-item">          <span class="controls">             <i class="refresh-item ti ti-refresh" title="'+__("Refresh this card")+'"></i>             <i class="edit-item ti ti-edit" title="'+__("Edit this card")+'"></i>             <i class="delete-item ti ti-x" title="'+__("Delete this card")+'"></i>          </span>          <div class="grid-stack-item-content">          </div>       </div>';var o=this.grid.addWidget(n,{x:a,y:i,w:r,h:s,autoPosition:a<0||i<0,id:e});$(o).attr("data-card-options",JSON.stringify(d));return $(o)}setFilterFromForm(t){const e=this;glpi_close_all_dialogs();var a={};$.each(t.serializeArray(),function(){a[this.name]=this.value});$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"get_filter",filter_id:a.filter_id}}).done(function(t){$(e.filters_selector).append(t);e.saveFilter(a.filter_id,[])})}refreshDashboard(){const t=this;var e=$(this.elem_id+" .grid-stack");this.grid.removeAll();let a={dashboard:this.current_name,action:"get_dashboard_items"};if(this.embed){a.embed=1;a.token=this.token;a.entities_id=this.entities_id;a.is_recursive=this.is_recursive}$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:a}).done(function(a){e.prepend(a);e.find(".grid-stack-item").each(function(){t.grid.makeWidget($(this)[0])});t.getCardsAjax()})}setLastDashboard(){$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{dashboard:this.current_name,page:(location.origin+location.pathname).replace(CFG_GLPI.url_base,""),action:"set_last_dashboard"}})}saveFilter(t,e){var a=this.getFiltersFromDB();a[t]=e;this.setFiltersInDB(a);sortable(this.filters_selector,"reload");this.refreshCardsImpactedByFilter(t)}refreshCardsImpactedByFilter(t){const e=this;$(".dashboard .card.filter-"+t).each(function(){var t=$(this).closest(".grid-stack-item");var a=t.attr("gs-id");e.getCardsAjax("[gs-id="+a+"]")})}saveDashboard(t){const e=this;t=t|false;var a=$.makeArray(this.element.find(".grid-stack-item:visible:not(.grid-stack-placeholder)")).map(function(t){var a=$(t).attr("gs-id");var i=$(t).data("card-options");if(_.keys(e.markdown_contents).length>0&&a in e.markdown_contents){i.markdown_content=e.markdown_contents[a]}return a?{gridstack_id:$(t).attr("gs-id"),card_id:i.card_id,x:$(t).attr("gs-x"),y:$(t).attr("gs-y"),width:$(t).attr("gs-w"),height:$(t).attr("gs-h"),card_options:i}:null});$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_items",dashboard:this.current_name,items:a,title:$(".dashboard-name").val()}}).done(function(){if(t){e.refreshDashboard()}})}computeWidth(t){t.each(function(){var t=$(this).parent().parent().width();var e=$(this).parent().parent().height();if(t>e){var a=.35;var i=e/a;var r=i/t*100;var s=r/2;$(this).css("width",s+"%")}})}resetComputedWidth(t){t.each(function(){$(this).css("width","100%")})}fitNumbers(t){t=t||$("body");var e=1.16;if(this.dash_width<=700||$(this.grid.el).hasClass("grid-stack-one-column-mode")){e=1.8}this.computeWidth(t.find(".big-number").find(".formatted-number"));this.computeWidth(t.find(".big-number").find(".label"));t.find(".big-number").find(".formatted-number").fitText(e);t.find(".summary-numbers").find(".formatted-number").fitText(e-.65);t.find(".summary-numbers").find(".line .label").fitText(e-.2);t.find(".big-number").find(".label").fitText(e-.2,{minFontSize:"12px"});this.resetComputedWidth(t.find(".big-number").find(".formatted-number"));this.resetComputedWidth(t.find(".big-number").find(".label"))}animateNumbers(t){t=t||$("body");t.find(".multiple-numbers, .summary-numbers, .big-number").find(".formatted-number").each(function(){var t=$(this);var e=t.data("precision");var a=t.children(".number");var i=a.text();if(isNaN(a.text())){return true}jQuery({Counter:0}).animate({Counter:a.text()},{duration:800,easing:"swing",step:function(){a.text(this.Counter.toFixed(e))},complete:function(){a.text(i)}})})}setEditMode(t){this.edit_mode=typeof t=="undefined"?true:t;var e=$(this.elem_id+" .toolbar .edit-dashboard");e.toggleClass("active",t);this.element.toggleClass("edit-mode",t);this.grid.setStatic(!t);if($(this.filters_selector).children().length>0){sortable(this.filters_selector,t?"enable":"disable")}if(!this.edit_mode){var a=$(".grid-stack-item.dirty");if(a.length>0){this.saveDashboard(true)}}}toggleFullscreenMode(t){var e=!t.hasClass("active");this.element.toggleClass("fullscreen").find(".night-mode").toggle(e);t.toggleClass("active");if(e){this.setEditMode(false)}if(e){GoInFullscreen(this.elem_dom)}else{GoOutFullscreen()}}disableFullscreenMode(){this.element.removeClass("fullscreen").find(".night-mode").hide().end().find(".toggle-fullscreen").removeClass("active");GoOutFullscreen()}clone(){const t=this;$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{dashboard:this.current_name,action:"clone_dashboard"},dataType:"json"}).done(function(e){t.addNewDashbardInSelect(e.title,e.key)})}delete(){const t=this;var e=__("Are you sure you want to delete the dashboard %s ?").replace("%s",this.current_name);if(window.confirm(e,__("Delete this dashboard"))){$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"delete_dashboard",dashboard:this.current_name}}).done(function(){$("#dashboard-"+t.rand+" .toolbar .dashboard_select").find("option[value='"+t.current_name+"']").remove().end().prop("selectedIndex",0).trigger("change")})}}addForm(){glpi_ajax_dialog({title:__("Add a new dashboard"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"add_new"}})}addNew(t){const e=this;$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_new_dashboard",title:t.title,context:this.context}}).done(function(a){e.addNewDashbardInSelect(t.title,a);e.setEditMode(true)})}addNewDashbardInSelect(t,e){var a=new Option(t,e,false,true);$("#dashboard-"+this.rand+" .toolbar .dashboard_select").append(a).trigger("change")}getCardsAjax(t){const e=this;t=t||"";const a=this.getFiltersFromDB();const i=t.length>0?1:0;let r=[];let s=[];$(this.elem_dom).find(".grid-stack-item:not(.lock-bottom)"+t).each(function(){var t=$(this);var d=t.data("card-options");var n=t.attr("gs-id");var o=d.card_id||t.attr("gs-id");d.gridstack_id=n;if("markdown_content"in d){e.markdown_contents[n]=d.markdown_content}d.apply_filters=a;s.push({card_id:o,force:i,args:d,c_cache_key:d.cache_key||""});r.push({card_el:t,card_id:o,args:d})});if(this.ajax_cards){const t=[];r.forEach(function(a){const r=a.card_el;let s={action:"get_card",dashboard:e.current_name,card_id:a.card_id,force:i,args:a.args,d_cache_key:e.cache_key,c_cache_key:a.args.cache_key||""};if(e.embed){s.embed=1;s.token=e.token;s.entities_id=e.entities_id;s.is_recursive=e.is_recursive}t.push($.get(CFG_GLPI.root_doc+"/ajax/dashboard.php",s).then(function(t){r.children(".grid-stack-item-content").html(t);e.fitNumbers(r);e.animateNumbers(r)}).fail(function(){r.html("<div class='empty-card card-error'><i class='fas fa-exclamation-triangle'></i></div>")}))});return t}else{let a={dashboard:this.current_name,force:t.length>0?1:0,d_cache_key:this.cache_key,cards:s};if(this.embed){a.embed=1;a.token=this.token;a.entities_id=this.entities_id;a.is_recursive=this.is_recursive}return $.ajax({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",method:"POST",data:{action:"get_cards",data:JSON.stringify(a)}}).then(function(t){$.each(r,(a,i)=>{let r=false;const s=i.card_el;$.each(t,(t,a)=>{if(i.card_id===t){const t=a;r=true;s.children(".grid-stack-item-content").html(t);e.fitNumbers(s);e.animateNumbers(s)}});if(!r){s.html("<div class='empty-card card-error'><i class='fas fa-exclamation-triangle'></i></div>")}})}).fail(function(){$.each(r,(t,e)=>{const a=e.card_el;a.html("<div class='empty-card card-error'><i class='fas fa-exclamation-triangle'></i></div>")})})}}easter(){var t=$(this.elem_id+" .grid-stack .grid-stack-item .card");setInterval(function(){var e="#"+((1<<24)*Math.random()|0).toString(16);var a=Math.floor(Math.random()*t.length)+1;var i=t[a];$(i).css("background-color",e)},10)}generateCss(){var t=Math.floor(this.element.width());var e=(t-1)/this.cols;var a=e;var i=t/this.cols;var r=100/this.cols;var s="       "+this.elem_id+" .cell-add {          width: "+e+"px;          height: "+i+"px;       }       "+this.elem_id+" .grid-guide {          background-size: "+e+"px "+i+"px;          bottom: "+i+"px;       }";for(var d=0;d<this.cols;d++){var n=d*r;var o=(d+1)*r;s+=this.elem_id+" .grid-stack > .grid-stack-item[gs-x='"+d+"'] {             left: "+n+"%;          }          "+this.elem_id+" .grid-stack > .grid-stack-item[gs-w='"+(d+1)+"'] {             min-width: "+r+"%;             width: "+o+"%;          }"}$("#gs_inline_css_"+this.rand).remove();if(t>700){$("<style id='gs_inline_css_"+this.rand+"'></style>").prop("type","text/css").html(s).appendTo("head")}else{a=60}this.grid.cellHeight(a)}initFilters(){const t=this;if($(this.filters_selector).length===0){return}var e=this.getFiltersFromDB();$.each(e,function(t,a){if(Array.isArray(a)&&a.length==0){e[t]=""}});$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"get_dashboard_filters",filters:e}}).done(function(e){$(t.filters_selector).html(e);$(document).trigger("glpiDasbhoardInitFilter");sortable(t.filters_selector,{placeholderClass:"filter-placeholder",orientation:"horizontal"})[0].addEventListener("sortupdate",function(e){var a=$(e.detail.destination.items).filter(t.filters_selector);var i=t.getFiltersFromDB();var r={};$.each(a,function(){var t=$(this).data("filter-id");r[t]=i[t]});t.setFiltersInDB(r)});sortable(t.filters_selector,"disable")})}getFiltersFromDB(){var t;$.ajax({method:"GET",url:CFG_GLPI.root_doc+"/ajax/dashboard.php",async:false,data:{action:"get_filter_data",dashboard:this.current_name}}).done(function(e){try{t=JSON.parse(e)}catch(e){t=JSON.parse("{}")}});return t||{}}setFiltersInDB(t){var e=[];if(this.current_name.length>0){e[this.current_name]=t}$.ajax({method:"POST",url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_filter_data",dashboard:this.current_name,filters:JSON.stringify(e[this.current_name],function(t,e){return e===undefined?null:e})}})}resizeSelect(){const t=document.querySelector(this.elem_id+" .dashboard_select");if(t===null){return}t.addEventListener("change",t=>{let e=document.createElement("select"),a=document.createElement("option");a.textContent=t.target.options[t.target.selectedIndex].text;e.style.cssText+=`\n              visibility: hidden;\n              position: fixed;\n           `;e.appendChild(a);t.target.after(e);const i=e.getBoundingClientRect().width;t.target.style.width=`${i}px`;e.remove()});t.dispatchEvent(new Event("change"))}}