# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Any, List, Union, Iterable, Optional, cast
from typing_extensions import overload

import httpx

from .tasks import (
    TasksResource,
    AsyncTasksResource,
    TasksResourceWithRawResponse,
    AsyncTasksResourceWithRawResponse,
    TasksResourceWithStreamingResponse,
    AsyncTasksResourceWithStreamingResponse,
)
from .authors import (
    AuthorsResource,
    AsyncAuthorsResource,
    AuthorsResourceWithRawResponse,
    AsyncAuthorsResourceWithRawResponse,
    AuthorsResourceWithStreamingResponse,
    AsyncAuthorsResourceWithStreamingResponse,
)
from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._utils import required_args, maybe_transform, async_maybe_transform
from ..._compat import cached_property
from ...types.ai import ai_run_params
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._wrappers import ResultWrapper
from .models.models import (
    ModelsResource,
    AsyncModelsResource,
    ModelsResourceWithRawResponse,
    AsyncModelsResourceWithRawResponse,
    ModelsResourceWithStreamingResponse,
    AsyncModelsResourceWithStreamingResponse,
)
from ..._base_client import make_request_options
from .finetunes.finetunes import (
    FinetunesResource,
    AsyncFinetunesResource,
    FinetunesResourceWithRawResponse,
    AsyncFinetunesResourceWithRawResponse,
    FinetunesResourceWithStreamingResponse,
    AsyncFinetunesResourceWithStreamingResponse,
)
from ...types.ai.ai_run_response import AIRunResponse

__all__ = ["AIResource", "AsyncAIResource"]


class AIResource(SyncAPIResource):
    @cached_property
    def finetunes(self) -> FinetunesResource:
        return FinetunesResource(self._client)

    @cached_property
    def authors(self) -> AuthorsResource:
        return AuthorsResource(self._client)

    @cached_property
    def tasks(self) -> TasksResource:
        return TasksResource(self._client)

    @cached_property
    def models(self) -> ModelsResource:
        return ModelsResource(self._client)

    @cached_property
    def with_raw_response(self) -> AIResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#accessing-raw-response-data-eg-headers
        """
        return AIResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AIResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#with_streaming_response
        """
        return AIResourceWithStreamingResponse(self)

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        text: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          text: The text that you want to classify

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        prompt: str,
        guidance: float | NotGiven = NOT_GIVEN,
        height: int | NotGiven = NOT_GIVEN,
        image: Iterable[float] | NotGiven = NOT_GIVEN,
        image_b64: str | NotGiven = NOT_GIVEN,
        mask: Iterable[float] | NotGiven = NOT_GIVEN,
        negative_prompt: str | NotGiven = NOT_GIVEN,
        num_steps: int | NotGiven = NOT_GIVEN,
        seed: int | NotGiven = NOT_GIVEN,
        strength: float | NotGiven = NOT_GIVEN,
        width: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          prompt: A text description of the image you want to generate

          guidance: Controls how closely the generated image should adhere to the prompt; higher
              values make the image more aligned with the prompt

          height: The height of the generated image in pixels

          image: For use with img2img tasks. An array of integers that represent the image data
              constrained to 8-bit unsigned integer values

          image_b64: For use with img2img tasks. A base64-encoded string of the input image

          mask: An array representing An array of integers that represent mask image data for
              inpainting constrained to 8-bit unsigned integer values

          negative_prompt: Text describing elements to avoid in the generated image

          num_steps: The number of diffusion steps; higher values can improve quality but take longer

          seed: Random seed for reproducibility of the image generation

          strength: A value between 0 and 1 indicating how strongly to apply the transformation
              during img2img tasks; lower values make the output closer to the input image

          width: The width of the generated image in pixels

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        prompt: str,
        lang: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          prompt: A text description of the audio you want to generate

          lang: The speech language (e.g., 'en' for English, 'fr' for French). Defaults to 'en'
              if not specified

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        text: Union[str, List[str]],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          text: The text to embed

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        audio: Iterable[float],
        source_lang: str | NotGiven = NOT_GIVEN,
        target_lang: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          audio: An array of integers that represent the audio data constrained to 8-bit unsigned
              integer values

          source_lang: The language of the recorded audio

          target_lang: The language to translate the transcription into. Currently only English is
              supported.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: Iterable[float],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: An array of integers that represent the image data constrained to 8-bit unsigned
              integer values

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: Iterable[float] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: An array of integers that represent the image data constrained to 8-bit unsigned
              integer values

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        prompt: str,
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        lora: str | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        response_format: ai_run_params.PromptResponseFormat | NotGiven = NOT_GIVEN,
        seed: int | NotGiven = NOT_GIVEN,
        stream: bool | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: int | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          prompt: The input text prompt for the model to generate a response.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          lora: Name of the LoRA (Low-Rank Adaptation) model to fine-tune the base model.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          raw: If true, a chat template is not applied and you must adhere to the specific
              model's expected formatting.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          stream: If true, the response will be streamed back incrementally using SSE, Server Sent
              Events.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Adjusts the creativity of the AI's responses by controlling how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        messages: Iterable[ai_run_params.MessagesMessage],
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        functions: Iterable[ai_run_params.MessagesFunction] | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        response_format: ai_run_params.MessagesResponseFormat | NotGiven = NOT_GIVEN,
        seed: int | NotGiven = NOT_GIVEN,
        stream: bool | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        tools: Iterable[ai_run_params.MessagesTool] | NotGiven = NOT_GIVEN,
        top_k: int | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          messages: An array of message objects representing the conversation history.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          raw: If true, a chat template is not applied and you must adhere to the specific
              model's expected formatting.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          stream: If true, the response will be streamed back incrementally using SSE, Server Sent
              Events.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          tools: A list of tools available for the assistant to use.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Adjusts the creativity of the AI's responses by controlling how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        target_lang: str,
        text: str,
        source_lang: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          target_lang: The language code to translate the text into (e.g., 'es' for Spanish)

          text: The text to be translated

          source_lang: The language code of the source text (e.g., 'en' for English). Defaults to 'en'
              if not specified

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        input_text: str,
        max_length: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          input_text: The text that you want the model to summarize

          max_length: The maximum length of the generated summary in tokens

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: Iterable[float],
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        prompt: str | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        seed: float | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: An array of integers that represent the image data constrained to 8-bit unsigned
              integer values

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          prompt: The input text prompt for the model to generate a response.

          raw: If true, a chat template is not applied and you must adhere to the specific
              model's expected formatting.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Controls the creativity of the AI's responses by adjusting how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: str,
        prompt: str,
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        ignore_eos: bool | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        seed: float | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: Image in base64 encoded format.

          prompt: The input text prompt for the model to generate a response.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          ignore_eos: Whether to ignore the EOS token and continue generating tokens after the EOS
              token is generated.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Controls the creativity of the AI's responses by adjusting how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: str,
        messages: Iterable[ai_run_params.Variant13Message],
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        ignore_eos: bool | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        seed: float | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: Image in base64 encoded format.

          messages: An array of message objects representing the conversation history.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          ignore_eos: Whether to ignore the EOS token and continue generating tokens after the EOS
              token is generated.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Controls the creativity of the AI's responses by adjusting how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @required_args(
        ["account_id", "text"],
        ["account_id", "prompt"],
        ["account_id", "audio"],
        ["account_id", "image"],
        ["account_id"],
        ["account_id", "messages"],
        ["account_id", "target_lang", "text"],
        ["account_id", "input_text"],
        ["account_id", "image", "prompt"],
        ["account_id", "image", "messages"],
    )
    def run(
        self,
        model_name: str,
        *,
        account_id: str,
        text: str | Union[str, List[str]] | NotGiven = NOT_GIVEN,
        prompt: str | NotGiven = NOT_GIVEN,
        guidance: float | NotGiven = NOT_GIVEN,
        height: int | NotGiven = NOT_GIVEN,
        image: Iterable[float] | str | NotGiven = NOT_GIVEN,
        image_b64: str | NotGiven = NOT_GIVEN,
        mask: Iterable[float] | NotGiven = NOT_GIVEN,
        negative_prompt: str | NotGiven = NOT_GIVEN,
        num_steps: int | NotGiven = NOT_GIVEN,
        seed: int | float | NotGiven = NOT_GIVEN,
        strength: float | NotGiven = NOT_GIVEN,
        width: int | NotGiven = NOT_GIVEN,
        lang: str | NotGiven = NOT_GIVEN,
        audio: Iterable[float] | NotGiven = NOT_GIVEN,
        source_lang: str | NotGiven = NOT_GIVEN,
        target_lang: str | NotGiven = NOT_GIVEN,
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        lora: str | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        response_format: ai_run_params.PromptResponseFormat | NotGiven = NOT_GIVEN,
        stream: bool | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: int | float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        messages: Iterable[ai_run_params.MessagesMessage] | NotGiven = NOT_GIVEN,
        functions: Iterable[ai_run_params.MessagesFunction] | NotGiven = NOT_GIVEN,
        tools: Iterable[ai_run_params.MessagesTool] | NotGiven = NOT_GIVEN,
        input_text: str | NotGiven = NOT_GIVEN,
        max_length: int | NotGiven = NOT_GIVEN,
        ignore_eos: bool | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        if not account_id:
            raise ValueError(f"Expected a non-empty value for `account_id` but received {account_id!r}")
        if not model_name:
            raise ValueError(f"Expected a non-empty value for `model_name` but received {model_name!r}")
        return cast(
            Optional[AIRunResponse],
            self._post(
                f"/accounts/{account_id}/ai/run/{model_name}",
                body=maybe_transform(
                    {
                        "text": text,
                        "prompt": prompt,
                        "guidance": guidance,
                        "height": height,
                        "image": image,
                        "image_b64": image_b64,
                        "mask": mask,
                        "negative_prompt": negative_prompt,
                        "num_steps": num_steps,
                        "seed": seed,
                        "strength": strength,
                        "width": width,
                        "lang": lang,
                        "audio": audio,
                        "source_lang": source_lang,
                        "target_lang": target_lang,
                        "frequency_penalty": frequency_penalty,
                        "lora": lora,
                        "max_tokens": max_tokens,
                        "presence_penalty": presence_penalty,
                        "raw": raw,
                        "repetition_penalty": repetition_penalty,
                        "response_format": response_format,
                        "stream": stream,
                        "temperature": temperature,
                        "top_k": top_k,
                        "top_p": top_p,
                        "messages": messages,
                        "functions": functions,
                        "tools": tools,
                        "input_text": input_text,
                        "max_length": max_length,
                        "ignore_eos": ignore_eos,
                    },
                    ai_run_params.AIRunParams,
                ),
                options=make_request_options(
                    extra_headers=extra_headers,
                    extra_query=extra_query,
                    extra_body=extra_body,
                    timeout=timeout,
                    post_parser=ResultWrapper[Optional[AIRunResponse]]._unwrapper,
                ),
                cast_to=cast(
                    Any, ResultWrapper[AIRunResponse]
                ),  # Union types cannot be passed in as arguments in the type system
            ),
        )


class AsyncAIResource(AsyncAPIResource):
    @cached_property
    def finetunes(self) -> AsyncFinetunesResource:
        return AsyncFinetunesResource(self._client)

    @cached_property
    def authors(self) -> AsyncAuthorsResource:
        return AsyncAuthorsResource(self._client)

    @cached_property
    def tasks(self) -> AsyncTasksResource:
        return AsyncTasksResource(self._client)

    @cached_property
    def models(self) -> AsyncModelsResource:
        return AsyncModelsResource(self._client)

    @cached_property
    def with_raw_response(self) -> AsyncAIResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#accessing-raw-response-data-eg-headers
        """
        return AsyncAIResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncAIResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#with_streaming_response
        """
        return AsyncAIResourceWithStreamingResponse(self)

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        text: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          text: The text that you want to classify

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        prompt: str,
        guidance: float | NotGiven = NOT_GIVEN,
        height: int | NotGiven = NOT_GIVEN,
        image: Iterable[float] | NotGiven = NOT_GIVEN,
        image_b64: str | NotGiven = NOT_GIVEN,
        mask: Iterable[float] | NotGiven = NOT_GIVEN,
        negative_prompt: str | NotGiven = NOT_GIVEN,
        num_steps: int | NotGiven = NOT_GIVEN,
        seed: int | NotGiven = NOT_GIVEN,
        strength: float | NotGiven = NOT_GIVEN,
        width: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          prompt: A text description of the image you want to generate

          guidance: Controls how closely the generated image should adhere to the prompt; higher
              values make the image more aligned with the prompt

          height: The height of the generated image in pixels

          image: For use with img2img tasks. An array of integers that represent the image data
              constrained to 8-bit unsigned integer values

          image_b64: For use with img2img tasks. A base64-encoded string of the input image

          mask: An array representing An array of integers that represent mask image data for
              inpainting constrained to 8-bit unsigned integer values

          negative_prompt: Text describing elements to avoid in the generated image

          num_steps: The number of diffusion steps; higher values can improve quality but take longer

          seed: Random seed for reproducibility of the image generation

          strength: A value between 0 and 1 indicating how strongly to apply the transformation
              during img2img tasks; lower values make the output closer to the input image

          width: The width of the generated image in pixels

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        prompt: str,
        lang: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          prompt: A text description of the audio you want to generate

          lang: The speech language (e.g., 'en' for English, 'fr' for French). Defaults to 'en'
              if not specified

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        text: Union[str, List[str]],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          text: The text to embed

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        audio: Iterable[float],
        source_lang: str | NotGiven = NOT_GIVEN,
        target_lang: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          audio: An array of integers that represent the audio data constrained to 8-bit unsigned
              integer values

          source_lang: The language of the recorded audio

          target_lang: The language to translate the transcription into. Currently only English is
              supported.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: Iterable[float],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: An array of integers that represent the image data constrained to 8-bit unsigned
              integer values

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: Iterable[float] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: An array of integers that represent the image data constrained to 8-bit unsigned
              integer values

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        prompt: str,
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        lora: str | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        response_format: ai_run_params.PromptResponseFormat | NotGiven = NOT_GIVEN,
        seed: int | NotGiven = NOT_GIVEN,
        stream: bool | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: int | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          prompt: The input text prompt for the model to generate a response.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          lora: Name of the LoRA (Low-Rank Adaptation) model to fine-tune the base model.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          raw: If true, a chat template is not applied and you must adhere to the specific
              model's expected formatting.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          stream: If true, the response will be streamed back incrementally using SSE, Server Sent
              Events.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Adjusts the creativity of the AI's responses by controlling how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        messages: Iterable[ai_run_params.MessagesMessage],
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        functions: Iterable[ai_run_params.MessagesFunction] | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        response_format: ai_run_params.MessagesResponseFormat | NotGiven = NOT_GIVEN,
        seed: int | NotGiven = NOT_GIVEN,
        stream: bool | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        tools: Iterable[ai_run_params.MessagesTool] | NotGiven = NOT_GIVEN,
        top_k: int | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          messages: An array of message objects representing the conversation history.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          raw: If true, a chat template is not applied and you must adhere to the specific
              model's expected formatting.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          stream: If true, the response will be streamed back incrementally using SSE, Server Sent
              Events.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          tools: A list of tools available for the assistant to use.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Adjusts the creativity of the AI's responses by controlling how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        target_lang: str,
        text: str,
        source_lang: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          target_lang: The language code to translate the text into (e.g., 'es' for Spanish)

          text: The text to be translated

          source_lang: The language code of the source text (e.g., 'en' for English). Defaults to 'en'
              if not specified

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        input_text: str,
        max_length: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          input_text: The text that you want the model to summarize

          max_length: The maximum length of the generated summary in tokens

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: Iterable[float],
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        prompt: str | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        seed: float | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: An array of integers that represent the image data constrained to 8-bit unsigned
              integer values

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          prompt: The input text prompt for the model to generate a response.

          raw: If true, a chat template is not applied and you must adhere to the specific
              model's expected formatting.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Controls the creativity of the AI's responses by adjusting how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: str,
        prompt: str,
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        ignore_eos: bool | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        seed: float | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: Image in base64 encoded format.

          prompt: The input text prompt for the model to generate a response.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          ignore_eos: Whether to ignore the EOS token and continue generating tokens after the EOS
              token is generated.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Controls the creativity of the AI's responses by adjusting how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @overload
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        image: str,
        messages: Iterable[ai_run_params.Variant13Message],
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        ignore_eos: bool | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        seed: float | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        """
        This endpoint provides users with the capability to run specific AI models
        on-demand.

        By submitting the required input data, users can receive real-time predictions
        or results generated by the chosen AI model. The endpoint supports various AI
        model types, ensuring flexibility and adaptability for diverse use cases.

        Model specific inputs available in
        [Cloudflare Docs](https://developers.cloudflare.com/workers-ai/models/).

        Args:
          image: Image in base64 encoded format.

          messages: An array of message objects representing the conversation history.

          frequency_penalty: Decreases the likelihood of the model repeating the same lines verbatim.

          ignore_eos: Whether to ignore the EOS token and continue generating tokens after the EOS
              token is generated.

          max_tokens: The maximum number of tokens to generate in the response.

          presence_penalty: Increases the likelihood of the model introducing new topics.

          repetition_penalty: Penalty for repeated tokens; higher values discourage repetition.

          seed: Random seed for reproducibility of the generation.

          temperature: Controls the randomness of the output; higher values produce more random
              results.

          top_k: Limits the AI to choose from the top 'k' most probable words. Lower values make
              responses more focused; higher values introduce more variety and potential
              surprises.

          top_p: Controls the creativity of the AI's responses by adjusting how many possible
              words it considers. Lower values make outputs more predictable; higher values
              allow for more varied and creative responses.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        ...

    @required_args(
        ["account_id", "text"],
        ["account_id", "prompt"],
        ["account_id", "audio"],
        ["account_id", "image"],
        ["account_id"],
        ["account_id", "messages"],
        ["account_id", "target_lang", "text"],
        ["account_id", "input_text"],
        ["account_id", "image", "prompt"],
        ["account_id", "image", "messages"],
    )
    async def run(
        self,
        model_name: str,
        *,
        account_id: str,
        text: str | Union[str, List[str]] | NotGiven = NOT_GIVEN,
        prompt: str | NotGiven = NOT_GIVEN,
        guidance: float | NotGiven = NOT_GIVEN,
        height: int | NotGiven = NOT_GIVEN,
        image: Iterable[float] | str | NotGiven = NOT_GIVEN,
        image_b64: str | NotGiven = NOT_GIVEN,
        mask: Iterable[float] | NotGiven = NOT_GIVEN,
        negative_prompt: str | NotGiven = NOT_GIVEN,
        num_steps: int | NotGiven = NOT_GIVEN,
        seed: int | float | NotGiven = NOT_GIVEN,
        strength: float | NotGiven = NOT_GIVEN,
        width: int | NotGiven = NOT_GIVEN,
        lang: str | NotGiven = NOT_GIVEN,
        audio: Iterable[float] | NotGiven = NOT_GIVEN,
        source_lang: str | NotGiven = NOT_GIVEN,
        target_lang: str | NotGiven = NOT_GIVEN,
        frequency_penalty: float | NotGiven = NOT_GIVEN,
        lora: str | NotGiven = NOT_GIVEN,
        max_tokens: int | NotGiven = NOT_GIVEN,
        presence_penalty: float | NotGiven = NOT_GIVEN,
        raw: bool | NotGiven = NOT_GIVEN,
        repetition_penalty: float | NotGiven = NOT_GIVEN,
        response_format: ai_run_params.PromptResponseFormat | NotGiven = NOT_GIVEN,
        stream: bool | NotGiven = NOT_GIVEN,
        temperature: float | NotGiven = NOT_GIVEN,
        top_k: int | float | NotGiven = NOT_GIVEN,
        top_p: float | NotGiven = NOT_GIVEN,
        messages: Iterable[ai_run_params.MessagesMessage] | NotGiven = NOT_GIVEN,
        functions: Iterable[ai_run_params.MessagesFunction] | NotGiven = NOT_GIVEN,
        tools: Iterable[ai_run_params.MessagesTool] | NotGiven = NOT_GIVEN,
        input_text: str | NotGiven = NOT_GIVEN,
        max_length: int | NotGiven = NOT_GIVEN,
        ignore_eos: bool | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[AIRunResponse]:
        if not account_id:
            raise ValueError(f"Expected a non-empty value for `account_id` but received {account_id!r}")
        if not model_name:
            raise ValueError(f"Expected a non-empty value for `model_name` but received {model_name!r}")
        return cast(
            Optional[AIRunResponse],
            await self._post(
                f"/accounts/{account_id}/ai/run/{model_name}",
                body=await async_maybe_transform(
                    {
                        "text": text,
                        "prompt": prompt,
                        "guidance": guidance,
                        "height": height,
                        "image": image,
                        "image_b64": image_b64,
                        "mask": mask,
                        "negative_prompt": negative_prompt,
                        "num_steps": num_steps,
                        "seed": seed,
                        "strength": strength,
                        "width": width,
                        "lang": lang,
                        "audio": audio,
                        "source_lang": source_lang,
                        "target_lang": target_lang,
                        "frequency_penalty": frequency_penalty,
                        "lora": lora,
                        "max_tokens": max_tokens,
                        "presence_penalty": presence_penalty,
                        "raw": raw,
                        "repetition_penalty": repetition_penalty,
                        "response_format": response_format,
                        "stream": stream,
                        "temperature": temperature,
                        "top_k": top_k,
                        "top_p": top_p,
                        "messages": messages,
                        "functions": functions,
                        "tools": tools,
                        "input_text": input_text,
                        "max_length": max_length,
                        "ignore_eos": ignore_eos,
                    },
                    ai_run_params.AIRunParams,
                ),
                options=make_request_options(
                    extra_headers=extra_headers,
                    extra_query=extra_query,
                    extra_body=extra_body,
                    timeout=timeout,
                    post_parser=ResultWrapper[Optional[AIRunResponse]]._unwrapper,
                ),
                cast_to=cast(
                    Any, ResultWrapper[AIRunResponse]
                ),  # Union types cannot be passed in as arguments in the type system
            ),
        )


class AIResourceWithRawResponse:
    def __init__(self, ai: AIResource) -> None:
        self._ai = ai

        self.run = to_raw_response_wrapper(
            ai.run,
        )

    @cached_property
    def finetunes(self) -> FinetunesResourceWithRawResponse:
        return FinetunesResourceWithRawResponse(self._ai.finetunes)

    @cached_property
    def authors(self) -> AuthorsResourceWithRawResponse:
        return AuthorsResourceWithRawResponse(self._ai.authors)

    @cached_property
    def tasks(self) -> TasksResourceWithRawResponse:
        return TasksResourceWithRawResponse(self._ai.tasks)

    @cached_property
    def models(self) -> ModelsResourceWithRawResponse:
        return ModelsResourceWithRawResponse(self._ai.models)


class AsyncAIResourceWithRawResponse:
    def __init__(self, ai: AsyncAIResource) -> None:
        self._ai = ai

        self.run = async_to_raw_response_wrapper(
            ai.run,
        )

    @cached_property
    def finetunes(self) -> AsyncFinetunesResourceWithRawResponse:
        return AsyncFinetunesResourceWithRawResponse(self._ai.finetunes)

    @cached_property
    def authors(self) -> AsyncAuthorsResourceWithRawResponse:
        return AsyncAuthorsResourceWithRawResponse(self._ai.authors)

    @cached_property
    def tasks(self) -> AsyncTasksResourceWithRawResponse:
        return AsyncTasksResourceWithRawResponse(self._ai.tasks)

    @cached_property
    def models(self) -> AsyncModelsResourceWithRawResponse:
        return AsyncModelsResourceWithRawResponse(self._ai.models)


class AIResourceWithStreamingResponse:
    def __init__(self, ai: AIResource) -> None:
        self._ai = ai

        self.run = to_streamed_response_wrapper(
            ai.run,
        )

    @cached_property
    def finetunes(self) -> FinetunesResourceWithStreamingResponse:
        return FinetunesResourceWithStreamingResponse(self._ai.finetunes)

    @cached_property
    def authors(self) -> AuthorsResourceWithStreamingResponse:
        return AuthorsResourceWithStreamingResponse(self._ai.authors)

    @cached_property
    def tasks(self) -> TasksResourceWithStreamingResponse:
        return TasksResourceWithStreamingResponse(self._ai.tasks)

    @cached_property
    def models(self) -> ModelsResourceWithStreamingResponse:
        return ModelsResourceWithStreamingResponse(self._ai.models)


class AsyncAIResourceWithStreamingResponse:
    def __init__(self, ai: AsyncAIResource) -> None:
        self._ai = ai

        self.run = async_to_streamed_response_wrapper(
            ai.run,
        )

    @cached_property
    def finetunes(self) -> AsyncFinetunesResourceWithStreamingResponse:
        return AsyncFinetunesResourceWithStreamingResponse(self._ai.finetunes)

    @cached_property
    def authors(self) -> AsyncAuthorsResourceWithStreamingResponse:
        return AsyncAuthorsResourceWithStreamingResponse(self._ai.authors)

    @cached_property
    def tasks(self) -> AsyncTasksResourceWithStreamingResponse:
        return AsyncTasksResourceWithStreamingResponse(self._ai.tasks)

    @cached_property
    def models(self) -> AsyncModelsResourceWithStreamingResponse:
        return AsyncModelsResourceWithStreamingResponse(self._ai.models)
