"""
Standard tag definitions.
"""

from exifread.tags import IfdTagDict, SubIfdInfoTuple, SubIfdTagDict
from exifread.tags.str_utils import make_string, make_string_uc

# Interoperability tags
INTEROP_TAGS: SubIfdTagDict = {
    0x0001: ("InteroperabilityIndex", None),
    0x0002: ("InteroperabilityVersion", None),
    0x1000: ("RelatedImageFileFormat", None),
    0x1001: ("RelatedImageWidth", None),
    0x1002: ("RelatedImageLength", None),
}
INTEROP_INFO: SubIfdInfoTuple = ("Interoperability", INTEROP_TAGS)

# GPS tags
GPS_TAGS: SubIfdTagDict = {
    0x0000: ("GPSVersionID", None),
    0x0001: ("GPSLatitudeRef", None),
    0x0002: ("GPSLatitude", None),
    0x0003: ("GPSLongitudeRef", None),
    0x0004: ("GPSLongitude", None),
    0x0005: ("GPSAltitudeRef", None),
    0x0006: ("GPSAltitude", None),
    0x0007: ("GPSTimeStamp", None),
    0x0008: ("GPSSatellites", None),
    0x0009: ("GPSStatus", None),
    0x000A: ("GPSMeasureMode", None),
    0x000B: ("GPSDOP", None),
    0x000C: ("GPSSpeedRef", None),
    0x000D: ("GPSSpeed", None),
    0x000E: ("GPSTrackRef", None),
    0x000F: ("GPSTrack", None),
    0x0010: ("GPSImgDirectionRef", None),
    0x0011: ("GPSImgDirection", None),
    0x0012: ("GPSMapDatum", None),
    0x0013: ("GPSDestLatitudeRef", None),
    0x0014: ("GPSDestLatitude", None),
    0x0015: ("GPSDestLongitudeRef", None),
    0x0016: ("GPSDestLongitude", None),
    0x0017: ("GPSDestBearingRef", None),
    0x0018: ("GPSDestBearing", None),
    0x0019: ("GPSDestDistanceRef", None),
    0x001A: ("GPSDestDistance", None),
    0x001B: ("GPSProcessingMethod", None),
    0x001C: ("GPSAreaInformation", None),
    0x001D: ("GPSDate", None),
    0x001E: ("GPSDifferential", None),
}
GPS_INFO: SubIfdInfoTuple = ("GPS", GPS_TAGS)

# Main Exif tag names
EXIF_TAGS: IfdTagDict = {
    0x00FE: (
        "SubfileType",
        {
            0x0: "Full-resolution Image",
            0x1: "Reduced-resolution image",
            0x2: "Single page of multi-page image",
            0x3: "Single page of multi-page reduced-resolution image",
            0x4: "Transparency mask",
            0x5: "Transparency mask of reduced-resolution image",
            0x6: "Transparency mask of multi-page image",
            0x7: "Transparency mask of reduced-resolution multi-page image",
            0x10001: "Alternate reduced-resolution image",
            0xFFFFFFFF: "invalid ",
        },
    ),
    0x00FF: (
        "OldSubfileType",
        {
            1: "Full-resolution image",
            2: "Reduced-resolution image",
            3: "Single page of multi-page image",
        },
    ),
    0x0100: ("ImageWidth", None),
    0x0101: ("ImageLength", None),
    0x0102: ("BitsPerSample", None),
    0x0103: (
        "Compression",
        {
            1: "Uncompressed",
            2: "CCITT 1D",
            3: "T4/Group 3 Fax",
            4: "T6/Group 4 Fax",
            5: "LZW",
            6: "JPEG (old-style)",
            7: "JPEG",
            8: "Adobe Deflate",
            9: "JBIG B&W",
            10: "JBIG Color",
            32766: "Next",
            32769: "Epson ERF Compressed",
            32771: "CCIRLEW",
            32773: "PackBits",
            32809: "Thunderscan",
            32895: "IT8CTPAD",
            32896: "IT8LW",
            32897: "IT8MP",
            32898: "IT8BL",
            32908: "PixarFilm",
            32909: "PixarLog",
            32946: "Deflate",
            32947: "DCS",
            34661: "JBIG",
            34676: "SGILog",
            34677: "SGILog24",
            34712: "JPEG 2000",
            34713: "Nikon NEF Compressed",
            65000: "Kodak DCR Compressed",
            65535: "Pentax PEF Compressed",
        },
    ),
    0x0106: ("PhotometricInterpretation", None),
    0x0107: ("Thresholding", None),
    0x0108: ("CellWidth", None),
    0x0109: ("CellLength", None),
    0x010A: ("FillOrder", None),
    0x010D: ("DocumentName", None),
    0x010E: ("ImageDescription", None),
    0x010F: ("Make", None),
    0x0110: ("Model", None),
    0x0111: ("StripOffsets", None),
    0x0112: (
        "Orientation",
        {
            1: "Horizontal (normal)",
            2: "Mirrored horizontal",
            3: "Rotated 180",
            4: "Mirrored vertical",
            5: "Mirrored horizontal then rotated 90 CCW",
            6: "Rotated 90 CW",
            7: "Mirrored horizontal then rotated 90 CW",
            8: "Rotated 90 CCW",
        },
    ),
    0x0115: ("SamplesPerPixel", None),
    0x0116: ("RowsPerStrip", None),
    0x0117: ("StripByteCounts", None),
    0x0118: ("MinSampleValue", None),
    0x0119: ("MaxSampleValue", None),
    0x011A: ("XResolution", None),
    0x011B: ("YResolution", None),
    0x011C: ("PlanarConfiguration", None),
    0x011D: ("PageName", make_string),
    0x011E: ("XPosition", None),
    0x011F: ("YPosition", None),
    0x0122: (
        "GrayResponseUnit",
        {
            1: "0.1",
            2: "0.001",
            3: "0.0001",
            4: "1e-05",
            5: "1e-06",
        },
    ),
    0x0123: ("GrayResponseCurve", None),
    0x0124: ("T4Options", None),
    0x0125: ("T6Options", None),
    0x0128: (
        "ResolutionUnit",
        {1: "Not Absolute", 2: "Pixels/Inch", 3: "Pixels/Centimeter"},
    ),
    0x0129: ("PageNumber", None),
    0x012C: ("ColorResponseUnit", None),
    0x012D: ("TransferFunction", None),
    0x0131: ("Software", None),
    0x0132: ("DateTime", None),
    0x013B: ("Artist", None),
    0x013C: ("HostComputer", None),
    0x013D: ("Predictor", {1: "None", 2: "Horizontal differencing"}),
    0x013E: ("WhitePoint", None),
    0x013F: ("PrimaryChromaticities", None),
    0x0140: ("ColorMap", None),
    0x0141: ("HalftoneHints", None),
    0x0142: ("TileWidth", None),
    0x0143: ("TileLength", None),
    0x0144: ("TileOffsets", None),
    0x0145: ("TileByteCounts", None),
    0x0146: ("BadFaxLines", None),
    0x0147: ("CleanFaxData", {0: "Clean", 1: "Regenerated", 2: "Unclean"}),
    0x014A: ("SubIFDs", None),
    0x0148: ("ConsecutiveBadFaxLines", None),
    0x014C: ("InkSet", {1: "CMYK", 2: "Not CMYK"}),
    0x014D: ("InkNames", None),
    0x014E: ("NumberofInks", None),
    0x0150: ("DotRange", None),
    0x0151: ("TargetPrinter", None),
    0x0152: (
        "ExtraSamples",
        {0: "Unspecified", 1: "Associated Alpha", 2: "Unassociated Alpha"},
    ),
    0x0153: (
        "SampleFormat",
        {
            1: "Unsigned",
            2: "Signed",
            3: "Float",
            4: "Undefined",
            5: "Complex int",
            6: "Complex float",
        },
    ),
    0x0154: ("SMinSampleValue", None),
    0x0155: ("SMaxSampleValue", None),
    0x0156: ("TransferRange", None),
    0x0157: ("ClipPath", None),
    0x015B: ("JPEGTables", None),
    0x0200: ("JPEGProc", None),
    0x0201: ("JPEGInterchangeFormat", None),  # JpegIFOffset
    0x0202: ("JPEGInterchangeFormatLength", None),  # JpegIFByteCount
    0x0211: ("YCbCrCoefficients", None),
    0x0212: ("YCbCrSubSampling", None),
    0x0213: ("YCbCrPositioning", {1: "Centered", 2: "Co-sited"}),
    0x0214: ("ReferenceBlackWhite", None),
    0x02BC: ("ApplicationNotes", None),  # XPM Info
    0x4746: ("Rating", None),
    0x828D: ("CFARepeatPatternDim", None),
    0x828E: ("CFAPattern", None),
    0x828F: ("BatteryLevel", None),
    0x8298: ("Copyright", None),
    0x829A: ("ExposureTime", None),
    0x829D: ("FNumber", None),
    0x83BB: ("IPTC/NAA", None),
    0x8769: ("ExifOffset", None),  # Exif Tags
    0x8773: ("InterColorProfile", None),
    0x8822: (
        "ExposureProgram",
        {
            0: "Unidentified",
            1: "Manual",
            2: "Program Normal",
            3: "Aperture Priority",
            4: "Shutter Priority",
            5: "Program Creative",
            6: "Program Action",
            7: "Portrait Mode",
            8: "Landscape Mode",
        },
    ),
    0x8824: ("SpectralSensitivity", None),
    0x8825: ("GPSInfo", GPS_INFO),  # GPS tags
    0x8827: ("ISOSpeedRatings", None),
    0x8828: ("OECF", None),
    0x8829: ("Interlace", None),
    0x882A: ("TimeZoneOffset", None),
    0x882B: ("SelfTimerMode", None),
    0x8830: (
        "SensitivityType",
        {
            0: "Unknown",
            1: "Standard Output Sensitivity",
            2: "Recommended Exposure Index",
            3: "ISO Speed",
            4: "Standard Output Sensitivity and Recommended Exposure Index",
            5: "Standard Output Sensitivity and ISO Speed",
            6: "Recommended Exposure Index and ISO Speed",
            7: "Standard Output Sensitivity, Recommended Exposure Index and ISO Speed",
        },
    ),
    0x8832: ("RecommendedExposureIndex", None),
    0x8833: ("ISOSpeed", None),
    0x9000: ("ExifVersion", make_string),
    0x9003: ("DateTimeOriginal", None),
    0x9004: ("DateTimeDigitized", None),
    0x9010: ("OffsetTime", None),
    0x9011: ("OffsetTimeOriginal", None),
    0x9012: ("OffsetTimeDigitized", None),
    0x9101: (
        "ComponentsConfiguration",
        {0: "", 1: "Y", 2: "Cb", 3: "Cr", 4: "Red", 5: "Green", 6: "Blue"},
    ),
    0x9102: ("CompressedBitsPerPixel", None),
    0x9201: ("ShutterSpeedValue", None),
    0x9202: ("ApertureValue", None),
    0x9203: ("BrightnessValue", None),
    0x9204: ("ExposureBiasValue", None),
    0x9205: ("MaxApertureValue", None),
    0x9206: ("SubjectDistance", None),
    0x9207: (
        "MeteringMode",
        {
            0: "Unidentified",
            1: "Average",
            2: "CenterWeightedAverage",
            3: "Spot",
            4: "MultiSpot",
            5: "Pattern",
            6: "Partial",
            255: "other",
        },
    ),
    0x9208: (
        "LightSource",
        {
            0: "Unknown",
            1: "Daylight",
            2: "Fluorescent",
            3: "Tungsten (incandescent light)",
            4: "Flash",
            9: "Fine weather",
            10: "Cloudy weather",
            11: "Shade",
            12: "Daylight fluorescent (D 5700 - 7100K)",
            13: "Day white fluorescent (N 4600 - 5400K)",
            14: "Cool white fluorescent (W 3900 - 4500K)",
            15: "White fluorescent (WW 3200 - 3700K)",
            17: "Standard light A",
            18: "Standard light B",
            19: "Standard light C",
            20: "D55",
            21: "D65",
            22: "D75",
            23: "D50",
            24: "ISO studio tungsten",
            255: "other light source",
        },
    ),
    0x9209: (
        "Flash",
        {
            0: "Flash did not fire",
            1: "Flash fired",
            5: "Strobe return light not detected",
            7: "Strobe return light detected",
            9: "Flash fired, compulsory flash mode",
            13: "Flash fired, compulsory flash mode, return light not detected",
            15: "Flash fired, compulsory flash mode, return light detected",
            16: "Flash did not fire, compulsory flash mode",
            24: "Flash did not fire, auto mode",
            25: "Flash fired, auto mode",
            29: "Flash fired, auto mode, return light not detected",
            31: "Flash fired, auto mode, return light detected",
            32: "No flash function",
            65: "Flash fired, red-eye reduction mode",
            69: "Flash fired, red-eye reduction mode, return light not detected",
            71: "Flash fired, red-eye reduction mode, return light detected",
            73: "Flash fired, compulsory flash mode, red-eye reduction mode",
            77: "Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected",
            79: "Flash fired, compulsory flash mode, red-eye reduction mode, return light detected",
            89: "Flash fired, auto mode, red-eye reduction mode",
            93: "Flash fired, auto mode, return light not detected, red-eye reduction mode",
            95: "Flash fired, auto mode, return light detected, red-eye reduction mode",
        },
    ),
    0x920A: ("FocalLength", None),
    0x920B: ("FlashEnergy", None),
    0x920C: ("SpatialFrequencyResponse", None),
    0x920D: ("Noise", None),
    0x9211: ("ImageNumber", None),
    0x9212: ("SecurityClassification", None),
    0x9213: ("ImageHistory", None),
    0x9214: ("SubjectArea", None),
    0x9215: ("ExposureIndex", None),
    0x9216: ("TIFF/EPStandardID", None),
    0x927C: ("MakerNote", None),
    0x9286: ("UserComment", make_string_uc),
    0x9290: ("SubSecTime", None),
    0x9291: ("SubSecTimeOriginal", None),
    0x9292: ("SubSecTimeDigitized", None),
    # used by Windows Explorer
    0x9C9B: ("XPTitle", None),
    0x9C9C: ("XPComment", None),
    0x9C9D: ("XPAuthor", make_string),  # (ignored by Windows Explorer if Artist exists)
    0x9C9E: ("XPKeywords", None),
    0x9C9F: ("XPSubject", None),
    0xA000: ("FlashPixVersion", make_string),
    0xA001: ("ColorSpace", {1: "sRGB", 2: "Adobe RGB", 65535: "Uncalibrated"}),
    0xA002: ("ExifImageWidth", None),
    0xA003: ("ExifImageLength", None),
    0xA004: ("RelatedSoundFile", None),
    0xA005: ("InteroperabilityOffset", INTEROP_INFO),
    0xA20B: ("FlashEnergy", None),  # 0x920B in TIFF/EP
    0xA20C: ("SpatialFrequencyResponse", None),  # 0x920C
    0xA20E: ("FocalPlaneXResolution", None),  # 0x920E
    0xA20F: ("FocalPlaneYResolution", None),  # 0x920F
    0xA210: ("FocalPlaneResolutionUnit", None),  # 0x9210
    0xA214: ("SubjectLocation", None),  # 0x9214
    0xA215: ("ExposureIndex", None),  # 0x9215
    0xA217: (
        "SensingMethod",
        {  # 0x9217
            1: "Not defined",
            2: "One-chip color area",
            3: "Two-chip color area",
            4: "Three-chip color area",
            5: "Color sequential area",
            7: "Trilinear",
            8: "Color sequential linear",
        },
    ),
    0xA300: (
        "FileSource",
        {1: "Film Scanner", 2: "Reflection Print Scanner", 3: "Digital Camera"},
    ),
    0xA301: ("SceneType", {1: "Directly Photographed"}),
    0xA302: ("CVAPattern", None),
    0xA401: ("CustomRendered", {0: "Normal", 1: "Custom"}),
    0xA402: (
        "ExposureMode",
        {0: "Auto Exposure", 1: "Manual Exposure", 2: "Auto Bracket"},
    ),
    0xA403: ("WhiteBalance", {0: "Auto", 1: "Manual"}),
    0xA404: ("DigitalZoomRatio", None),
    0xA405: ("FocalLengthIn35mmFilm", None),
    0xA406: (
        "SceneCaptureType",
        {0: "Standard", 1: "Landscape", 2: "Portrait", 3: "Night"},
    ),
    0xA407: (
        "GainControl",
        {
            0: "None",
            1: "Low gain up",
            2: "High gain up",
            3: "Low gain down",
            4: "High gain down",
        },
    ),
    0xA408: ("Contrast", {0: "Normal", 1: "Soft", 2: "Hard"}),
    0xA409: ("Saturation", {0: "Normal", 1: "Soft", 2: "Hard"}),
    0xA40A: ("Sharpness", {0: "Normal", 1: "Soft", 2: "Hard"}),
    0xA40B: ("DeviceSettingDescription", None),
    0xA40C: ("SubjectDistanceRange", None),
    0xA420: ("ImageUniqueID", None),
    0xA430: ("CameraOwnerName", None),
    0xA431: ("BodySerialNumber", None),
    0xA432: ("LensSpecification", None),
    0xA433: ("LensMake", None),
    0xA434: ("LensModel", None),
    0xA435: ("LensSerialNumber", None),
    0xA500: ("Gamma", None),
    0xC4A5: ("PrintIM", None),
    0xC61A: ("BlackLevel", None),
    0xEA1C: ("Padding", None),
    0xEA1D: ("OffsetSchema", None),
    0xFDE8: ("OwnerName", None),
    0xFDE9: ("SerialNumber", None),
}
