package TDS::Admin::SkeltonEditor;

use strict;

use TDS::Admin::Editor;
use TDS::Summary;
use TDS::List::Dictionary;
use TDS::List::Url;
use TDS::Renderer;
use TDS::DirInfo;
use TDS::Style;

use vars qw(@ISA);

@ISA = qw(TDS::Admin::Editor);

attributes qw();

################################################################
sub initialize($)
{
    my $self = shift;
    $self->ext('html');
    $self->kind('skelton') unless $self->kind;
    
    $self->SUPER::initialize;
}
sub GetFilename($)
{
    my $self = shift;

    my $filename = $self->SUPER::GetFilename;

    if (-f $filename){           # if specified file exists in style dir
	return $filename;
    } else {                     # or, use in customize dir.
	return sprintf("%s/%s",
		       GetCustomizeDir(),
		       $self->GetOutputFilename);
    }
}


sub GetBaseType($)
{
    my $self = shift;
    
    if ($self->type eq 'admin'){
	return 'web_dir';
    } elsif (GetStyleName()){
	return 'style_dir';                # test
    } else {
	return 'customize_dir';
    }
}
sub GetTypeDir($)
{
    my $self = shift;
    if ($self->type eq 'admin'){
	return "admin";
    } else {
	return undef;
    }
}

1;
