/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Functions and variables used by the ubs-play daemon.
****/

#include "ubs.h"

// Global Variables

/*+ This variable is set to 0 by default, and if it is false, then the ubs-play daemon will pop a song from the queue and play it as usual.  If it is true, then it will play an event instead, which means that it reads out of a different queue file (tmp/next-event).  This is set to be true in the sig_event function, which comes up whenever a SIGURG is sent to the ubs-play daemon +*/
int do_event;

ubs_table PLAY;

// Shared Functions 

// ubs-play.c
void sig_event(int sig);
void sig_quit_killmedia(int sig);
int play_song(char *songname);
