/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;

public class ReadableSeekableStreamByteChannel
implements SeekableByteChannel {
    private final SeekableStream seekableStream;
    private final ReadableByteChannel rbc;
    private long pos;

    public ReadableSeekableStreamByteChannel(SeekableStream seekableStream) {
        this.seekableStream = seekableStream;
        this.rbc = Channels.newChannel(seekableStream);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.rbc.read(dst);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.seekableStream.seek(newPosition);
        this.pos = newPosition;
        return this;
    }

    @Override
    public long size() {
        return this.seekableStream.length();
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new NonWritableChannelException();
    }

    @Override
    public boolean isOpen() {
        return this.rbc.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }
}

