/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VShape;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;
import net.claribole.zvtm.glyphs.GlyphIcon;

class IcShape
extends GlyphIcon
implements Icon {
    VShape glyph;
    int trS;
    Polygon p;
    int[] xcoords;
    int[] ycoords;
    float vertexAngle;
    float[] vertices;

    IcShape(VShape g, int w, int h) {
        this.glyph = g;
        this.width = w;
        this.height = h;
    }

    public void setGlyph(Glyph g) {
        this.glyph = (VShape)g;
    }

    public Glyph getGlyph() {
        return this.glyph;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.cWidth = c.getWidth() / 2;
        this.cHeight = c.getHeight() / 2;
        this.computePolygon();
        if (this.glyph.isFilled()) {
            g.setColor(this.glyph.getColor());
            g.fillPolygon(this.p);
        }
        g.setColor(this.glyph.getBorderColor());
        g.drawPolygon(this.p);
    }

    protected void computePolygon() {
        this.trS = Math.min(this.width, this.height) / 2 - 2;
        this.vertexAngle = this.glyph.getOrient();
        this.vertices = this.glyph.getVertices();
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        for (int j = 0; j < this.vertices.length - 1; ++j) {
            this.xcoords[j] = (int)Math.round((double)this.cWidth + (double)this.trS * Math.cos(this.vertexAngle) * (double)this.vertices[j]);
            this.ycoords[j] = (int)Math.round((double)this.cHeight - (double)this.trS * Math.sin(this.vertexAngle) * (double)this.vertices[j]);
            this.vertexAngle = (float)((double)this.vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.cWidth + (double)this.trS * Math.cos(this.vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.cHeight - (double)this.trS * Math.sin(this.vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.p = new Polygon(this.xcoords, this.ycoords, this.vertices.length);
    }
}

