<?php

class ASPSiteLogic extends SOY2LogicBase{

    private $ignoreList = array(
		"www",
		"admin",
		"register",
		"administrator",
		"blog",
		"blogs",
		"office",
		"official",
		"download",
		"inquiry",
		"contact",
		"contactus",
		"registration",
		"mail",
		"mobile",
		"news",
		"template",
		"app",
		"application",
		"partner",
		"partnership",
		"integrator",
		"integration",
		"member",
		"membership",
		"partners",
		"integrators",
		"members",
		"shop",
		"ec",
		"cart",
		"user",
		"users"
	);

	/**
	 * 無効なサイトIDか判断する
	 * @return boolean 有効(true)|無効(flase)
	 */
	function checkValidSiteId($siteId){
		$siteDao = SOY2DAOFactory::create("admin.SiteDAO");

		try{
			$siteDao->getBySiteId(strtolower($siteId));
			return false;
		}catch(Exception $e){
			if(in_array(strtolower($siteId),$this->ignoreList)){
				return false;
			}
		}

		$certificationQueueDao = SOY2DAOFactory::create("asp.CertificationQueueDAO");
		$result = $certificationQueueDao->getBySiteId(strtolower($siteId));

		if(count($result)>0){
			return false;
		}

		return true;
	}

	function checkValidEmail($email){
		$userDao = SOY2DAOFactory::create("asp.ASPUserDAO");

		try{
			$userDao->getByEmail($email);
			return false;
		}catch(Exception $e){

		}

		return true;
	}

	/**
	 * サイトを削除する
	 * @return boolean
	 * @param id 削除するサイトのID
	 */
    function removeSite($id){

    	//$logic = SOY2Logic::createInstance("logic.admin.Site.SiteDeleteLogic");
    	//Deletロジックへ委譲するように変更が必要
    	SOY2DAOConfig::Dsn(SOYCMS_ASP_DSN);
    	SOY2DAOConfig::user(SOYCMS_ASP_USER);
    	SOY2DAOConfig::pass(SOYCMS_ASP_PASS);

    	$dao = SOY2DAOFactory::create("admin.SiteDAO");
		$userSiteDAO = SOY2DAOFactory::create("asp.UserSiteDAO");
		$userDAO = SOY2DAOFactory::create("asp.ASPUserDAO");
		$dao->begin();
		try{

			$site = $dao->getById($id);

			$userSiteDAO->deleteBySiteId($id);
			$dao->delete($id);

			$siteDir = UserInfoUtil::getSiteDirectory();

			$logic = SOY2Logic::createInstance("logic.admin.Site.SiteDeleteLogic");
			$logic->deleteSiteDir($siteDir);

			$dao->commit();

			if($site->getIsDomainRoot()){
				$logic = SOY2Logic::createInstance("logic.admin.Site.DomainRootSiteLogic");
				$logic->delete();
			}

			$userDAO->delete(UserInfoUtil::getUserId());

			return true;
		}catch(Exception $e){
			$dao->rollback();
			return false;
		}
    }
}
?>