/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import it.unimi.dsi.io.InputBitStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.campagnelab.goby.counts.CountsReaderI;

public class CountsReader
implements CountsReaderI {
    private final InputBitStream input;
    protected static final int END_OF_DATA_MARKER = 277492431;
    private boolean endOfStream;
    private int deltaCount;
    private int currentCount;
    private int length = -1;
    final int[] positions;
    final int[] offsets;
    final int[] counts;
    private boolean nextTransitionLoaded;
    private int count;
    private int position = -1;
    private boolean hasIndex;

    @Override
    public int getPosition() {
        return this.position;
    }

    public CountsReader(InputStream inputStream) throws IOException {
        this.input = new InputBitStream(inputStream);
        this.count = this.currentCount = this.input.readDelta() - 1;
        this.positions = null;
        this.offsets = null;
        this.counts = null;
    }

    public CountsReader(InputBitStream inputBitStream) throws IOException {
        this.input = inputBitStream;
        this.count = this.currentCount = this.input.readDelta() - 1;
        this.positions = null;
        this.offsets = null;
        this.counts = null;
    }

    public CountsReader(InputStream inputStream, DataInput indexInputStream) throws IOException {
        assert (inputStream instanceof RepositionableStream) : "inputStream must be repositionable.";
        this.input = new InputBitStream(inputStream);
        this.count = this.currentCount = this.input.readDelta() - 1;
        if (indexInputStream != null) {
            int length = indexInputStream.readInt();
            this.positions = new int[length];
            BinIO.loadInts((DataInput)indexInputStream, (int[])this.positions);
            this.offsets = new int[length];
            BinIO.loadInts((DataInput)indexInputStream, (int[])this.offsets);
            this.counts = new int[length];
            BinIO.loadInts((DataInput)indexInputStream, (int[])this.counts);
            this.hasIndex = true;
        } else {
            this.positions = null;
            this.offsets = null;
            this.counts = null;
        }
    }

    @Override
    public boolean hasNextTransition() throws IOException {
        int decodedDeltaCount;
        if (this.nextTransitionLoaded) {
            return true;
        }
        if (this.endOfStream) {
            return false;
        }
        int deltaCount = this.input.readGamma();
        if (deltaCount == 277492431) {
            this.endOfStream = true;
            return false;
        }
        this.position += Math.max(1, this.length);
        this.length = this.input.readGamma();
        this.deltaCount = decodedDeltaCount = CountsReader.decodeDeltaCount(deltaCount);
        this.count += decodedDeltaCount;
        this.nextTransitionLoaded = true;
        return true;
    }

    @Override
    public void nextTransition() throws IOException {
        if (!this.hasNextTransition()) {
            throw new IllegalStateException("next cannot be called when hasNext would return false.");
        }
        this.nextTransitionLoaded = false;
    }

    public int getDeltaCount() {
        return this.deltaCount;
    }

    public boolean hasNextPosition() throws IOException {
        if (this.length > 0) {
            return true;
        }
        if (this.endOfStream) {
            return false;
        }
        int deltaCount = this.input.readGamma();
        if (deltaCount == 277492431) {
            this.endOfStream = true;
            return false;
        }
        this.length = this.input.readGamma();
        int decodedDeltaCount = CountsReader.decodeDeltaCount(deltaCount);
        this.currentCount += decodedDeltaCount;
        return true;
    }

    public int nextCountAtPosition() throws IOException {
        if (this.hasNextPosition()) {
            --this.length;
            ++this.position;
            return this.currentCount;
        }
        throw new IllegalStateException("next cannot be called when hasNext would return false.");
    }

    protected static int decodeDeltaCount(int deltaCount) {
        if (deltaCount % 2 == 1) {
            return -((deltaCount - 1) / 2);
        }
        return deltaCount / 2;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void skipTo(int position) throws IOException {
        if (position < this.position) {
            if (this.hasNextTransition()) {
                this.nextTransition();
            }
            return;
        }
        if (this.hasIndex) {
            this.reposition(position);
        } else {
            while (this.hasNextTransition()) {
                this.nextTransition();
                if (this.getPosition() < position) continue;
                break;
            }
        }
    }

    @Override
    public void reposition(int position) throws IOException {
        if (!this.hasIndex) {
            throw new IllegalStateException("The Counts must have an index to use the reposition method.");
        }
        int r = Arrays.binarySearch(this.positions, position);
        int ip = r >= 0 ? r : -(r + 1);
        int index = r >= 0 ? r : Math.max(0, ip);
        int priorIndex = index - 1;
        if (index == this.positions.length) {
            this.endOfStream = true;
            return;
        }
        if (priorIndex < 0 || index >= this.positions.length) {
            this.position = position;
            this.count = 0;
            this.deltaCount = 0;
            this.nextTransitionLoaded = false;
            this.input.position(0L);
            this.endOfStream = false;
            return;
        }
        if (this.positions[index] == position) {
            this.position = position;
            this.count = this.counts[index];
            this.deltaCount = 0;
            this.nextTransitionLoaded = false;
            this.input.position((long)this.offsets[index]);
            this.endOfStream = false;
            this.input.readGamma();
            this.length = this.input.readGamma();
            return;
        }
        this.position = this.positions[priorIndex];
        this.count = priorIndex < 0 ? 0 : this.counts[priorIndex];
        this.input.position((long)this.offsets[priorIndex]);
        this.endOfStream = false;
        this.nextTransitionLoaded = false;
        this.currentCount = this.count;
        this.deltaCount = 0;
        this.length = 0;
        this.input.readGamma();
        this.length = this.input.readGamma();
        while (this.hasNextTransition()) {
            this.nextTransition();
            if (this.getPosition() < position) continue;
            break;
        }
    }

    public boolean isPositionInIndex(int i) {
        return Arrays.binarySearch(this.positions, i) >= 0;
    }
}

