require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ALPHA_INTR_H_)) {
    eval 'sub _ALPHA_INTR_H_ () {1;}' unless defined(&_ALPHA_INTR_H_);
    require 'sys/evcnt.ph';
    require 'machine/alpha_cpu.ph';
    eval 'sub SCB_IOVECBASE () {0x800;}' unless defined(&SCB_IOVECBASE);
    eval 'sub SCB_VECSIZE () {0x10;}' unless defined(&SCB_VECSIZE);
    eval 'sub SCB_SIZE () {0x2000;}' unless defined(&SCB_SIZE);
    eval 'sub SCB_VECTOIDX {
        my($x) = @_;
	    eval q((($x) >> 4));
    }' unless defined(&SCB_VECTOIDX);
    eval 'sub SCB_IDXTOVEC {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&SCB_IDXTOVEC);
    eval 'sub SCB_NIOVECS () { &SCB_VECTOIDX( &SCB_SIZE -  &SCB_IOVECBASE);}' unless defined(&SCB_NIOVECS);
    eval 'sub IPL_NONE () { &ALPHA_PSL_IPL_0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFTCLOCK () { &ALPHA_PSL_IPL_SOFT_LO;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTBIO () { &ALPHA_PSL_IPL_SOFT_LO;}' unless defined(&IPL_SOFTBIO);
    if(defined(&__HAVE_FAST_SOFTINTS)) {
	eval 'sub IPL_SOFTNET () { &ALPHA_PSL_IPL_SOFT_HI;}' unless defined(&IPL_SOFTNET);
	eval 'sub IPL_SOFTSERIAL () { &ALPHA_PSL_IPL_SOFT_HI;}' unless defined(&IPL_SOFTSERIAL);
    } else {
	eval 'sub IPL_SOFTNET () { &ALPHA_PSL_IPL_SOFT_LO;}' unless defined(&IPL_SOFTNET);
	eval 'sub IPL_SOFTSERIAL () { &ALPHA_PSL_IPL_SOFT_LO;}' unless defined(&IPL_SOFTSERIAL);
    }
    eval 'sub IPL_VM () { &ALPHA_PSL_IPL_IO_HI;}' unless defined(&IPL_VM);
    eval 'sub IPL_SCHED () { &ALPHA_PSL_IPL_CLOCK;}' unless defined(&IPL_SCHED);
    eval 'sub IPL_HIGH () { &ALPHA_PSL_IPL_HIGH;}' unless defined(&IPL_HIGH);
    eval 'sub SOFTINT_CLOCK_MASK () { &__BIT( &SOFTINT_CLOCK);}' unless defined(&SOFTINT_CLOCK_MASK);
    eval 'sub SOFTINT_BIO_MASK () { &__BIT( &SOFTINT_BIO);}' unless defined(&SOFTINT_BIO_MASK);
    eval 'sub SOFTINT_NET_MASK () { &__BIT( &SOFTINT_NET);}' unless defined(&SOFTINT_NET_MASK);
    eval 'sub SOFTINT_SERIAL_MASK () { &__BIT( &SOFTINT_SERIAL);}' unless defined(&SOFTINT_SERIAL_MASK);
    eval 'sub ALPHA_IPL1_SOFTINTS () {( &SOFTINT_CLOCK_MASK |  &SOFTINT_BIO_MASK);}' unless defined(&ALPHA_IPL1_SOFTINTS);
    eval 'sub ALPHA_IPL2_SOFTINTS () {( &SOFTINT_NET_MASK |  &SOFTINT_SERIAL_MASK);}' unless defined(&ALPHA_IPL2_SOFTINTS);
    eval 'sub ALPHA_ALL_SOFTINTS () {( &ALPHA_IPL1_SOFTINTS |  &ALPHA_IPL2_SOFTINTS);}' unless defined(&ALPHA_ALL_SOFTINTS);
    eval 'sub makeiplcookie {
        my($ipl) = @_;
	    eval q({ ( &ipl_cookie_t){. &_psl = ( &uint8_t)$ipl}; });
    }' unless defined(&makeiplcookie);
    eval 'sub IST_UNUSABLE () {-1;}' unless defined(&IST_UNUSABLE);
    eval 'sub IST_NONE () {0;}' unless defined(&IST_NONE);
    eval 'sub IST_PULSE () {1;}' unless defined(&IST_PULSE);
    eval 'sub IST_EDGE () {2;}' unless defined(&IST_EDGE);
    eval 'sub IST_LEVEL () {3;}' unless defined(&IST_LEVEL);
    if(defined(&_KERNEL)) {
	eval 'sub splx {
	    my($s) = @_;
    	    eval q( &spllower($s));
	}' unless defined(&splx);
	eval 'sub spl0 () {
	    eval q( &spllower( &ALPHA_PSL_IPL_0));
	}' unless defined(&spl0);
	eval 'sub splraiseipl {
	    my($icookie) = @_;
    	    eval q( &_splraise(($icookie). &_psl));
	}' unless defined(&splraiseipl);
	require 'sys/spl.ph';
	eval 'sub ALPHA_IPI_HALT () {(1 << 0);}' unless defined(&ALPHA_IPI_HALT);
	eval 'sub ALPHA_IPI_PRIMARY_CC () {(1 << 1);}' unless defined(&ALPHA_IPI_PRIMARY_CC);
	eval 'sub ALPHA_IPI_SHOOTDOWN () {(1 << 2);}' unless defined(&ALPHA_IPI_SHOOTDOWN);
	eval 'sub ALPHA_IPI_AST () {(1 << 3);}' unless defined(&ALPHA_IPI_AST);
	eval 'sub ALPHA_IPI_PAUSE () {(1 << 4);}' unless defined(&ALPHA_IPI_PAUSE);
	eval 'sub ALPHA_IPI_XCALL () {(1 << 5);}' unless defined(&ALPHA_IPI_XCALL);
	eval 'sub ALPHA_IPI_GENERIC () {(1 << 6);}' unless defined(&ALPHA_IPI_GENERIC);
	eval 'sub ALPHA_NIPIS () {7;}' unless defined(&ALPHA_NIPIS);
	eval 'sub ALPHA_INTR_MPSAFE () {0x1;}' unless defined(&ALPHA_INTR_MPSAFE);
	eval 'sub ALPHA_SHARED_INTR_DISABLE {
	    my($asi, $num) = @_;
    	    eval q((($asi)[$num]. &intr_maxstrays != 0 && ($asi)[$num]. &intr_nstrays == ($asi)[$num]. &intr_maxstrays));
	}' unless defined(&ALPHA_SHARED_INTR_DISABLE);
	eval 'sub SCB_ALLOC_FAILED () {( -1);}' unless defined(&SCB_ALLOC_FAILED);
    }
}
1;
