require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CRYPTO_CRYPTO_H_)) {
    eval 'sub _CRYPTO_CRYPTO_H_ () {1;}' unless defined(&_CRYPTO_CRYPTO_H_);
    require 'sys/types.ph';
    require 'sys/ioccom.ph';
    require 'sys/time.ph';
    if(defined(&_KERNEL_OPT)) {
	require './crypto/opt_ocf.ph';
    }
    eval 'sub CRYPTO_DRIVERS_INITIAL () {4;}' unless defined(&CRYPTO_DRIVERS_INITIAL);
    eval 'sub CRYPTO_SW_SESSIONS () {32;}' unless defined(&CRYPTO_SW_SESSIONS);
    eval 'sub HMAC_BLOCK_LEN () {64;}' unless defined(&HMAC_BLOCK_LEN);
    eval 'sub HMAC_IPAD_VAL () {0x36;}' unless defined(&HMAC_IPAD_VAL);
    eval 'sub HMAC_OPAD_VAL () {0x5c;}' unless defined(&HMAC_OPAD_VAL);
    eval 'sub DES_BLOCK_LEN () {8;}' unless defined(&DES_BLOCK_LEN);
    eval 'sub DES3_BLOCK_LEN () {8;}' unless defined(&DES3_BLOCK_LEN);
    eval 'sub BLOWFISH_BLOCK_LEN () {8;}' unless defined(&BLOWFISH_BLOCK_LEN);
    eval 'sub SKIPJACK_BLOCK_LEN () {8;}' unless defined(&SKIPJACK_BLOCK_LEN);
    eval 'sub CAST128_BLOCK_LEN () {8;}' unless defined(&CAST128_BLOCK_LEN);
    eval 'sub RIJNDAEL128_BLOCK_LEN () {16;}' unless defined(&RIJNDAEL128_BLOCK_LEN);
    eval 'sub EALG_MAX_BLOCK_LEN () {16;}' unless defined(&EALG_MAX_BLOCK_LEN);
    eval 'sub AALG_MAX_RESULT_LEN () {64;}' unless defined(&AALG_MAX_RESULT_LEN);
    eval 'sub CRYPTO_ALGORITHM_MIN () {1;}' unless defined(&CRYPTO_ALGORITHM_MIN);
    eval 'sub CRYPTO_DES_CBC () {1;}' unless defined(&CRYPTO_DES_CBC);
    eval 'sub CRYPTO_3DES_CBC () {2;}' unless defined(&CRYPTO_3DES_CBC);
    eval 'sub CRYPTO_BLF_CBC () {3;}' unless defined(&CRYPTO_BLF_CBC);
    eval 'sub CRYPTO_CAST_CBC () {4;}' unless defined(&CRYPTO_CAST_CBC);
    eval 'sub CRYPTO_SKIPJACK_CBC () {5;}' unless defined(&CRYPTO_SKIPJACK_CBC);
    eval 'sub CRYPTO_MD5_HMAC () {6;}' unless defined(&CRYPTO_MD5_HMAC);
    eval 'sub CRYPTO_SHA1_HMAC () {7;}' unless defined(&CRYPTO_SHA1_HMAC);
    eval 'sub CRYPTO_RIPEMD160_HMAC () {8;}' unless defined(&CRYPTO_RIPEMD160_HMAC);
    eval 'sub CRYPTO_MD5_KPDK () {9;}' unless defined(&CRYPTO_MD5_KPDK);
    eval 'sub CRYPTO_SHA1_KPDK () {10;}' unless defined(&CRYPTO_SHA1_KPDK);
    eval 'sub CRYPTO_RIJNDAEL128_CBC () {11;}' unless defined(&CRYPTO_RIJNDAEL128_CBC);
    eval 'sub CRYPTO_AES_CBC () {11;}' unless defined(&CRYPTO_AES_CBC);
    eval 'sub CRYPTO_ARC4 () {12;}' unless defined(&CRYPTO_ARC4);
    eval 'sub CRYPTO_MD5 () {13;}' unless defined(&CRYPTO_MD5);
    eval 'sub CRYPTO_SHA1 () {14;}' unless defined(&CRYPTO_SHA1);
    eval 'sub CRYPTO_SHA2_256_HMAC () {15;}' unless defined(&CRYPTO_SHA2_256_HMAC);
    eval 'sub CRYPTO_SHA2_HMAC () { &CRYPTO_SHA2_256_HMAC;}' unless defined(&CRYPTO_SHA2_HMAC);
    eval 'sub CRYPTO_NULL_HMAC () {16;}' unless defined(&CRYPTO_NULL_HMAC);
    eval 'sub CRYPTO_NULL_CBC () {17;}' unless defined(&CRYPTO_NULL_CBC);
    eval 'sub CRYPTO_DEFLATE_COMP () {18;}' unless defined(&CRYPTO_DEFLATE_COMP);
    eval 'sub CRYPTO_MD5_HMAC_96 () {19;}' unless defined(&CRYPTO_MD5_HMAC_96);
    eval 'sub CRYPTO_SHA1_HMAC_96 () {20;}' unless defined(&CRYPTO_SHA1_HMAC_96);
    eval 'sub CRYPTO_RIPEMD160_HMAC_96 () {21;}' unless defined(&CRYPTO_RIPEMD160_HMAC_96);
    eval 'sub CRYPTO_GZIP_COMP () {22;}' unless defined(&CRYPTO_GZIP_COMP);
    eval 'sub CRYPTO_DEFLATE_COMP_NOGROW () {23;}' unless defined(&CRYPTO_DEFLATE_COMP_NOGROW);
    eval 'sub CRYPTO_SHA2_384_HMAC () {24;}' unless defined(&CRYPTO_SHA2_384_HMAC);
    eval 'sub CRYPTO_SHA2_512_HMAC () {25;}' unless defined(&CRYPTO_SHA2_512_HMAC);
    eval 'sub CRYPTO_CAMELLIA_CBC () {26;}' unless defined(&CRYPTO_CAMELLIA_CBC);
    eval 'sub CRYPTO_AES_CTR () {27;}' unless defined(&CRYPTO_AES_CTR);
    eval 'sub CRYPTO_AES_XCBC_MAC_96 () {28;}' unless defined(&CRYPTO_AES_XCBC_MAC_96);
    eval 'sub CRYPTO_AES_GCM_16 () {29;}' unless defined(&CRYPTO_AES_GCM_16);
    eval 'sub CRYPTO_AES_128_GMAC () {30;}' unless defined(&CRYPTO_AES_128_GMAC);
    eval 'sub CRYPTO_AES_192_GMAC () {31;}' unless defined(&CRYPTO_AES_192_GMAC);
    eval 'sub CRYPTO_AES_256_GMAC () {32;}' unless defined(&CRYPTO_AES_256_GMAC);
    eval 'sub CRYPTO_AES_GMAC () {33;}' unless defined(&CRYPTO_AES_GMAC);
    eval 'sub CRYPTO_ALGORITHM_MAX () {33;}' unless defined(&CRYPTO_ALGORITHM_MAX);
    eval 'sub CRYPTO_ALG_FLAG_SUPPORTED () {0x1;}' unless defined(&CRYPTO_ALG_FLAG_SUPPORTED);
    eval 'sub CRYPTO_ALG_FLAG_RNG_ENABLE () {0x2;}' unless defined(&CRYPTO_ALG_FLAG_RNG_ENABLE);
    eval 'sub CRYPTO_ALG_FLAG_DSA_SHA () {0x4;}' unless defined(&CRYPTO_ALG_FLAG_DSA_SHA);
    eval 'sub COP_ENCRYPT () {1;}' unless defined(&COP_ENCRYPT);
    eval 'sub COP_DECRYPT () {2;}' unless defined(&COP_DECRYPT);
    eval 'sub COP_COMP () {3;}' unless defined(&COP_COMP);
    eval 'sub COP_DECOMP () {4;}' unless defined(&COP_DECOMP);
    eval 'sub COP_F_BATCH () {0x8;}' unless defined(&COP_F_BATCH);
    eval 'sub COP_ENCRYPT () {1;}' unless defined(&COP_ENCRYPT);
    eval 'sub COP_DECRYPT () {2;}' unless defined(&COP_DECRYPT);
    eval 'sub COP_F_BATCH () {0x8;}' unless defined(&COP_F_BATCH);
    eval 'sub COP_F_MORE () {0x10;}' unless defined(&COP_F_MORE);
    eval 'sub CRYPTO_MAX_MAC_LEN () {32;}' unless defined(&CRYPTO_MAX_MAC_LEN);
    eval 'sub CRK_MAXPARAM () {8;}' unless defined(&CRK_MAXPARAM);
    eval 'sub CRK_ALGORITHM_MIN () {0;}' unless defined(&CRK_ALGORITHM_MIN);
    eval 'sub CRK_MOD_EXP () {0;}' unless defined(&CRK_MOD_EXP);
    eval 'sub CRK_MOD_EXP_CRT () {1;}' unless defined(&CRK_MOD_EXP_CRT);
    eval 'sub CRK_DSA_SIGN () {2;}' unless defined(&CRK_DSA_SIGN);
    eval 'sub CRK_DSA_VERIFY () {3;}' unless defined(&CRK_DSA_VERIFY);
    eval 'sub CRK_DH_COMPUTE_KEY () {4;}' unless defined(&CRK_DH_COMPUTE_KEY);
    eval 'sub CRK_MOD_ADD () {5;}' unless defined(&CRK_MOD_ADD);
    eval 'sub CRK_MOD_ADDINV () {6;}' unless defined(&CRK_MOD_ADDINV);
    eval 'sub CRK_MOD_SUB () {7;}' unless defined(&CRK_MOD_SUB);
    eval 'sub CRK_MOD_MULT () {8;}' unless defined(&CRK_MOD_MULT);
    eval 'sub CRK_MOD_MULTINV () {9;}' unless defined(&CRK_MOD_MULTINV);
    eval 'sub CRK_MOD () {10;}' unless defined(&CRK_MOD);
    eval 'sub CRK_ALGORITHM_MAX () {10;}' unless defined(&CRK_ALGORITHM_MAX);
    eval 'sub CRF_MOD_EXP () {(1<<  &CRK_MOD_EXP);}' unless defined(&CRF_MOD_EXP);
    eval 'sub CRF_MOD_EXP_CRT () {(1<<  &CRK_MOD_EXP_CRT);}' unless defined(&CRF_MOD_EXP_CRT);
    eval 'sub CRF_DSA_SIGN () {(1<<  &CRK_DSA_SIGN);}' unless defined(&CRF_DSA_SIGN);
    eval 'sub CRF_DSA_VERIFY () {(1<<  &CRK_DSA_VERIFY);}' unless defined(&CRF_DSA_VERIFY);
    eval 'sub CRF_DH_COMPUTE_KEY () {(1<<  &CRK_DH_COMPUTE_KEY);}' unless defined(&CRF_DH_COMPUTE_KEY);
    eval 'sub CRF_MOD_ADD () {(1<<  &CRK_MOD_ADD);}' unless defined(&CRF_MOD_ADD);
    eval 'sub CRF_MOD_ADDINV () {(1<<  &CRK_MOD_ADDINV);}' unless defined(&CRF_MOD_ADDINV);
    eval 'sub CRF_MOD_SUB () {(1<<  &CRK_MOD_SUB);}' unless defined(&CRF_MOD_SUB);
    eval 'sub CRF_MOD_MULT () {(1<<  &CRK_MOD_MULT);}' unless defined(&CRF_MOD_MULT);
    eval 'sub CRF_MOD_MULTINV () {(1<<  &CRK_MOD_MULTINV);}' unless defined(&CRF_MOD_MULTINV);
    eval 'sub CRF_MOD () {(1<<  &CRK_MOD);}' unless defined(&CRF_MOD);
    eval 'sub CRIOGET () { &_IOWR(ord(\'c\'), 100,  &u_int32_t);}' unless defined(&CRIOGET);
    eval 'sub CIOCFSESSION () { &_IOW(ord(\'c\'), 102,  &u_int32_t);}' unless defined(&CIOCFSESSION);
    eval 'sub CIOCKEY () { &_IOWR(ord(\'c\'), 104, \'struct crypt_kop\');}' unless defined(&CIOCKEY);
    eval 'sub CIOCNFKEYM () { &_IOWR(ord(\'c\'), 108, \'struct crypt_mkop\');}' unless defined(&CIOCNFKEYM);
    eval 'sub CIOCNFSESSION () { &_IOW(ord(\'c\'), 109, \'struct crypt_sfop\');}' unless defined(&CIOCNFSESSION);
    eval 'sub CIOCNCRYPTRETM () { &_IOWR(ord(\'c\'), 110, \'struct cryptret\');}' unless defined(&CIOCNCRYPTRETM);
    eval 'sub CIOCNCRYPTRET () { &_IOWR(ord(\'c\'), 111, \'struct crypt_result\');}' unless defined(&CIOCNCRYPTRET);
    eval 'sub CIOCGSESSION () { &_IOWR(ord(\'c\'), 112, \'struct session_op\');}' unless defined(&CIOCGSESSION);
    eval 'sub CIOCNGSESSION () { &_IOWR(ord(\'c\'), 113, \'struct crypt_sgop\');}' unless defined(&CIOCNGSESSION);
    eval 'sub CIOCCRYPT () { &_IOWR(ord(\'c\'), 114, \'struct crypt_op\');}' unless defined(&CIOCCRYPT);
    eval 'sub CIOCNCRYPTM () { &_IOWR(ord(\'c\'), 115, \'struct crypt_mop\');}' unless defined(&CIOCNCRYPTM);
    eval 'sub CIOCASYMFEAT () { &_IOR(ord(\'c\'), 105,  &u_int32_t);}' unless defined(&CIOCASYMFEAT);
    if(defined(&_KERNEL)) {
	require 'sys/condvar.ph';
	require 'sys/malloc.ph';
	require 'sys/mutex.ph';
	require 'sys/queue.ph';
	require 'sys/systm.ph';
	eval 'sub CRD_F_ENCRYPT () {0x1;}' unless defined(&CRD_F_ENCRYPT);
	eval 'sub CRD_F_IV_PRESENT () {0x2;}' unless defined(&CRD_F_IV_PRESENT);
	eval 'sub CRD_F_IV_EXPLICIT () {0x4;}' unless defined(&CRD_F_IV_EXPLICIT);
	eval 'sub CRD_F_DSA_SHA_NEEDED () {0x8;}' unless defined(&CRD_F_DSA_SHA_NEEDED);
	eval 'sub CRD_F_COMP () {0x10;}' unless defined(&CRD_F_COMP);
	eval 'sub crd_iv () { ($CRD_INI->{cri_iv});}' unless defined(&crd_iv);
	eval 'sub crd_key () { ($CRD_INI->{cri_key});}' unless defined(&crd_key);
	eval 'sub crd_rnd () { ($CRD_INI->{cri_rnd});}' unless defined(&crd_rnd);
	eval 'sub crd_alg () { ($CRD_INI->{cri_alg});}' unless defined(&crd_alg);
	eval 'sub crd_klen () { ($CRD_INI->{cri_klen});}' unless defined(&crd_klen);
	eval 'sub CRYPTO_F_IMBUF () {0x1;}' unless defined(&CRYPTO_F_IMBUF);
	eval 'sub CRYPTO_F_IOV () {0x2;}' unless defined(&CRYPTO_F_IOV);
	eval 'sub CRYPTO_F_REL () {0x4;}' unless defined(&CRYPTO_F_REL);
	eval 'sub CRYPTO_F_BATCH () {0x8;}' unless defined(&CRYPTO_F_BATCH);
	eval 'sub CRYPTO_F_UNUSED0 () {0x10;}' unless defined(&CRYPTO_F_UNUSED0);
	eval 'sub CRYPTO_F_UNUSED1 () {0x20;}' unless defined(&CRYPTO_F_UNUSED1);
	eval 'sub CRYPTO_F_UNUSED2 () {0x40;}' unless defined(&CRYPTO_F_UNUSED2);
	eval 'sub CRYPTO_F_ONRETQ () {0x80;}' unless defined(&CRYPTO_F_ONRETQ);
	eval 'sub CRYPTO_F_UNUSED3 () {0x100;}' unless defined(&CRYPTO_F_UNUSED3);
	eval 'sub CRYPTO_F_MORE () {0x200;}' unless defined(&CRYPTO_F_MORE);
	eval 'sub CRYPTODEV_F_RET () {0x1;}' unless defined(&CRYPTODEV_F_RET);
	eval 'sub CRYPTO_BUF_CONTIG () {0x;}' unless defined(&CRYPTO_BUF_CONTIG);
	eval 'sub CRYPTO_BUF_IOV () {0x1;}' unless defined(&CRYPTO_BUF_IOV);
	eval 'sub CRYPTO_BUF_MBUF () {0x2;}' unless defined(&CRYPTO_BUF_MBUF);
	eval 'sub CRYPTO_OP_DECRYPT () {0x;}' unless defined(&CRYPTO_OP_DECRYPT);
	eval 'sub CRYPTO_OP_ENCRYPT () {0x1;}' unless defined(&CRYPTO_OP_ENCRYPT);
	eval 'sub CRYPTO_HINT_MORE () {0x1;}' unless defined(&CRYPTO_HINT_MORE);
	eval 'sub CRYPTOCAP_F_CLEANUP () {0x1;}' unless defined(&CRYPTOCAP_F_CLEANUP);
	eval 'sub CRYPTOCAP_F_SOFTWARE () {0x2;}' unless defined(&CRYPTOCAP_F_SOFTWARE);
	eval 'sub CRYPTOCAP_F_SYNC () {0x4;}' unless defined(&CRYPTOCAP_F_SYNC);
	eval 'sub CRYPTO_SESID2HID {
	    my($_sid) = @_;
    	    eval q((((($_sid) >> 32) & 0xffffff) - 1));
	}' unless defined(&CRYPTO_SESID2HID);
	eval 'sub CRYPTO_SESID2CAPS {
	    my($_sid) = @_;
    	    eval q(((($_sid) >> 56) & 0xff));
	}' unless defined(&CRYPTO_SESID2CAPS);
	eval 'sub CRYPTO_SESID2LID {
	    my($_sid) = @_;
    	    eval q(((( &u_int32_t) ($_sid)) & 0xffffffff));
	}' unless defined(&CRYPTO_SESID2LID);
	eval 'sub CRYPTO_SYMQ () {0x1;}' unless defined(&CRYPTO_SYMQ);
	eval 'sub CRYPTO_ASYMQ () {0x2;}' unless defined(&CRYPTO_ASYMQ);
	if(defined(&CRYPTO_DEBUG)) {
	    unless(defined(&DPRINTF)) {
		eval 'sub DPRINTF () {( &a, ...)  &printf("%s: "  &a,  &__func__,  &__VA_ARGS__);}' unless defined(&DPRINTF);
	    }
	} else {
	    unless(defined(&DPRINTF)) {
		eval 'sub DPRINTF () {( &a, ...);}' unless defined(&DPRINTF);
	    }
	}
    }
}
1;
