<?php
namespace TYPO3\CMS\Backend\Wizard;

/**
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
/**
 * Interface for classes which hook into SC_db_new_content_el and manipulator wizardItems array
 *
 * @author Steffen Kamper <info@sk-typo3.de>
 */
interface NewContentElementWizardHookInterface {
	/**
	 * Modifies WizardItems array
	 *
	 * @param array $wizardItems Array of Wizard Items
	 * @param \TYPO3\CMS\Backend\Controller\ContentElement\NewContentElementController $parentObject Parent object New Content element wizard
	 * @return void
	 */
	public function manipulateWizardItems(&$wizardItems, &$parentObject);

}
