<?php

/**
 * BaseEmployeeLicense
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int              $empNumber                        Type: integer, primary key
 * @property int              $licenseId                        Type: integer, primary key
 * @property string           $licenseNo                        Type: string(50)
 * @property string           $licenseIssuedDate                Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property string           $licenseExpiryDate                Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property Employee         $Employee                         
 * @property License          $License                          
 *  
 * @method int                getEmpnumber()                    Type: integer, primary key
 * @method int                getLicenseid()                    Type: integer, primary key
 * @method string             getLicenseno()                    Type: string(50)
 * @method string             getLicenseissueddate()            Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method string             getLicenseexpirydate()            Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method Employee           getEmployee()                     
 * @method License            getLicense()                      
 *  
 * @method EmployeeLicense    setEmpnumber(int $val)            Type: integer, primary key
 * @method EmployeeLicense    setLicenseid(int $val)            Type: integer, primary key
 * @method EmployeeLicense    setLicenseno(string $val)         Type: string(50)
 * @method EmployeeLicense    setLicenseissueddate(string $val) Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method EmployeeLicense    setLicenseexpirydate(string $val) Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method EmployeeLicense    setEmployee(Employee $val)        
 * @method EmployeeLicense    setLicense(License $val)          
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployeeLicense extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_emp_license');
        $this->hasColumn('emp_number as empNumber', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             ));
        $this->hasColumn('license_id as licenseId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             ));
        $this->hasColumn('license_no as licenseNo', 'string', 50, array(
             'type' => 'string',
             'length' => 50,
             ));
        $this->hasColumn('license_issued_date as licenseIssuedDate', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('license_expiry_date as licenseExpiryDate', 'date', null, array(
             'type' => 'date',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasOne('License', array(
             'local' => 'license_id',
             'foreign' => 'id'));
    }
}