<?php // -*-mode: PHP; coding:utf-8;-*-

// This file contains PHP code that specifies language specific strings
// The default strings come from lang.en, and anything in a locale
// specific file will overwrite the default. This is an NL Dutch file.
//
// Translations provided by: Marc ter Horst
//
//
// This file is PHP code. Treat it as such.

// Used in style.inc
$vocab["mrbs"]               = "Vergaderruimte Boekingssysteem";
$vocab["mrbs_abbr"]          = "MRBS";

// Used in functions.inc
$vocab["report"]             = "Rapportage";
$vocab["admin"]              = "Beheer";
$vocab["help"]               = "Help";
$vocab["search"]             = "Zoek";
$vocab["outstanding"]        = "Openstaande boekingen";

// Used in index.php
$vocab["bookingsfor"]        = "Boekingen voor";
$vocab["bookingsforpost"]    = ""; // Goes after the date
$vocab["areas"]              = "Gebouwen";
$vocab["today"]              = "Vandaag";
$vocab["daybefore"]          = "Naar vorige dag";
$vocab["dayafter"]           = "Naar volgende dag";
$vocab["gototoday"]          = "Naar vandaag";
$vocab["goto"]               = "Ga naar";
$vocab["nav_day"]            = "Dag";
$vocab["nav_week"]           = "Week";
$vocab["nav_month"]          = "Maand";
$vocab["highlight_line"]     = "Markeer deze regel";
$vocab["click_to_reserve"]   = "Klik op dit vak om een reservering te maken.";
$vocab["timezone"]           = "Tijdzone";
$vocab["weekbefore"]         = "Ga naar vorige week";
$vocab["weekafter"]          = "Ga naar volgende week";
$vocab["gotothisweek"]       = "Ga naar deze week";
$vocab["monthbefore"]        = "Ga naar vorige maand";
$vocab["monthafter"]         = "Ga naar volgende maand";
$vocab["gotothismonth"]      = "Ga naar deze maand";
$vocab["no_rooms_for_area"]  = "Nog geen ruimtes gedefiniëerd voor dit gebouw";
$vocab["loading"]            = "Laden";
$vocab["saving"]             = "Opslaan";
$vocab["week_number"]        = "Week %s | ";
$vocab["create_new_booking"] = "Maak een nieuwe boeking";
$vocab["select_area"]        = "Selecteer gebouw";
$vocab["select_room"]        = "Selecteer ruimte";
$vocab["all"]                = "<alle ruimtes>";
$vocab["registration_level_limited"]              = ' [%1$d/%2$d]';
$vocab["registration_level_limited_with_names"]   = ' [%1$d/%2$d: %3$s]';
$vocab["registration_level_unlimited"]            = ' [%1$d]';
$vocab["registration_level_unlimited_with_names"] = ' [%1$d: %2$s]';
$vocab["exit_kiosk_mode_confirm"]    = "Kiosk-modus afsluiten?";

// Used in trailer.inc
$vocab["viewday"]            = "Bekijk dag";
$vocab["viewweek"]           = "Bekijk week";
$vocab["viewmonth"]          = "Bekijk maand";
$vocab["ppreview"]           = "Afdrukvoorbeeld";

// Used in edit_entry.php
$vocab["addentry"]           = "Boeking toevoegen";
$vocab["editentry"]          = "Wijzig boeking";
$vocab["copyentry"]          = "Kopiëer boeking";
$vocab["editseries"]         = "Wijzig reeks";
$vocab["copyseries"]         = "Kopiëer reeks";
$vocab["namebooker"]         = "Korte omschrijving";
$vocab["fulldescription"]    = "Volledige omschrijving";
$vocab["date"]               = "Datum";
$vocab["start"]              = "Start";
$vocab["end"]                = "Eind";
$vocab["start_date"]         = "Starttijd";
$vocab["end_date"]           = "Eindtijd";
$vocab["time"]               = "Tijd";
$vocab["period"]             = "Periode";
$vocab["unknown_period"]     = "<Periode %d>";
$vocab["duration"]           = "Tijdsduur";
$vocab["second_lc"]          = "seconde";
$vocab["seconds"]            = "seconden";
$vocab["minute_lc"]          = "minuut";
$vocab["minutes"]            = "minuten";
$vocab["hour_lc"]            = "uur";
$vocab["hours"]              = "uren";
$vocab["day"]                = "dag";
$vocab["days"]               = "dagen";
$vocab["week"]               = "week";
$vocab["weeks"]              = "weken";
$vocab["month"]              = "maand";
$vocab["months"]             = "maanden";
$vocab["year_lc"]            = "jaar";
$vocab["years"]              = "jaren";
$vocab["period_lc"]          = "periode";
$vocab["periods"]            = "periodes";
$vocab["all_day"]            = "Hele dag";
$vocab["area"]               = "Gebouw";
$vocab["type"]               = "Soort";
$vocab["allow_registration"]        = "Aanmelden toestaan";
$vocab["registrant_limit_enabled"]  = "Maximum aantal plaatsen instellen";
$vocab["registrant_limit"]          = "Aantal plaatsen voor activiteit";
$vocab["registration_opens"]        = "Aanmelden open op";
$vocab["registration_closes"]       = "Aanmelden sluit op";
$vocab["in_advance"]                = "van tevoren";
$vocab["in_advance_periods"]        = "voor %s";  // a time, eg 09:00 or 9.00am
$vocab["n_registered"]              = "Op dit moment aangemeld";
$vocab["save"]               = "Opslaan";
$vocab["rep_type"]           = "Soort herhaling";
$vocab["rep_type_0"]         = "Geen";
$vocab["rep_type_1"]         = "Dagelijks";
$vocab["rep_type_2"]         = "Wekelijks";
$vocab["rep_type_3"]         = "Maandelijks";
$vocab["rep_type_4"]         = "Jaarlijks";
$vocab["ord_1"]              = "eerste";
$vocab["ord_2"]              = "tweede";
$vocab["ord_3"]              = "derde";
$vocab["ord_4"]              = "vierde";
$vocab["ord_5"]              = "vijfde";
$vocab["ord_-1"]             = "laatste";
$vocab["ord_-2"]             = "een-na-laatste";
$vocab["ord_-3"]             = "twee-na-laatste";
$vocab["ord_-4"]             = "drie-na-laatste";
$vocab["ord_-5"]             = "vier-na-laatste";
$vocab["rep_end_date"]       = "Eindedatum herhaling";
$vocab["rep_rep_day"]        = "Herhalingsdag";
$vocab["rep_interval"]       = "Herhaal om de";
$vocab["month_absolute"]     = "Op dag";
$vocab["month_relative"]     = "Op de";
$vocab["skip_conflicts"]     = "Negeer oude conflicten";
$vocab["no_mail"]            = "Verstuur geen e-mail";
$vocab["ctrl_click"]         = "Gebruik Ctrl-klik om meer dan 1 ruimte te reserveren";
$vocab["entryid"]            = "Boeking-ID ";
$vocab["repeat_id"]          = "Herhalings-ID "; 
$vocab["brief_description"]  = "Korte omschrijving.";
$vocab["status"]             = "Status";
$vocab["public"]             = "Publiek";
$vocab["private"]            = "Privé";
$vocab["unavailable"]        = "Niet beschikbaar";
$vocab["is_mandatory_field"] = "is een verplicht veld, geef aub een waarde in";
$vocab["missing_mandatory_field"] = "Geen waarde gegeven voor een verplicht veld";
$vocab["confirmed"]          = "Bevestigd";
$vocab["start_after_end"]    = "Startdag na einddag";
$vocab["start_after_end_long"] = "Fout: de startdag kan niet na de einddag zijn.";
$vocab["invalid_rep_interval"]     = "Het herhaalinterval moet groter zijn dan nul.";
$vocab["confirm_rep_end_date"]     = "Het lijkt dat je vergeten bent om de einddatum van de herhaling in te stellen. Wil je toch doorgaan?";
$vocab["type_reserved_for_admins"] = "Het type '%s' is gereserveerd voor beheerders";
$vocab["multiroom_not_allowed"]    = "Je mag geen boeking maken voor meerdere ruimtes.";
$vocab["edit_entry_nonexistent_room"] = "Je probeert een boeking te maken voor een ruimte die niet bestaat. " . 
                            "Dit zou misschien kunnen omdat je een bladwijzer hebt gevolgd die niet langer geldig is." .
                            "In het algemeen raden we af om bladwijzers te gebruiken om rechtstreeks naar het " . 
                            "boekingsformulier te gaan. In plaats daarvan is het beter om het boekingsformulier " .
                            "te openen vanaf de kalenderweergave.";
$vocab["home"] = "Thuis";

// Used in view_entry.php
$vocab["description"]        = "Omschrijving";
$vocab["room"]               = "Ruimte";
$vocab["createdby"]          = "Aangemaakt door";
$vocab["modifiedby"]         = "Aangepast door";
$vocab["lastupdate"]         = "Laatste aanpassing";
$vocab["repeat_on"]          = "Herhaal op dag";
$vocab["deleteentry"]        = "Verwijder boeking";
$vocab["deleteseries"]       = "Verwijder reeks";
$vocab["exportentry"]        = "Exporteer boeking";
$vocab["exportseries"]       = "Exporteer reeks";
$vocab["confirmdel"]         = "Weet je zeker dat je deze boeking wilt verwijderen?";
$vocab["confirmdel_series"]  = "Weet je zeker dat je de hele boekingsreeks wilt verwijderen?";
$vocab["confirm_edit_series"]     = "Gebruikers hebben zich voor een of meerdere activiteiten in deze reeks " .
                            "aangemeld, terwijl door het bewerken van de reeks hun namen verloren gaan. Weet u zeker " .
                            "dat u door wilt gaan?";
$vocab["returnprev"]         = "Terug naar vorige pagina";
$vocab["invalid_entry_id"]   = "Ongeldig Boeking-ID.";
$vocab["invalid_series_id"]  = "Ongeldig Herhalings-ID.";
$vocab["confirmation_status"] = "Bevestigingsstatus";
$vocab["tentative"]           = "Voorlopig";
$vocab["approval_status"]     = "Goedkeuringsstatus";
$vocab["approved"]            = "Goedgekeurd";
$vocab["awaiting_approval"]   = "Wacht op goedkeuring";
$vocab["approve"]             = "Keur goed";
$vocab["reject"]              = "Wijs Af";
$vocab["more_info"]           = "Meer informatie";
$vocab["remind_admin"]        = "Herinner beheerder";
$vocab["series"]              = "Reeks";
$vocab["request_more_info"]   = "Geef aub aan welke extra informatie nodig is";
$vocab["reject_reason"]       = "Geef aub een reden aan waarom u deze boeking afwijst";
$vocab["send"]                = "Zend";
$vocab["approve_failed"]      = "Deze boeking kon niet worden goedgekeurd.";
$vocab["no_request_yet"]      = "Nog geen verzoek verzonden"; // Used for the title tooltip on More Info button
$vocab["last_request"]        = "Laatste verzoek verzonden op";         // Used for the title tooltip on More Info button
$vocab["by"]                  = "door";                           // Used for the title tooltip on More Info button
$vocab["sent_at"]             = "Verzonden op ";
$vocab["yes"]                 = "Ja";
$vocab["no"]                  = "Nee";
$vocab["event_registration"]      = "Activiteitaanmelding";
$vocab["event_details"]           = "Activiteitendetails";
$vocab["already_registered"]      = "Je bent aangemeld voor deze activiteit";
$vocab["register"]                = "Aanmelden";
$vocab["cancel_registration"]     = "Aanmelding annuleren";
$vocab["registered_by"]           = "Aangemeld door";
$vocab["registered_on"]           = "Aangemeld op";
$vocab["event_full"]              = "Deze activiteit is vol.";
$vocab["confirm_del_registrant"]  = "Weet je zeker dat je de aanmelding van '%s' wilt verwijderen?";

// Used in edit_entry_handler.php
$vocab["error"]              = "Fout";
$vocab["sched_conflict"]     = "Overlappende boeking";
$vocab["conflict"]           = "De nieuwe boeking overlapt de volgende boeking(en):";
$vocab["no_conflicts"]           = "Geen overlappende boekingen";
$vocab["rules_broken"]       = "De nieuwe boeking is in strijd met de volgende regels:";
$vocab["rules_broken_notices"]   = "[Alleen voor informatie] De nieuwe boeking zal conflicteren met de volgende regels:";
$vocab["no_rules_broken"]        = "Geen conflicterende regels";
$vocab["schedule"]               = "Planning";
$vocab["policy"]                 = "Regels";
$vocab["conflicts_with_self"]    = "Deze reeks bevat boekingen die overlappen met elkaar. Controleer de boekingseinddatum en de einddatum van de reeks.";
$vocab["too_many_entries"]   = "Een reeks kan niet meer dan %d boekingen bevatten";
$vocab["returncal"]          = "Terug naar kalenderweergave";
$vocab["failed_to_acquire"]  = "Het is niet gelukt om exclusive toegang tot de database te verkrijgen"; 
$vocab["invalid_booking"]    = "Verkeerde boeking";
$vocab["must_set_description"] = "Er moet een korte omschrijving worden gegeven. Ga terug een en geef korte omschrijving.";
$vocab["no_rooms_selected"]      = "Je moet een ruimte kiezen.";
$vocab["mail_subject_approved"]  = "Boeking goedgekeurd voor %s MRBS"; // $mrbs_company
$vocab["mail_subject_rejected"]  = "Boeking afgewezen voor %s MRBS"; // $mrbs_company
$vocab["mail_subject_more_info"] = "%s MRBS: meer informatie nodig"; // $mrbs_company
$vocab["mail_subject_reminder"]  = "Herinnering voor %s MRBS"; // $mrbs_company
$vocab["mail_body_approved"]     = "Een boeking is goedgekeurd door de beheerders; hier zijn de details:";
$vocab["mail_body_rej_entry"]    = "Een boeking is afgewezen door de beheerders, hier zijn de details:";
$vocab["mail_body_more_info"]    = "De beheerders hebben meer informatie nodig over de boeking; hier zijn de details:";
$vocab["mail_body_reminder"]     = "Herinnering - een boeking wacht op goedkeuring; hier zijn de details:";
$vocab["mail_body_repeats_booked"]   = "De volgende data waren geboekt:";
$vocab["mail_body_repeats_deleted"]  = "De volgende boekingen zijn verwijderd:";
$vocab["mail_body_exceptions"]       = "De volgende data kunnen niet worden geboekt door conflicten:";
$vocab["mail_subject_new_entry"]     = "Boeking toegevoegd voor %s MRBS"; // $mrbs_company
$vocab["mail_subject_changed_entry"] = "Boeking aangepast voor %s MRBS"; // $mrbs_company
$vocab["mail_subject_delete"]        = "Boeking verwijderd voor %s MRBS"; // $mrbs_company
$vocab["mail_body_new_entry"]     = "Er is een nieuwe boeking geplaatst door %s, dit zijn de details:";
$vocab["mail_body_changed_entry"] = "Een boeking is gewijzigd door %s, dit zijn de details:";
$vocab["mail_body_del_entry"]     = "Er is een boeking verwijderd door %s, dit zijn de details:";
$vocab["new_value"]               = "Nieuw";
$vocab["old_value"]               = "Oud";
$vocab["reason"]              = "Reden";
$vocab["info_requested"]      = "Informatie nodig";
$vocab["cannot_change_approved_bookings"] = "Boekingen die zijn goedgekeurd kunnen niet worden bewerkt of verwijderd";
$vocab["no_simultaneous_bookings"]        = "Je kunt geen boekingen doen voor twee verschillende ruimtes op dezelfde tijd";
$vocab["no_bookings_on_holidays"] = "Je hebt geprobeerd om een boeking te doen in een vakantie (%s)";
$vocab["no_bookings_on_weekends"] = "Je hebt geprobeerd om een boeking te doen op een weekenddag (%s)";
$vocab["type_not_allowed"]        = 'Boekingen van soort %1$s zijn niet toegestaan in %2$s';
$vocab["min_create_time_before"]  = 'Je kunt geen boeking maken die start binnen %1$d %2$s';
$vocab["max_create_time_before"]  = 'Je kunt geen boeking maken die eindigt later dan %1$d %2$s';
$vocab["max_create_time_before_start"]  = 'Je kunt geen boeking maken die start later dan %1$d %2$s';
$vocab["min_delete_time_before"]  = 'Je kunt geen boeking bewerken of verwijderen die start binnen  %1$d %2$s';
$vocab["max_delete_time_before"]  = 'Je kunt geen boeking bewerken of verwijderen die eindigt later dan %1$d %2$s';
$vocab["max_delete_time_before_start"]  = 'Je kunt geen boeking bewerken of verwijderen die start later dan %1$d %2$s';
$vocab["earliest_booking_date"]   = "De vroegste boekingdatum is %s";
$vocab["latest_booking_date"]     = "De laatste boekingsdatum is %s";
$vocab["max_booking_duration"]    = "De maximale duur van de boeking is";
$vocab["max_per_day_global"]      = "Het maximale aantal boekingen per dag per gebruiker in het hele systeem is";
$vocab["max_per_week_global"]     = "Het maximale aantal boekingen per week per gebruiker in het hele systeem is";
$vocab["max_per_month_global"]    = "Het maximale aantal boekingen per maand per gebruiker in het hele systeem is";
$vocab["max_per_year_global"]     = "Het maximale aantal boekingen per jaar per gebruiker in het hele systeem is";
$vocab["max_per_future_global"]   = "Het maximale aantal openstaande boekingen per gebruiker in het hele systeem is";
$vocab["max_per_day_area"]        = "Het maximale aantal boekingen per dag per gebruiker in dit gebouw is";
$vocab["max_per_week_area"]       = "Het maximale aantal boekingen per week per gebruiker in dit gebouw is";
$vocab["max_per_month_area"]      = "Het maximale aantal boekingen per maand per gebruiker in dit gebouw is";
$vocab["max_per_year_area"]       = "Het maximale aantal boekingen per jaar per gebruiker in dit gebouw is";
$vocab["max_per_future_area"]     = "Het maximale aantal openstaande boekingen per gebruiker in dit gebouw is";
$vocab["max_secs_per_day_global"]     = 'De maximale totale lengte van boekingen per dag per gebruiker in het hele systeem is %1$s %2$s';  // eg 2 hours
$vocab["max_secs_per_week_global"]    = 'De maximale totale lengte van boekingen per week per gebruiker in het hele systeem is %1$s %2$s';
$vocab["max_secs_per_month_global"]   = 'De maximale totale lengte van boekingen per maand per gebruiker in het hele systeem is %1$s %2$s';
$vocab["max_secs_per_year_global"]    = 'De maximale totale lengte van boekingen per jaar per gebruiker in het hele systeem is %1$s %2$s';
$vocab["max_secs_per_future_global"]  = 'De maximale totale lengte van openstaande boekingen per gebruiker in het hele systeem is %1$s %2$s';
$vocab["max_secs_per_day_area"]       = 'De maximale totale lengte van boekingen per dag per gebruiker in dit gebouw is %1$s %2$s';
$vocab["max_secs_per_week_area"]      = 'De maximale totale lengte van boekingen per week per gebruiker in dit gebouw is %1$s %2$s';
$vocab["max_secs_per_month_area"]     = 'De maximale totale lengte van boekingen per maand per gebruiker in dit gebouw is %1$s %2$s';
$vocab["max_secs_per_year_area"]      = 'De maximale totale lengte van boekingen per jaar per gebruiker in dit gebouw is %1$s %2$s';
$vocab["max_secs_per_future_area"]    = 'De maximale totale lengte van openstaande boekingen per gebruiker in dit gebouw is %1$s %2$s';
$vocab["skip_and_book"]           = "Overslaan en boeken";
$vocab["skip_and_book_note"]      = "Doorgaan met de boeking en sla de conflicterende boekingen over";

// Used in kiosk.php
$vocab["enter"]                     = "Starten";
$vocab["exit"]                      = "Verlaten";
$vocab["enter_kiosk_intro"]         = "Stel een wachtwoord in die nodig is om de kiosk-modus af te sluiten.";
$vocab["exit_kiosk_intro"]          = "Voer het wachtwoord in dat je hebt ingesteld toen je de kiosk-modus hebt gestart.";
$vocab["enter_kiosk_mode"]          = "Start Kiosk-modus";
$vocab["exit_kiosk_mode"]           = "Verlaat Kiosk-modus";
$vocab["kiosk"]                     = "Kiosk";
$vocab["kiosk_password"]            = "Kiosk-wachtwoord";

// Used in pending.php
$vocab["pending"]            = "Openstaande boekingen, wachten op goedkeuring";
$vocab["none_outstanding"]   = "Er zijn geen openstaande boekingen die wachten op goedkeuring.";

// Authentication stuff
$vocab["accessdenied"]       = "Geen Toegang";
$vocab["norights"]           = "U heeft geen rechten om deze boeking aan te passen.";
$vocab["please_login"]       = "Inloggen A.U.B.";
$vocab["users.name"]          = "Gebruikersnaam";
$vocab["users.display_name"]        = "Naam";
$vocab["users.password"]      = "Wachtwoord";
$vocab["users.level"]         = "Rechten";
$vocab["users.timestamp"]           = "Laatst aangepast";
$vocab["users.last_login"]          = "Laatste inlog";
$vocab["unknown_user"]       = "Onbekende gebruiker";
$vocab["login"]              = "Inloggen";
$vocab["logoff"]             = "Uitloggen";
$vocab["username_or_email"]  = "Gebruikersnaam of e-mailadres";
$vocab["lost_password"]             = "Wachtwoord vergeten?";
$vocab["get_new_password"]          = "Nieuw wachtwoord aanvragen";
$vocab["password_reset"]            = "Wachtwoordreset";
$vocab["password_reset_subject"]    = "Wachtwoordreset verzoek";
$vocab["password_reset_body"]       = 'Iemand heeft een wachtwoordresetverzoek gedaan voor %3$s. ' .
                            'Als u dit niet was, kunt u deze e-mail negeren. Anders moet u de onderstaande link ' .
                            'volgen om uw wachtwoord opnieuw in te stellen. De link verloopt over %1$d %2$s.';
$vocab["enter_username"]            = "Voer uw gebruikersnaam hierin.";
$vocab["enter_username_or_email"]   = "Voer uw gebruikersnaam of e-mailadres hierin.";
$vocab["will_be_sent_instructions"] = "Er wordt een e-mailbericht gestuurd met instructies hoe je jouw wachtwoord reset. " .
    "Als je geen e-mailadres hebt moet je contact opnemen met de beheerder.";
$vocab["reset_password"]            = "Reset wachtwoord";
$vocab["pwd_check_email"]           = "Bedankt. Als er een gebruiker overeenkomt met deze gegevens dan zul je " .
                            "binnenkort een e-mail met instructies voor het resetten van je wachtwoord ontvangen. " .
                            "Vergeet niet om ook spam/junk map te controleren als het niet lijkt aan te komen.";
$vocab["invalid_link"]              = "Ongeldige link";
$vocab["pwd_request_failed"]        = "Er kon geen e-mail verstuurd worden naar deze gebruiker.";
$vocab["link_invalid"]              = "De wachtwoordresetlink is ongeldig of verlopen.";
$vocab["enter_new_password"]        = "Voer hieronder je nieuwe wachtwoord twee keer in.";
$vocab["pwd_must_contain"]          = "Het wachtwoord moet ten minste bevatten:";
$vocab["pwd_reset_success"]         = "Je wachtwoord is succesvol vernieuwd.";

// Database upgrade code
$vocab["database_login"]           = "Database login";
$vocab["upgrade_required"]         = "Om de update af te ronden heeft de database een upgrade nodig. Maak aub een backup van de database voordat verder wordt gegaan.";
$vocab["supply_userpass"]          = "Geef aub een databasegebruikernaam en -wachtwoord met beheerrechten.";
$vocab["contact_admin"]            = "Als u geen MRBS-beheerder bent, neem dan aub contact op met uw systeembeheerder.";  // $mrbs_admin
$vocab["upgrading_site"]           = "Upgraden site '%s'";  // site name
$vocab["upgrading_main_site"]      = "Upgraden van de hoofdsite";
$vocab["no_tables_found"]          = "Geen tabellen gevonden";
$vocab["upgrade_to_version"]       = "Upgraden naar database versie";
$vocab["upgrade_to_local_version"] = "Upgraden naar lokale versie database";
$vocab["upgrade_completed"]        = "Databaseupgrade compleet.";

// User access levels
$vocab["level_0"]            = "geen";
$vocab["level_1"]            = "gebruiker";
$vocab["level_2"]            = "beheerder";
$vocab["level_3"]            = "gebruiker beheerder";

// Authentication database
$vocab["user_list"]          = "Gebruikerslijst";
$vocab["edit_user"]          = "Gebruiker aanpassen";
$vocab["delete_user"]        = "Deze gebruiker verwijderen";
//$vocab["users.name"]         = Use the same as above, for consistency.
//$vocab["users.password"]     = Use the same as above, for consistency.
$vocab["users.email"]         = "E-mailadres";
$vocab["password_twice"]     = "Als u het wachtwoord wilt wijzigen dient u het nieuwe wachtwoord tweemaal in te voeren.";
$vocab["passwords_not_eq"]   = "Fout: De wachtwoorden komen niet overeen.";
$vocab["password_invalid"]   = "Het wachtwoord voldoet niet aan de eisen. Het moet tenminste bevatten:";
$vocab["policy_length"]      = "%d teken(s)";
$vocab["policy_alpha"]       = "%d letter(s)";
$vocab["policy_lower"]       = "%d kleine letter(s)";
$vocab["policy_upper"]       = "%d hoofdletter(s)";
$vocab["policy_numeric"]     = "%d cijfer(s)";
$vocab["policy_special"]     = "%d leesteken(s)";
$vocab["add_new_user"]       = "Nieuwe gebruiker toevoegen";
$vocab["action"]             = "Handelingen";
$vocab["user"]               = "Gebruiker";
$vocab["administrator"]      = "Beheerder";
$vocab["unknown"]            = "Onbekend";
$vocab["ok"]                 = "OK";
$vocab["show_my_entries"]    = "Klikken om al mijn aankomende boekingen te tonen.";
$vocab["no_users_initial"]   = "Welkom bij het MRBS!";
$vocab["no_users_create_first_admin"] = "Voordat je iets anders kunt doen is het nodig om een beheerder aan te maken. Vervolgens log je in als die gebruiker en maak je meer gebruikers en defineer je gebouwen en ruimtes.";
$vocab["warning_last_admin"] = "Let op! Dit is de laatste beheerder en u kunt deze daarom niet verwijderen of de rechten weghalen, anders kunt u niet meer in het systeem komen.";

// Used in search.php
$vocab["copy_email_addresses"]  = "Kopieer de e-mailadressen";
$vocab["invalid_search"]     = "Niet bestaand of ongeldig zoekargument.";
$vocab["search_results"]     = 'Zoekresultaten voor \'%1$s\' vanaf %2$s';
$vocab["search_results_unlimited"] = "Zoekresultaten voor '%s'";
$vocab["nothing_found"]      = "Geen resultaten voor uw zoekopdracht gevonden.";
$vocab["records"]            = "Boekingregels ";
$vocab["through"]            = " tot en met ";
$vocab["of"]                 = " van ";
$vocab["previous"]           = "Vorige";
$vocab["next"]               = "Volgende";
$vocab["entry"]              = "Boeking";
$vocab["search_button"]      = "Zoeken";
$vocab["search_for"]         = "Zoeken naar";
$vocab["from"]               = "Vanaf";

// Used in report.php
$vocab["report_on"]          = "Boekingsoverzicht";
$vocab["report_start"]       = "Startdatum overzicht";
$vocab["report_end"]         = "Einddatum overzicht";
$vocab["match_area"]         = "Gebouw als";
$vocab["match_room"]         = "Ruimte als";
$vocab["match_type"]         = "Soort als";
$vocab["ctrl_click_type"]    = "Gebruik Ctrl-klik om meer dan 1 soort te selecteren";
$vocab["match_entry"]        = "Korte omschrijving als";
$vocab["match_descr"]        = "Volledige omschrijving als";
$vocab["output"]             = "Uitvoer";
$vocab["summary"]            = "Samenvatting";
$vocab["format"]             = "Formaat";
$vocab["html"]               = "HTML";
$vocab["csv"]                = "CSV";
$vocab["ical"]               = "iCalendar (.ics-bestand) - periodes uitsluiten";
$vocab["combination_not_supported"] = "Deze uitvoer wordt niet ondersteund in dit formaat";
$vocab["summarize_by"]       = "Samenvatten volgens";
$vocab["sum_by_descrip"]     = "Korte omschrijving";
$vocab["sum_by_creator"]     = "Boeker";
$vocab["sum_by_type"]        = "Type";
$vocab["entry_found"]        = "boeking gevonden";
$vocab["entries_found"]      = "boekingen gevonden";
$vocab["summary_header"]     = "Totaal aan (geboekte) uren";
$vocab["summary_header_per"] = "Samenvatting van (Boekingen) Periodes";
$vocab["summary_header_both"]   = "Samenvatting van (Boekingen) uren/Periodes";
$vocab["entries"]            = "boekingen";
$vocab["total"]              = "Totaal";
$vocab["submitquery"]        = "Rapport maken";
$vocab["sort_rep"]           = "Rapport sorteren op";
$vocab["sort_rep_time"]      = "Startdatum/tijd";
$vocab["sort_room"]             = "Ruimte";
$vocab["fulldescription_short"] = "Volledige omschrijving";
$vocab["both"]                  = "Alles";
$vocab["with"]                  = "Met";
$vocab["without"]               = "Zonder";
$vocab["privacy_status"]        = "Privacy status";
$vocab["search_criteria"]       = "Zoekcriteria";
$vocab["presentation_options"]  = "Presentatiemogelijkheden";
$vocab["delete_entries"]        = "Verwijder boekingen";
$vocab["delete_entries_warning"] = "WAARSCHUWING!  Dit zal alle boekingen verwijderen die overeenkomen met de zoekterm. Deze actie kan niet ongedaan worden gemaakt. Ben je zeker dat je verder wilt gaan?\n\n" .
    "Totale aantal boekingen dat zal worden verwijded: %%s"; // The % sign is escaped because the string substitution is done by JavaScript
$vocab["delete_entries_failed"] = "De boekingen konden niet worden verwijderd.";
$vocab["registered"]            = "Aangemeld";
$vocab["na"]                    = "[N/B]";
$vocab["compound_name"]            = '%1$s (%2$s)';  // 1: username, 2: display name
$vocab["registrant_registered_by"] = '%1$s (door %2$s)';  // 1: Registrant, 2: Registered by
$vocab["registrant_username_and_registered_by"] = '%1$s (%2$s) (door %3$s)';  // 2: Registrant username, 2: Registrant display name, 3: Registered by

// Used in admin.php
$vocab["edit"]               = "Wijzig";
$vocab["delete"]             = "Verwijder";
$vocab["rooms"]              = "Ruimtes";
$vocab["in"]                 = "in";
$vocab["noareas"]            = "Er zijn geen gebouwen gedefineerd.";
$vocab["noareas_enabled"]    = "Er zijn geen gebouwen geactiveerd.";
$vocab["addarea"]            = "Gebouw toevoegen";
$vocab["name"]               = "Naam";
$vocab["noarea"]             = "Geen gebouw geselecteerd";
$vocab["browserlang"]        = "Uw browser staat op de volgende taalvoorkeursvolgorde";
$vocab["addroom"]            = "Ruimte toevoegen";
$vocab["capacity"]           = "Zitplaatsen";
$vocab["norooms"]            = "Er zijn geen ruimtes gedefineerd.";
$vocab["norooms_enabled"]    = "Er zijn geen ruimtes geactiveerd.";
$vocab["administration"]     = "Ruimtedetails";
$vocab["invalid_area_name"]  = "Deze naam voor een gebouw is al gebruikt!";
$vocab["empty_name"]         = "Er is geen naam ingevoerd!";

// Used in edit_area.php and/or edit_room.php
$vocab["editarea"]           = "Gebouw wijzigen";
$vocab["change"]             = "Wijzigen";
$vocab["editroom"]           = "Ruimte wijzigen";
$vocab["viewroom"]           = "Ruimte bekijken";
$vocab["not_found"]          = " niet gevonden";
$vocab["room_admin_email"]   = "Ruimtebeheer e-mail";
$vocab["area_admin_email"]   = "Gebouwbeheer e-mail";
$vocab["area_first_slot_start"]   = "Start van eerste slot";
$vocab["area_last_slot_start"]    = "Start van laatste slot";
$vocab["area_res_mins"]           = "Stappen (minuten)";
$vocab["area_def_duration_mins"]  = "Standaard duur (minuten)";
$vocab["times_along_top"]         = "Tijden langs de bovenzijde";
$vocab["invalid_area"]            = "Verkeerd gebouw!";
$vocab["invalid_room"]            = "Verkeerde ruimte!";
$vocab["invalid_room_name"]       = "Deze ruimtenaam is al gebruikt in dit gebouw!";
$vocab["invalid_email"]           = "Ongeldig e-mailadres !";
$vocab["invalid_time_format"]     = "Tijden moeten in het formaat 'uu:mm'";
$vocab["invalid_resolution"]      = "Verkeerde combinatie van eerste slot, laatste slot en stappen!";
$vocab["general_settings"]        = "Algemeen";
$vocab["time_settings"]           = "Tijdslots";
$vocab["period_settings"]         = "Periodenamen";
$vocab["add_period"]              = "Periode toevoegen";
$vocab["confirmation_settings"]   = "Bevestiging-instellingen";
$vocab["allow_confirmation"]      = "Sta voorlopige boekingen toe";
$vocab["default_settings_conf"]   = "Standaardinstelling";
$vocab["default_confirmed"]       = "Bevestigd";
$vocab["default_tentative"]       = "Voorlopig";
$vocab["approval_settings"]       = "Goedkeuring-instellingen";
$vocab["enable_approval"]         = "Vereist goedkeuring voor boekingen";
$vocab["enable_reminders"]        = "Sta gebruikers toe de beheerder te herinneren";
$vocab["private_settings"]        = "Privacy-instellingen";
$vocab["allow_private"]           = "Sta privé boekingen toe";
$vocab["force_private"]           = "Forceer privé boekingen";
$vocab["default_settings"]        = "Standaard/geforceerde instellingen";
$vocab["default_private"]         = "Privé";
$vocab["default_public"]          = "Openbaar";
$vocab["private_display"]         = "Privacy-instellingen (presentatie)";
$vocab["private_display_label"]   = "Hoe moeten privé boekingen worden getoond?";
$vocab["private_display_caution"] = "WAARSCHUWING: Denk goed na over de gevolgen voor de privacy voor de instellingen aan te passen!";
$vocab["treat_respect"]           = "Respecteer de privacy-instellingen voor de boeking";
$vocab["treat_private"]           = "Behandel alle boekings als privé, negeer de privacy-instellingen";
$vocab["treat_public"]            = "Behandel alle boekings als openbaar, negeer de privacy-instellingen";
$vocab["sort_key"]                = "Sorteervolgorde";
$vocab["sort_key_note"]           = "Deze volgorde wordt gebruikt bij het sorteren van ruimtes";
$vocab["booking_policies"]        = "Boekingsregels";
$vocab["booking_creation"]        = "Aanmaken van boekingen";
$vocab["booking_deletion"]        = "Verwijderen van boekingen";
$vocab["booking_limits"]          = "Limieten op het aantal boekingen";
$vocab["booking_limits_secs"]     = "Limieten op de totale lengte van boekingen (alleen voor Tijd-modus)";
$vocab["booking_durations"]       = "Limieten op de tijdsduur van boekingen";
$vocab["max_duration"]            = "Maximale tijdsduur";
$vocab["min_book_ahead"]          = "Vooruit boeken - minimum";
$vocab["max_book_ahead"]          = "Vooruit boeken - maximum";
$vocab["this_area"]               = "Dit gebouw";
$vocab["whole_system"]            = "Hele systeem";
$vocab["whole_system_note"]       = "De waardes voor het hele systeem zijn ingesteld in het configuratiebestand";
$vocab["max_per_day"]             = "Maximum aantal per dag";
$vocab["max_per_week"]            = "Maximum aantal per week";
$vocab["max_per_month"]           = "Maximum aantal per maand";
$vocab["max_per_year"]            = "Maximum aantal per jaar";
$vocab["max_per_future"]          = "Maximum aantal in de toekomst";
$vocab["max_secs_per_day"]        = "Maximum tijd per day";
$vocab["max_secs_per_week"]       = "Maximum tijd per week";
$vocab["max_secs_per_month"]      = "Maximum tijd per maand";
$vocab["max_secs_per_year"]       = "Maximum tijd per jaar";
$vocab["max_secs_per_future"]     = "Maximum tijd in de toekomst";
$vocab["custom_html"]             = "Aangepaste HTML";
$vocab["custom_html_note"]        = "Dit veld kan worden gebuikt om uw eigen HTML te tonen, bijvoorbeeld een embedded Google map";
$vocab["email_list_note"]         = "Geef een lijst met e-mailadressen gescheiden door komma's or nieuwe regels";
$vocab["mode"]                    = "Modus";
$vocab["mode_periods"]            = "Periodes";
$vocab["mode_times"]              = "Tijden";
$vocab["times_only"]              = "Alleen gebruik van Tijden";
$vocab["enabled"]                 = "Actief";
$vocab["disabled"]                = "Non-actief";
$vocab["disabled_area_note"]      = "Als een gebouw op 'non-actief' staat, zal deze niet worden weergegeven in de kalenderweergaves en het zal niet mogelijk zijn om er ruimtes te boeken. Echter bestaande boekingen blijven behouden en zullen zichtbaar zijn in zoek- en rapportageresultaten.";
$vocab["disabled_room_note"]      = "Als een ruimte op 'non-actief' staat, zal die niet verschijnen in de kalenderweergaves en zal het niet mogelijk zijn om die te boeken. Echter bestaande boekingen blijven behouden en zullen zichtbaar zijn in zoek- en rapportageresultaten.";
$vocab["book_ahead_note_periods"] = "Als er periodes gebruikt worden, worden de tijden bij vooruit boeken naar beneden afgerond naar de eerst hele dag.";
$vocab["invalid_types"]           = "Ongeldige soorten";
$vocab["invalid_types_note"]      = "Deze soorten zijn niet toegestaan in deze ruimte.";
$vocab["select_note"]             = "Gebruik Ctrl-klik om een optie te (de)selecteren";

// Used in edit_users.php
$vocab["name_empty"]          = "U moet een naam invoeren.";
$vocab["name_not_unique"]     = "bestaat al. Kies aub een andere naam.";
$vocab["invalid_date"]        = "Het veld '%s' moet een geldige datum bevatten in het formaat JJJJ-MM-DD.";
$vocab["confirm_delete_user"] = "Weet je zeker dat je deze gebruiker wilt verwijderen?";

// Used in del.php
$vocab["deletefollowing"]    = "U gaat hiermee de volgende boekingen verwijderen";
$vocab["and_n_more"]         = "en %s meer";  // %s rather than %d because n is the output of number_format()
$vocab["sure"]               = "Weet U het zeker?";
$vocab["YES"]                = "JA";
$vocab["NO"]                 = "NEE";
$vocab["delarea"]            = "U moet alle ruimtes in dit gebouw verwijderen voordat U het kunt verwijderen<p>";

// Used in help.php
$vocab["about_mrbs"]              = "Over MRBS";
$vocab["mrbs_version"]            = "MRBS versie";
$vocab["db_schema_version"]       = "Database schemaversie";
$vocab["db_local_schema_version"] = "Database lokale schemaversie";
$vocab["config_details"]          = "Configuratiedetails";
$vocab["server_details"]          = "Serverdetails";
$vocab["database"]                = "Database";
$vocab["system"]                  = "Systeem";
$vocab["servertime"]              = "Datum en tijd op de server";
$vocab["server_software"]         = "Serversoftware";
$vocab["extensions"]              = "Extensies";
$vocab["please_contact"]          = "Neem contact op met %s voor alle vragen die hier niet worden beantwoord.";

// Used in import.php
$vocab["import_icalendar"]            = "Importeer een iCalendar-bestand";
$vocab["source"]                      = "Bron";
$vocab["area_room_settings"]          = "Gebouwen en ruimtes";
$vocab["other_settings"]              = "Andere instellingen";
$vocab["import_intro"]                = "Dit formulier laat je een RFC 5545 compliant iCalendar importeren in MRBS vanuit een bestand of URL. Alleen die herhalende activiteiten die een herhaalregel hebben met een gelijke herhaalsoort als MRBS zullen worden geimporteerd.";
$vocab["supported_file_types"]        = "De volgende bestandstypes worden ondersteund:";
$vocab["import_text_file"]            = "niet-gecomprimeerde iCalendar-bestanden";
$vocab["import_zip"]                  = "zip-archieven, inclusief meerdere bestanden in een archief";
$vocab["import_gzip"]                 = "gzip-bestanden";
$vocab["import_bzip2"]                = "bzip2-bestanden";
$vocab["source_type"]                 = "Brontype";
$vocab["file"]                        = "Bestand";
$vocab["file_name"]                   = "Bestand";
$vocab["url"]                         = "URL";
$vocab["invalid_url"]                 = "Ongeldige URL";
$vocab["import"]                      = "Importeer";
$vocab["upload_failed"]               = "Upload mislukt";
$vocab["max_allowed_file_size"]       = "De maximaal toegestane bestandsgrootte is";
$vocab["no_file"]                     = "Geen bestand was geüpload";
$vocab["could_not_process"]           = "Import mislukt: kon bestand niet verwerken";
$vocab["badly_formed_ics"]            = "VCALENDAR-bestand heeft verkeerd formaat";
$vocab["default_room"]                = "Standaardruimte";
$vocab["default_room_note"]           = "De ruimte die gebruikt wordt als er geen LOCATION-veld is gespecificeerd";
$vocab["ignore_location"]             = "Gebruik de standaardruimte in plaats van het LOCATION-veld";
$vocab["add_location"]                = "De LOCATION toevoegen aan de ";
$vocab["expanded_name"]               = '%1$s [%2$s]'; // 1$ - SUMMARY, 2$ - LOCATION
$vocab["expanded_empty_name"]         = '[%s]'; // LOCATION
$vocab["expanded_description"]        = '%1$s [%2$s]'; // 1$ - DESCRIPTION, 2$ - LOCATION
$vocab["expanded_empty_description"]  = '[%s]'; // LOCATION
$vocab["area_room_order"]             = "Volgorde";
$vocab["area_room_order_note"]        = "De volgorde van het gebouw- en de ruimtenamen in het LOCATION-veld";
$vocab["area_room"]                   = "Gebouw-Ruimte";
$vocab["room_area"]                   = "Ruimte-Gebouw";
$vocab["area_room_delimiter"]         = "Scheidingsteken";
$vocab["area_room_delimiter_note"]    = "Het scheidingsteken dat het gebouw- en ruimtenamen scheidt in het LOCATION-veld. Als er geen scheidingsteken is gevonden zal MRBS zoeken naar een unieke ruimte met dezelfde naam als het LOCATION-veld";
$vocab["area_room_create"]            = "Maak nieuwe ruimtes als nodig";
$vocab["import_past"]                 = "Importeer boekingen uit het verleden";
$vocab["default_type"]                = "Standaardsoort";
$vocab["room_does_not_exist_no_area"] = "ruimte bestaat niet en kan niet worden toegevoegd - er is geen gebouw gegeven";
$vocab["room_not_unique_no_area"]     = "ruimtenaam is niet uniek. Kan niet kiezen welke zonder een gebouw.";
$vocab["area_does_not_exist"]         = "Niet-bestaand gebouw:";
$vocab["room_does_not_exist"]         = "Niet-bestaand ruimte:";
$vocab["creating_new_area"]           = "Nieuw gebouw gemaakt:";
$vocab["creating_new_room"]           = "Nieuwe ruimte gemaakt:";
$vocab["could_not_create_area"]       = "Kon geen nieuw gebouw maken";
$vocab["could_not_create_room"]       = "Kon geen nieuwe ruimte maken";
$vocab["could_not_find_room"]         = "Kon geen ruimte vinden";
$vocab["could_not_import"]            = 'Kon niet importeren \'%1$s\' (UID: %2$s)';  // 1$ name, 2$ UID
$vocab["import_no_SUMMARY"]           = "Geïmporteerde activiteit - geen SUMMARY-veld beschikbaar";  // This string cannot be empty
$vocab["no_LOCATION"]                 = "Het VEVENT bevatte geen LOCATION-veld";
$vocab["invalid_RRULE"]               = "Ongeldige RRULE: FREQ deel ontbreekt";
$vocab["more_than_one_BYDAY"]         = "MRBS ondersteunt niet meer dan één BYDAY-waarde als FREQ=";
$vocab["BYDAY_equals_5"]              = "MRBS ondersteunt geen BYDAY-waarde van 5";
$vocab["unsupported_FREQ"]            = "MRBS ondersteunt niet FREQ=";
$vocab["unsupported_COUNT"]           = "COUNT wordt nog niet ondersteunt door MRBS";
$vocab["no_indefinite_repeats"]       = "Herhalingen voor onbepaalde tijd worden nog niet ondersteunt door MRBS";
$vocab["events_imported"]             = "activiteiten geïmporteerd";
$vocab["events_not_imported"]         = "activiteiten niet geïmporteerd";

// Used in DataTables
$vocab["dt_all"]             = "Alle";
$vocab["show_hide_columns"]  = "Kolommen tonen / verbergen";
$vocab["copy"]               = "Kopiëren";
// "csv" already defined above
$vocab["excel"]              = "Excel";
$vocab["pdf"]                = "PDF";
$vocab["print"]              = "Printen";
$vocab["restore_original"]   = "Origineel herstellen";

// Entry types
$vocab["type."]             = "Selecteer aub een soort";
$vocab["type.I"]            = "Intern";
$vocab["type.E"]            = "Extern";

// General
$vocab["fatal_error"]        = "Oeps! Helaas MRBS is een fatale fout tegengekomen. Raadpleeg alstublieft uw systeembeheerder.";
$vocab["resize_error"]       = "Oeps! Helaas MRBS is een fout tegengekomen bij het bewerken van deze boeking. Als dit steeds fout blijft gaan neem aub contact op met uw systeembeheerder.";
$vocab["fatal_db_error"]     = "Fatale fout: helaas is de database niet beschikbaar op dit moment.";
$vocab["fatal_no_tables"]    = "Fatale fout: de MRBS-tabellen bestaan niet of zijn niet toegankelijk.";
$vocab["session_expired"]    = "Je sessie is verlopen.";
$vocab["browser_not_supported"] = "Helaas wordt je browser niet ondersteund door %s. Je zult moeten updaten naar een nieuwere versie, of anders een andere browser moeten gebruiken.";
$vocab["back"]               = "Terug";
