#ifndef __STK_FONT
#define __STK_FONT

#include "stdio.h"
#include "stdlib.h"


struct charTXF;
class Stk_Font;
class Stk_FontTXF;


#include "../kernel/stk_file.h"

#define  FNTMAX_CHAR 256


struct charTXF;



/**  This is a class to manage font. \\
     type: Base class
 */
class Stk_Font
{
public:
        /// constructor
    Stk_Font();
        /// Draw a char 
    virtual void DrawChar(char c,float xi,float yi,float zi) const;
        /// Set the size of font
    virtual void SetSize(float sz);
        /// Get the current size
    virtual float GetSize() const;
    
protected:
    float size;
};





/** This a class to manage TXF font. \\
    inherit from: Stk_Font
 */
class Stk_FontTXF: public Stk_Font,public Stk_File
{
public:
        /// constructor
    Stk_FontTXF(char *name);
        /// Destructor
    virtual ~Stk_FontTXF();
        /// Draw a char (in OpenGL)
    virtual void DrawChar(char c,float xi,float yi,float zi) const;
    
private:
        // SwapInt
    int SwapInt(int);
        // SwapShort
    short SwapShort(short);
        // make the glyph
    void  setGlyph (char,float, float,float, float,
                    float, float,float, float);
    
private:
    int endian;
        // each char has some characteristics
    charTXF *chars;
        // Each font is stocked in a texture
    int texture;
};

/*
  The quadrilaterals that describe the characters
  in the font are drawn with the following texture
  and spatial coordinates. The texture coordinates
  are in (S,T) space, with (0,0) at the bottom left
  of the image and (1,1) at the top-right.

  The spatial coordinates are relative to the current
  'cursor' position. They should be scaled such that
  1.0 represent the height of a capital letter. Hence,
  characters like 'y' which have a descender will be
  given a negative v_bot. Most capitals will have
  v_bot==0.0 and v_top==1.0.
*/

struct charTXF
{
    char exist;
    float t_top;
    float t_bot;
    float t_left;
    float t_right;
    float v_top;
    float v_bot;
    float v_left;
    float v_right;

};




struct Glyph_TXF
{
    unsigned short ch ;
    unsigned char  w  ;
    unsigned char  h  ;
    signed char x_off ;
    signed char y_off ;
    signed char step  ;
    signed char unknown ;
    short x ;
    short y ;
};



#endif
