/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class ClientInterface
 * \headerfile TelepathyQt/client.h <TelepathyQt/Client>
 * \ingroup clientclient
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Client".
 */
class TP_QT_EXPORT ClientInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Client", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Client");
    }

    /**
     * Creates a ClientInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ClientInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of the extra interfaces provided by this client.
     *   This SHOULD include at least one of
     *    \endhtmlonly ClientObserverInterface \htmlonly ,
     *    \endhtmlonly ClientApproverInterface \htmlonly  or
     *    \endhtmlonly ClientHandlerInterface \htmlonly .</p>
     * 
     * <p>In the <code>.client</code> file, this is represented by key
     *   &quot;<code>Interfaces</code>&quot; in the group named after this interface.
     *   The value of the key is a list of interface names each followed by
     *   a semicolon (so it always ends with a semicolon unless it is empty),
     *   i.e. a key of type &quot;strings&quot; as described in the Desktop Entry
     *   specification.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ClientApproverInterface
 * \headerfile TelepathyQt/client.h <TelepathyQt/Client>
 * \ingroup clientclient
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Client.Approver".
 */
class TP_QT_EXPORT ClientApproverInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Client.Approver", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Client.Approver");
    }

    /**
     * Creates a ClientApproverInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientApproverInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientApproverInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientApproverInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientApproverInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ClientApproverInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ClientApproverInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ClientApproverInterface(const Tp::Client::ClientInterface& mainInterface);

    /**
     * Creates a ClientApproverInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ClientApproverInterface(const Tp::Client::ClientInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ApproverChannelFilter of type \c Tp::ChannelClassList.
     *
     * 
     * \htmlonly
     * <p>A specification of the channels in which this approver is
     *   interested. The  \endhtmlonly AddDispatchOperation() \htmlonly 
     *   method should be called by the channel dispatcher whenever at least
     *   one of the channels in a channel dispatch operation matches this
     *   description.</p>
     * 
     * <p>This property works in exactly the same way as the
     *    \endhtmlonly \link ClientObserverInterface::requestPropertyObserverChannelFilter() ClientObserverInterface::ObserverChannelFilter \endlink \htmlonly 
     *   property. In particular, it cannot change while the approver process
     *   continues to own the corresponding Client bus name.</p>
     * 
     * <p>In the .client file, it is represented in the
     *   same way as ObserverChannelFilter, but the group has the same
     *   name as this interface and the keys start with
     *   ApproverChannelFilter instead of ObserverChannelFilter.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyApproverChannelFilter() const
    {
        return internalRequestProperty(QLatin1String("ApproverChannelFilter"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AddDispatchOperation on the remote object.
     * 
     * \htmlonly
     * <p>Called by the channel dispatcher when a ChannelDispatchOperation
     *   in which the approver has registered an interest is created,
     *   or when the approver starts up while such channel dispatch
     *   operations already exist.</p>
     * 
     * <p>The channel dispatcher SHOULD call this method on all approvers
     *   at the same time. If an approver returns an error from this method,
     *   the approver is assumed to be faulty.</p>
     * 
     * <p>If no approvers return from this method
     *   successfully (including situations where there are no matching
     *   approvers at all), the channel dispatcher SHOULD consider this
     *   to be an error, and recover by dispatching the channel to the
     *   most preferred handler.</p>
     * 
     * <div class="rationale">
     *   Processes that aren't approvers (or don't at least ensure that there
     *   is some approver) probably shouldn't be making connections
     *   anyway, so there should always be at least one approver running.
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param channels
     *     
     *     \htmlonly
     *     <p>The initial value of the  \endhtmlonly \link ChannelDispatchOperationInterface::requestPropertyChannels() ChannelDispatchOperationInterface::Channels \endlink \htmlonly 
     *       property, containing the  \endhtmlonly ChannelInterface \htmlonly s
     *       to be dispatched and their properties.</p>
     *     
     *     <div class="rationale">
     *       <p>This can't be signalled to the approver through the Properties
     *         parameter of this method, because Channels is not an immutable
     *         property.</p>
     *     </div>
     *     
     *     <p>This argument always contains all of the channels in the channel
     *       dispatch operation, even if not all of them actually match
     *       the  \endhtmlonly \link requestPropertyApproverChannelFilter() ApproverChannelFilter \endlink \htmlonly .</p>
     *     
     *     <div class="rationale">
     *       <p>This seems the least bad way to handle such a situation;
     *         see the discussion on
     *         <a href="http://bugs.freedesktop.org/show_bug.cgi?id=21090">bug
     *           #21090</a>.</p>
     *     </div>
     *     
     *     <p>The actual channels to be dispatched may reduce as channels are
     *       closed: this is signalled by  \endhtmlonly ChannelDispatchOperationInterface::ChannelLost() \htmlonly .
     *     </p>
     *     
     *     <p>Approvers SHOULD connect to ChannelLost and  \endhtmlonly ChannelDispatchOperationInterface::Finished() \htmlonly .
     *       (if desired) before returning from AddDispatchOperation, since
     *       those signals are guaranteed not to be emitted until after all
     *       AddDispatchOperation calls have returned (with success or failure)
     *       or timed out.</p>
     *     \endhtmlonly
     *
     * \param dispatchOperation
     *     
     *     \htmlonly
     *     <p>The
     *      \endhtmlonly ChannelDispatchOperationInterface \htmlonly 
     *       to be processed.</p>
     *     \endhtmlonly
     *
     * \param properties
     *     
     *     Properties of the channel dispatch operation. The keys MUST be 
     *     fully qualified D-Bus property names. This MUST NOT include 
     *     properties that could change, SHOULD include as many properties as 
     *     possible given that constraint, and MUST include at least the 
     *     Account, Connection and PossibleHandlers properties.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddDispatchOperation(const Tp::ChannelDetailsList& channels, const QDBusObjectPath& dispatchOperation, const QVariantMap& properties, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddDispatchOperation"));
        callMessage << QVariant::fromValue(channels) << QVariant::fromValue(dispatchOperation) << QVariant::fromValue(properties);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ClientHandlerInterface
 * \headerfile TelepathyQt/client.h <TelepathyQt/Client>
 * \ingroup clientclient
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Client.Handler".
 */
class TP_QT_EXPORT ClientHandlerInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Client.Handler", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Client.Handler");
    }

    /**
     * Creates a ClientHandlerInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientHandlerInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientHandlerInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientHandlerInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientHandlerInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ClientHandlerInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ClientHandlerInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ClientHandlerInterface(const Tp::Client::ClientInterface& mainInterface);

    /**
     * Creates a ClientHandlerInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ClientHandlerInterface(const Tp::Client::ClientInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c HandlerChannelFilter of type \c Tp::ChannelClassList.
     *
     * 
     * \htmlonly
     * <p>A specification of the channels that this channel handler can
     *   deal with. It will be offered to approvers as a potential
     *   channel handler for bundles that contain only suitable channels,
     *   or for suitable channels that must be handled separately.</p>
     * 
     * <p>This property works in exactly the same way as the
     *    \endhtmlonly \link ClientObserverInterface::requestPropertyObserverChannelFilter() ClientObserverInterface::ObserverChannelFilter \endlink \htmlonly 
     *   property. In particular, it cannot change while the handler process
     *   continues to own the corresponding Client bus name.</p>
     * 
     * <p>In the .client file, it is represented in the
     *   same way as ObserverChannelFilter, but the group has the same
     *   name as this interface and the keys start with
     *   HandlerChannelFilter instead of ObserverChannelFilter.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHandlerChannelFilter() const
    {
        return internalRequestProperty(QLatin1String("HandlerChannelFilter"));
    }

    /**
     * Asynchronous getter for the remote object property \c BypassApproval of type \c bool.
     *
     * 
     * \htmlonly
     *         <p>If true, channels destined for this handler are automatically
     *           handled, without invoking approvers.</p>
     * 
     *         <div class="rationale">
     *           <p>The intended usage is to allow a client handling one channel to
     *             pick up closely related channels. Suppose a client capable of
     *             handling both Text and StreamedMedia,
     *             <code>org.freedesktop.Telepathy.Client.Empathy</code>, is
     *             handling a StreamedMedia channel. That client can take a second
     *             well-known bus name, say
     *             <code>org.freedesktop.Telepathy.Client.Empathy._1._42.Bundle1</code>,
     *             and configure an object at
     *             <code>/org/freedesktop/Telepathy/Client/Empathy/_1/_42/Bundle1</code>
     *             with BypassApproval = TRUE,
     *             whose  \endhtmlonly \link requestPropertyHandlerChannelFilter() HandlerChannelFilter \endlink \htmlonly 
     *             matches closely related Text channels by their Bundle property.</p>
     *         </div>
     * 
     *         <p>For service-activatable handlers, this property should be specified
     *           in the handler's <tt>.client</tt> file as follows:</p>
     * 
     * <pre>
     * [org.freedesktop.Telepathy.Client.Handler]
     * BypassApproval=true
     * </pre>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyBypassApproval() const
    {
        return internalRequestProperty(QLatin1String("BypassApproval"));
    }

    /**
     * Asynchronous getter for the remote object property \c Capabilities of type \c QStringList.
     *
     * 
     * \htmlonly
     *         <p>The set of additional capabilities supported by this handler.
     *           This describes things like support for streamed media codecs and
     *           NAT traversal mechanisms: see the Contact Capabilities
     *           interface for more details.</p>
     * 
     *         <p>For handlers that have a <code>.client</code> file, the
     *           channel dispatcher may discover this property from the
     *           <code>org.freedesktop.Telepathy.Client.Handler.Capabilities</code>
     *           group; for each capability, that group contains a key
     *           whose name is the capability, with value <code>true</code>.
     *           Keys with other values SHOULD NOT appear in this group.</p>
     * 
     *         <p>For instance, the <code>.client</code> file for a streamed media
     *           handler that supports ICE-UDP NAT traversal, Speex audio,
     *           and Theora and H264 video might contain this group:</p>
     * 
     * <pre>
     * [org.freedesktop.Telepathy.Client.Handler.Capabilities]
     * org.freedesktop.Telepathy.Channel.Interface.MediaSignalling/ice-udp=true
     * org.freedesktop.Telepathy.Channel.Interface.MediaSignalling/audio/speex=true
     * org.freedesktop.Telepathy.Channel.Interface.MediaSignalling/video/theora=true
     * org.freedesktop.Telepathy.Channel.Interface.MediaSignalling/video/h264=true
     * </pre>
     * 
     *         <p>Like the  \endhtmlonly \link requestPropertyHandlerChannelFilter() HandlerChannelFilter \endlink \htmlonly 
     *           property, this property cannot change while the Handler owns its
     *           Client bus name. However, the <code>.client</code> file, if any,
     *           can change (due to upgrades or installation of pluggable codecs),
     *           and the capabilities really supported by the handler might not
     *           exactly match what is cached in the <code>.client</code> file.</p>
     * 
     *         <div class="rationale">
     *           <p>The client file is installed statically and is intended to list
     *             codecs etc. that the handler guarantees it can support (e.g. by
     *             having a hard dependency on them), whereas the running handler
     *             process might be able to find additional codecs.</p>
     *         </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCapabilities() const
    {
        return internalRequestProperty(QLatin1String("Capabilities"));
    }

    /**
     * Asynchronous getter for the remote object property \c HandledChannels of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>A list of the channels that this process is currently handling.</p>
     * 
     * <p>There is no change notification.</p>
     * 
     * <div class="rationale">
     *   <p>This property exists for state recovery - it makes it possible
     *     for channel handling to survive a ChannelDispatcher crash.</p>
     * 
     *   <p>If the channel dispatcher is automatically replaced, the
     *     replacement can discover all Handlers by looking for the Client
     *     well-known bus names, and discover which channels they are
     *     currently handling. Once this has been done, all unhandled
     *     channels can be re-dispatched, and the only issue visible to
     *     the user is that unhandled channels that they have already
     *     approved might be sent back to Approvers.</p>
     * </div>
     * 
     * <p>The value of this property SHOULD be the same for all Client
     *   instances that share a unique bus name, and SHOULD include all
     *   channels that are being handled, even if they were conceptually
     *   handled by a different Client instance.</p>
     * 
     * <div class="rationale">
     *   <p>Otherwise, when a process released a temporary Client name,
     *     channels that it handled because of that Client name would no
     *     longer be state-recoverable.</p>
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHandledChannels() const
    {
        return internalRequestProperty(QLatin1String("HandledChannels"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c HandleChannels on the remote object.
     * 
     * \htmlonly
     * <p>Called by the channel dispatcher when this client should handle these
     *   channels, or when this client should present channels that it is already
     *   handling to the user (e.g. bring them into the foreground).</p>
     * 
     * <div class="rationale">
     *   <p>Clients are expected to know what channels they're already handling,
     *     and which channel object path corresponds to which window or tab.
     *     This can easily be done using a hash table keyed by channels' object
     *     paths.</p>
     * </div>
     * 
     * <p>This method can raise any D-Bus error. If it does, the
     *   handler is assumed to have failed or crashed, and the channel
     *   dispatcher MUST recover in an implementation-specific way; it MAY
     *   attempt to dispatch the channels to another handler, or close the
     *   channels.</p>
     * 
     * <p>If closing the channels, it is RECOMMENDED that the channel
     *   dispatcher attempts to close the channels using
     *    \endhtmlonly ChannelInterface::Close() \htmlonly ,
     *   but resorts to calling
     *    \endhtmlonly ChannelInterfaceDestroyableInterface::Destroy() \htmlonly 
     *   (if available) or ignoring the channel (if not) if the same handler
     *   repeatedly fails to handle channels.</p>
     * 
     * <p>After HandleChannels returns successfully, the client process is
     *   considered to be responsible for the channel until it its unique
     *   name disappears from the bus.</p>
     * 
     * <div class="rationale">
     *   <p>If a process has multiple Client bus names - some temporary and
     *     some long-lived - and drops one of the temporary bus names in order
     *     to reduce the set of channels that it will handle, any channels
     *     that it is already handling should remain unaffected.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param account
     *     
     *     The Account with which the channels are associated. The well-known 
     *     bus name to use is that of the AccountManager.
     *
     * \param connection
     *     
     *     The Connection with which the channels are associated. The 
     *     well-known bus name to use can be derived from this object path by 
     *     removing the leading &apos;/&apos; and replacing all subsequent 
     *     &apos;/&apos; by &apos;.&apos;.
     *
     * \param channels
     *     
     *     The channels and their immutable properties. Their well-known bus 
     *     name is the same as that of the Connection.
     *
     * \param requestsSatisfied
     *     
     *     \htmlonly
     *     <p>The requests satisfied by these channels.</p>
     *     
     *     <div class="rationale">
     *       <p>If the handler implements Requests, this tells it
     *         that these channels match previous  \endhtmlonly ClientInterfaceRequestsInterface::AddRequest() \htmlonly 
     *         calls that it may have received.</p>
     *     
     *       <p>There can be more than one, if they were EnsureChannel
     *         requests.</p>
     *     </div>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     The time at which user action occurred, or 0 if this channel is to 
     *     be handled for some reason not involving user action. Handlers 
     *     SHOULD use this for focus-stealing prevention, if applicable. This 
     *     property has the same semantic as User_Action_Timestamp but is 
     *     unsigned for historical reasons.
     *
     * \param handlerInfo
     *     
     *     \htmlonly
     *     <p>Additional information about these channels. Currently defined
     *       keys are:</p>
     *     
     *     <dl>
     *       <dt><code>request-properties</code> - a{oa{sv}}</dt>
     *       <dd>A map from  \endhtmlonly ChannelRequestInterface \htmlonly 
     *         paths listed in <var>Requests_Satisfied</var> to
     *         <tp:type>Qualified_Property_Value_Map</tp:type>s containing
     *         namespaced immutable properties of each request.</dd>
     *     </dl>
     *     
     *     <p>When more keys are defined for this dictionary, all will be
     *       optional; handlers MAY safely ignore any entry in this
     *       dictionary.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> HandleChannels(const QDBusObjectPath& account, const QDBusObjectPath& connection, const Tp::ChannelDetailsList& channels, const Tp::ObjectPathList& requestsSatisfied, qulonglong userActionTime, const QVariantMap& handlerInfo, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("HandleChannels"));
        callMessage << QVariant::fromValue(account) << QVariant::fromValue(connection) << QVariant::fromValue(channels) << QVariant::fromValue(requestsSatisfied) << QVariant::fromValue(userActionTime) << QVariant::fromValue(handlerInfo);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ClientInterfaceRequestsInterface
 * \headerfile TelepathyQt/client.h <TelepathyQt/Client>
 * \ingroup clientclient
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Client.Interface.Requests".
 */
class TP_QT_EXPORT ClientInterfaceRequestsInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Client.Interface.Requests", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Client.Interface.Requests");
    }

    /**
     * Creates a ClientInterfaceRequestsInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientInterfaceRequestsInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientInterfaceRequestsInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientInterfaceRequestsInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientInterfaceRequestsInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ClientInterfaceRequestsInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ClientInterfaceRequestsInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ClientInterfaceRequestsInterface(const Tp::Client::ClientInterface& mainInterface);

    /**
     * Creates a ClientInterfaceRequestsInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ClientInterfaceRequestsInterface(const Tp::Client::ClientInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c AddRequest on the remote object.
     * 
     * \htmlonly
     * <p>Called by the ChannelDispatcher to indicate that channels have been
     *   requested, and that if the request is successful, they will probably
     *   be handled by this Handler. The ChannelDispatcher SHOULD only
     *   call this method on one handler per request.</p>
     * 
     * <div class="rationale">
     *   <p>This allows the UI to start preparing to handle the channels
     *     in advance (e.g. render a window with an &quot;in progress&quot; message),
     *     improving perceived responsiveness.</p>
     * 
     *   <p>The use of &quot;probably&quot; is because you can't necessarily tell from
     *     a channel request which handler will handle particular channels.
     *     A reasonable heuristic would be to match the request against the
     *      \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly ,
     *     and respect the preferred handler (if any).</p>
     * </div>
     * 
     * <p>If the request succeeds and is given to the expected Handler,
     *   the Requests_Satisfied parameter to
     *    \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *   can be used to match the channel to a previous AddRequest call.</p>
     * 
     * <div class="rationale">
     *   <p>This lets the UI direct the channels to the window that it
     *     already opened.</p>
     * </div>
     * 
     * <p>If the request fails, the expected handler is notified by the
     *   channel dispatcher calling its
     *    \endhtmlonly RemoveRequest() \htmlonly  method.</p>
     * 
     * <div class="rationale">
     *   <p>This lets the UI close the window or display the error.</p>
     * </div>
     * 
     * <p>The channel dispatcher SHOULD remember which handler was notified,
     *   and if the channel request succeeds, it SHOULD dispatch the channels
     *   to the expected handler, unless the channels do not match that
     *   handler's  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly .
     *   If the channels are not dispatched to the expected handler, the
     *   handler that was expected is notified by the channel dispatcher
     *   calling its  \endhtmlonly RemoveRequest() \htmlonly  method
     *   with the NotYours error.</p>
     * 
     * <div class="rationale">
     *   <p>Expected handling is for the UI to close the window it
     *     previously opened.</p>
     * </div>
     * 
     * <p>Handlers SHOULD NOT return an error from this method; errors
     *   returned from this method SHOULD NOT alter the channel dispatcher's
     *   behaviour.</p>
     * 
     * <div class="rationale">
     *   <p>Calls to this method are merely a notification.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param request
     *     
     *     The ChannelRequest object, which MUST have been returned by 
     *     CreateChannel or EnsureChannel before this method is called. See 
     *     those methods for the rationale of this ordering.
     *
     * \param properties
     *     
     *     Some of the properties of the ChannelRequest. To avoid race 
     *     conditions, this dictionary MUST NOT include properties whose 
     *     values could subsequently change. It SHOULD include as many 
     *     properties as possible, given that constraint. In particular, the 
     *     properties Requests, UserActionTime and Account MUST be included, 
     *     and Hints MUST be included if implemented.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddRequest(const QDBusObjectPath& request, const QVariantMap& properties, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddRequest"));
        callMessage << QVariant::fromValue(request) << QVariant::fromValue(properties);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RemoveRequest on the remote object.
     * 
     * \htmlonly
     * <p>Called by the ChannelDispatcher to indicate that a request
     *   previously passed to  \endhtmlonly AddRequest() \htmlonly 
     *   has failed and should be disregarded.</p>
     * 
     * <p>Handlers SHOULD NOT return an error from this method; errors
     *   returned from this method SHOULD NOT alter the channel dispatcher's
     *   behaviour.</p>
     * 
     * <div class="rationale">
     *   <p>Calls to this method are merely a notification.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param request
     *     
     *     The request that failed.
     *
     * \param error
     *     
     *     \htmlonly
     *     <p>The name of the D-Bus error with which the request failed.</p>
     *     
     *     <p>If this is <code>org.freedesktop.Telepathy.Error.NotYours</code>,
     *       this indicates that the request succeeded, but all the resulting
     *       channels were given to some other handler.</p>
     *     \endhtmlonly
     *
     * \param message
     *     
     *     Any message supplied with the D-Bus error.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RemoveRequest(const QDBusObjectPath& request, const QString& error, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RemoveRequest"));
        callMessage << QVariant::fromValue(request) << QVariant::fromValue(error) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ClientObserverInterface
 * \headerfile TelepathyQt/client.h <TelepathyQt/Client>
 * \ingroup clientclient
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Client.Observer".
 */
class TP_QT_EXPORT ClientObserverInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Client.Observer", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Client.Observer");
    }

    /**
     * Creates a ClientObserverInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientObserverInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientObserverInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ClientObserverInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ClientObserverInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ClientObserverInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ClientObserverInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ClientObserverInterface(const Tp::Client::ClientInterface& mainInterface);

    /**
     * Creates a ClientObserverInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ClientObserverInterface(const Tp::Client::ClientInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c ObserverChannelFilter of type \c Tp::ChannelClassList.
     *
     * 
     * \htmlonly
     *         <p>A specification of the channels in which this observer is
     *           interested. The  \endhtmlonly ObserveChannels() \htmlonly  method
     *           should be called by the channel dispatcher whenever any of the new
     *           channels in a  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly 
     *           signal match this description.</p>
     * 
     *         <p>Only certain D-Bus types have useful semantics for matching like this,
     *           so only certain types are allowed:</p>
     * 
     *         <dl>
     *           <dt>Integers of all sizes, including byte (y, n, q, i, u, x, t)</dt>
     *           <dd>Matched by numeric value, regardless of type (e.g. 42 as a
     *             16-bit signed integer 'n' is considered equal to 42 as a 32-bit
     *             unsigned integer 'u')</dd>
     * 
     *           <dt>Booleans (b)</dt>
     *           <dd>Matched by equality in the obvious way; not considered equal to any
     *             other type</dd>
     * 
     *           <dt>Strings (s)</dt>
     *           <dd>Matched by equality in the obvious way; not considered equal to any
     *             other type</dd>
     * 
     *           <dt>Object paths (o)</dt>
     *           <dd>Matched by equality in the obvious way; not considered equal to any
     *             other type</dd>
     * 
     *         </dl>
     * 
     *         <p>This property never changes while the observer process owns its
     *           Client bus name. For activatable processes, the filter can change
     *           due to an upgrade - the channel dispatcher SHOULD observe changes to
     *           .client files using a mechanism like inotify.</p>
     * 
     *         <div class="rationale">
     *           <p>Not allowing this property to change is a simplification,
     *             particularly for activatable processes (we reject the possibility
     *             that a process with a .client file, when activated, has a filter
     *             that differs from what its .client file said).</p>
     * 
     *           <p>If an Observer wants to add extra channels to its list of
     *             interests at runtime, it can register an additional Client bus name
     *             (for instance, the org.freedesktop.Telepathy.Client.Empathy process
     *             with unique name :1.42 could additionally register
     *             org.freedesktop.Telepathy.Client.Empathy._1_42) with additional
     *             filters. To remove those filters, it can release the bus name;
     *             it could even re-claim the bus name immediately, with different
     *             filters.</p>
     * 
     *           <p>The same principle is applied to Approvers and Handlers.</p>
     *         </div>
     * 
     *         <p>For observers that have a .client file, the channel dispatcher
     *           may discover this property from keys of the form
     *           &quot;<code><em>propertyname</em> <em>type</em></code>&quot;,
     *           in groups in the .client file whose name is the name of this
     *           interface followed by <code>.ObserverChannelFilter</code>,
     *           a space and an ASCII decimal number starting from 0.</p>
     * 
     *         <p>Values in the .client file are encoded in exactly the same way as
     *           the <code>default-<em>p</em></code> keys in .manager files, as
     *           described in the  \endhtmlonly ConnectionManagerInterface \htmlonly  interface (but note that not all
     *           types supported in .manager files can appear in .client files).</p>
     * 
     *         <p>For instance, a .client file for an observer that is only interested
     *           in Text channels, with CONTACT or ROOM handles, that were requested by
     *           a local client:</p>
     * 
     * <pre>
     * [org.freedesktop.Telepathy.Client]
     * Interfaces=org.freedesktop.Telepathy.Client.Observer;
     * 
     * [org.freedesktop.Telepathy.Client.Observer.ObserverChannelFilter 0]
     * org.freedesktop.Telepathy.Channel.ChannelType s=org.freedesktop.Telepathy.Channel.Type.Text
     * org.freedesktop.Telepathy.Channel.TargetHandleType u=1
     * org.freedesktop.Telepathy.Channel.Requested b=true
     * 
     * [org.freedesktop.Telepathy.Client.Observer.ObserverChannelFilter 1]
     * org.freedesktop.Telepathy.Channel.ChannelType s=org.freedesktop.Telepathy.Channel.Type.Text
     * org.freedesktop.Telepathy.Channel.TargetHandleType u=2
     * org.freedesktop.Telepathy.Channel.Requested b=true
     * </pre>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyObserverChannelFilter() const
    {
        return internalRequestProperty(QLatin1String("ObserverChannelFilter"));
    }

    /**
     * Asynchronous getter for the remote object property \c Recover of type \c bool.
     *
     * 
     * \htmlonly
     *         <p>If true, upon the startup of this observer,  \endhtmlonly ClientObserverInterface::ObserveChannels() \htmlonly 
     *         will be called for every already existing channel matching
     *         its  \endhtmlonly \link ClientObserverInterface::requestPropertyObserverChannelFilter() ClientObserverInterface::ObserverChannelFilter \endlink \htmlonly </p>
     * 
     *         <p>When an activatable client having this property disappears from the
     *           bus and there are channels matching its ObserverChannelFilter,
     *           ObserveChannels will be called immediately to reactivate it
     *           again. Such clients should specify this property in their
     *           <tt>.client</tt> file as follows:</p>
     * 
     * <pre>
     * [org.freedesktop.Telepathy.Client.Observer]
     * Recover=true
     * </pre>
     * 
     *         <div class="rationale">
     *           <p>This means that if an activatable Observer crashes, it will
     *             be restarted as soon as possible; while there is an unavoidable
     *             possibility that it will miss some events during this process
     *             (particularly  \endhtmlonly ChannelTypeTextInterface \htmlonly 
     *             messages), this window of event loss is kept to a minimum.</p>
     * 
     *            <p>Non-activatable observers can't take advantage of this
     *             mechanism, but setting this property on a non-activatable
     *             observer does allow it to &quot;catch up&quot; on channels that are
     *             currently active at the time that it starts up.</p>
     *         </div>
     * 
     *         <p>When the ObserveChannels method is called due to observer recovery,
     *         the <var>Observer_Info</var> dictionary will contain one extra item
     *         mapping the key <code>&quot;recovering&quot;</code> to <code>True</code>.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRecover() const
    {
        return internalRequestProperty(QLatin1String("Recover"));
    }

    /**
     * Asynchronous getter for the remote object property \c DelayApprovers of type \c bool.
     *
     * 
     * \htmlonly
     *           <p>If true, the channel dispatcher will wait for
     *              \endhtmlonly ObserveChannels() \htmlonly  to return
     *             before calling  \endhtmlonly ClientApproverInterface::AddDispatchOperation() \htmlonly 
     *             on appropriate Approvers.</p>
     * 
     *           <p>This property SHOULD be false unless there is a reason
     *             why a channel should not be given to approvers. An example
     *             of this is if an Observer is also a Handler and wants to
     *              \endhtmlonly ChannelDispatchOperationInterface::Claim() \htmlonly 
     *             a channel so that it becomes its handler and doesn't want
     *             any approver to be called, this property should be true.</p>
     * 
     *           <p>Observers and Approvers should be called at the same time
     *             in normal operation (with this property set to false) to
     *             improve responsiveness. For example, if an incoming call
     *             appears, the approver should get the channel as fast as
     *             possible to show a dialog, but if an approver has to make
     *             round-trips to set itself up, then the approval of the
     *             channel is delayed. As a result, it is recommended for this
     *             property to remain false unless absolutely necessary.</p>
     * 
     *           <p>For service-activatable clients, this property should be
     *             specified in the observer's <tt>.client</tt> file as
     *             follows:</p>
     * 
     *           <p>If this property is not implemented (telepathy-mission-control
     *             5.7.5 and older), the channel dispatcher SHOULD consider it as
     *             being false.</p>
     * 
     * <pre>
     * [org.freedesktop.Telepathy.Client.Observer]
     * DelayApprovers=true
     * </pre>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDelayApprovers() const
    {
        return internalRequestProperty(QLatin1String("DelayApprovers"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c ObserveChannels on the remote object.
     * 
     * \htmlonly
     * <p>Called by the channel dispatcher when channels in which the
     *   observer has registered an interest are announced in a  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly 
     *   signal.</p>
     * 
     * <p>If the same NewChannels signal announces some channels that match
     *   the filter, and some that do not, then only a subset of the channels
     *   (those that do match the filter) are passed to this method.</p>
     * 
     * <p>If the channel dispatcher will split up the channels from a single
     *   NewChannels signal and dispatch them separately (for instance
     *   because no installed Handler can handle all of them), it will call
     *   ObserveChannels several times.</p>
     * 
     * <p>The observer MUST NOT return from this method call until it is ready
     *   for a handler for the channel to run (which may change the channel's
     *   state).</p>
     * 
     * <div class="rationale">
     *   <p>The channel dispatcher must wait for observers to start up,
     *     to avoid the following race: text channel logger (observer) gets
     *     ObserveChannels, text channel handler gets
     *      \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *     channel handler starts up faster and acknowledges messages,
     *     logger never sees those messages.</p>
     * </div>
     * 
     * <p>The channel dispatcher SHOULD NOT change its behaviour based on
     *   whether this method succeeds or fails: there are no defined D-Bus
     *   errors for this method, and if it fails, this only indicates that
     *   an Observer is somehow broken.</p>
     * 
     * <div class="rationale">
     *   <p>The expected error response in the channel dispatcher is to
     *     log a warning, and otherwise continue as though this method
     *     had succeeded.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param account
     *     
     *     The Account with which the channels are associated. The well-known 
     *     bus name to use is that of the AccountManager.
     *
     * \param connection
     *     
     *     The Connection with which the channels are associated. The 
     *     well-known bus name to use can be derived from this object path by 
     *     removing the leading &apos;/&apos; and replacing all subsequent 
     *     &apos;/&apos; by &apos;.&apos;.
     *
     * \param channels
     *     
     *     The Channels and their properties. Their well-known bus names are 
     *     all the same as that of the Connection.
     *
     * \param dispatchOperation
     *     
     *     \htmlonly
     *     <p>The path to the  \endhtmlonly ChannelDispatchOperationInterface \htmlonly 
     *       for these channels, or the special value '/' if there is no
     *       ChannelDispatchOperation (because the channels were requested, not
     *       incoming).</p>
     *     
     *     <p>If the Observer calls  \endhtmlonly ChannelDispatchOperationInterface::Claim() \htmlonly 
     *       or  \endhtmlonly ChannelDispatchOperationInterface::HandleWith() \htmlonly 
     *       on the dispatch operation, it MUST be careful to avoid deadlock,
     *       since these methods cannot return until the Observer has returned
     *       from  \endhtmlonly ObserveChannels() \htmlonly .</p>
     *     
     *     <div class="rationale">
     *       <p>This allows an Observer to  \endhtmlonly ChannelDispatchOperationInterface::Claim() \htmlonly 
     *         a set of channels without having to match up calls to this method
     *         with calls to  \endhtmlonly ClientApproverInterface::AddDispatchOperation() \htmlonly .</p>
     *     </div>
     *     \endhtmlonly
     *
     * \param requestsSatisfied
     *     
     *     The ChannelRequests satisfied by these channels. If the same 
     *     process is an Observer and a Handler, it can be useful to be given 
     *     this information as soon as possible (it will also be passed to 
     *     Handler.HandleChannels).
     *
     * \param observerInfo
     *     
     *     \htmlonly
     *     <p>Additional information about these channels. Currently defined
     *       keys are:</p>
     *     
     *     <dl>
     *       <dt><code>recovering</code> - b</dt>
     *       <dd><code>True</code> if ObserveChannels was called for an existing
     *         channel (due to the  \endhtmlonly \link requestPropertyRecover() Recover \endlink \htmlonly 
     *         property being <code>True</code>); <code>False</code> or omitted
     *         otherwise.
     *     
     *         <div class="rationale">
     *           This allows observers to distinguish between new channels (the normal
     *           case), and existing channels that were given to the observer in order
     *           to catch up on previous events (perhaps after a previous instance of
     *           the same observer crashed).
     *         </div>
     *       </dd>
     *     
     *       <dt><code>request-properties</code> - a{oa{sv}}</dt>
     *       <dd>A map from  \endhtmlonly ChannelRequestInterface \htmlonly 
     *         paths listed in <var>Requests_Satisfied</var> to
     *         <tp:type>Qualified_Property_Value_Map</tp:type>s containing
     *         namespaced immutable properties of each request.</dd>
     *     </dl>
     *     
     *     <p>All defined keys for this dictionary are optional;
     *       observers MAY safely ignore any entry in this dictionary.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ObserveChannels(const QDBusObjectPath& account, const QDBusObjectPath& connection, const Tp::ChannelDetailsList& channels, const QDBusObjectPath& dispatchOperation, const Tp::ObjectPathList& requestsSatisfied, const QVariantMap& observerInfo, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ObserveChannels"));
        callMessage << QVariant::fromValue(account) << QVariant::fromValue(connection) << QVariant::fromValue(channels) << QVariant::fromValue(dispatchOperation) << QVariant::fromValue(requestsSatisfied) << QVariant::fromValue(observerInfo);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::ClientInterface*)
Q_DECLARE_METATYPE(Tp::Client::ClientApproverInterface*)
Q_DECLARE_METATYPE(Tp::Client::ClientHandlerInterface*)
Q_DECLARE_METATYPE(Tp::Client::ClientInterfaceRequestsInterface*)
Q_DECLARE_METATYPE(Tp::Client::ClientObserverInterface*)
