#!/usr/bin/env retro

# Export as HTML

This tool processes the code in Unu code blocks, generating HTML
output. It assumes that CSS will be used to style the results.
The default CSS is included at the end of this file and will be
embedded into the generated HTML.

# Code

I include my `unu` file processor here as it makes it easy to
process the relevant lines from the source file.

Some characters need to be escaped. The `:put-html` words will
be used to handle these.

~~~
:c:put-html
  $< [ '&lt;  s:put ] case
  $> [ '&gt;  s:put ] case
  $& [ '&amp; s:put ] case
  ASCII:SPACE [ '&nbsp; s:put ] case
  c:put ;
:s:put-html [ c:put-html ] s:for-each ;
~~~

~~~
{{
  :span '<span_class='text'> s:put s:put-html '</span> s:put ;
  'Fenced var
  :toggle-fence @Fenced not !Fenced ;
  :fenced? (-f) @Fenced ;
  :handle-line (s-)
    fenced? [ over call ] [ span '<br> s:put nl ] choose ;
---reveal---
  :unu (sq-)
    swap [ dup '~~~ s:eq?
           [ toggle-fence s:put '<br> s:put nl ]
           [ handle-line ] choose
         ] file:for-each-line drop ;
}}
~~~

Formatting is pretty straightforward. I have a `span` word to
generate the HTML for the token, and a `format` word to identify
the token type and use `span`.

~~~
:span '<span_class=' s:put s:put ''> s:put s:put-html '</span> s:put ;

:format (s-)
  (ignore_empty_tokens)
  dup s:length n:zero? [ drop ] if;

  (tokens_with_prefixes)
  dup fetch
  $: [ 'colon     span ] case
  $( [ 'comment   span ] case
  $' [ 'string    span ] case
  $# [ 'number    span ] case
  $& [ 'pointer   span ] case
  $$ [ 'character span ] case
  $` [ 'inst      span ] case
  $| [ 'defer     span ] case
  $@ [ 'fetch     span ] case
  $! [ 'store     span ] case

  (immediate_and_primitives)
  drop dup
  d:lookup d:class fetch
  &class:macro     [ 'immediate span ] case
  &class:primitive [ 'primitive span ] case
  drop

  (normal_words)
  s:put-html ;
~~~

Next is the HTML page generation. This has words to generate
the header, embeds the CSS (from the end of this file), and
then processes the lines in the source file to generate the
body.

Output is written to stdout.

~~~
'CSS var
:embed-css
  '<style> s:put nl
  sys:name [ dup '/*_CSS_Begins_*/ s:eq? [ &CSS v:on ] if
             @CSS [ s:put nl ] [ drop ] choose ] file:for-each-line
  '</style> s:put nl ;

:header
  '<!DOCTYPE_html> s:put nl
  '<html> s:put nl
  '<head> s:put nl embed-css '</head> s:put nl ;

:body (s-)
  '<body> s:put nl
  [ ASCII:SPACE s:tokenize [ format '&nbsp; s:put ] a:for-each
    '<br> s:put nl ] unu
  '</body> s:put nl ;

:footer
  '</html> s:put nl ;

:generate (s-)
  header body footer ;
~~~

And finally, run it.

~~~
#0 sys:argv generate
~~~

# CSS

/* CSS Begins */

* {
  background: #111;
  color: #44dd44;
  font-family: monospace;
}

.text {
  color: white;
}

.colon {
  color: red;
}
.comment {
  color: #888;
}
.string {
  color: yellow;
}
.number {
  color: cyan;
}
.pointer {
  color: mediumorchid;
}
.fetch {
  color: orchid;
}
.store {
  color: orchid;
}
.character {
  color: brown;
}
.inst {
  color: tomato;
}
.defer {
  color: #888;
}

.immediate {
  color: orange;
}

.primitive {
  color: greenyellow;
}
