/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public final class MainClassLoader
extends URLClassLoader {
    private String name;

    public MainClassLoader(String name, ClassLoader parent) {
        this(parent);
        this.name = name;
    }

    public MainClassLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public MainClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public MainClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    synchronized void add(URL url) {
        this.addURL(url);
    }

    synchronized void addJarToClasspath(String jarName) throws MalformedURLException {
        URL url = new File(jarName).toURI().toURL();
        this.addURL(url);
    }

    public static MainClassLoader findAncestor(ClassLoader cl) {
        do {
            if (!(cl instanceof MainClassLoader)) continue;
            return (MainClassLoader)cl;
        } while ((cl = cl.getParent()) != null);
        return null;
    }

    private void appendToClassPathForInstrumentation(String jarfile) throws IOException {
        this.add(Paths.get(jarfile, new String[0]).toRealPath(new LinkOption[0]).toUri().toURL());
    }

    static {
        MainClassLoader.registerAsParallelCapable();
    }
}

