/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingPanel;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.DragControler;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.ShapePainterStrategy;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockingActionDockableEvent;
import com.vlsolutions.swing.docking.event.DockingActionEvent;
import com.vlsolutions.swing.docking.event.DockingActionSimpleStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitDockableContainerEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

abstract class AbstractDragControler
implements DragControler {
    protected Shape dropShape;
    protected boolean isFloatingShape = false;
    protected boolean startDrag;
    protected Point dragPoint;
    protected Point startDragPoint;
    protected boolean ignoreDrag;
    protected DockableDragSource dockableDragSource;
    protected DockDropReceiver dropReceiver;
    protected boolean paintFloatingDragShape = UIManager.getBoolean("FloatingContainer.paintDragShape");
    protected DockingDesktop desktop;
    protected DockingContext dockingContext;
    protected ShapePainterStrategy currentShapePainterStrategy;
    private HashMap<Window, ShapePainterStrategy> shapePainters = new HashMap();

    public AbstractDragControler(DockingDesktop desktop) {
        this.desktop = desktop;
        this.dockingContext = desktop.getContext();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.startDrag = true;
            this.ignoreDrag = false;
        } else if (this.dragPoint != null) {
            this.cancelDrag();
        } else {
            this.ignoreDrag = true;
        }
    }

    private boolean isDragAndDropEnabled() {
        return UIManager.getBoolean("DragControler.isDragAndDropEnabled");
    }

    @Override
    public Dockable getDockable() {
        if (this.dockableDragSource != null) {
            return this.dockableDragSource.getDockable();
        }
        return null;
    }

    @Override
    public DockDropReceiver getDropReceiver() {
        return this.dropReceiver;
    }

    @Override
    public Shape getDropShape() {
        return this.dropShape;
    }

    @Override
    public boolean isFloatingShape() {
        return this.isFloatingShape;
    }

    protected abstract ShapePainterStrategy createShapePainterStrategy(Window var1);

    protected ShapePainterStrategy getShapePainter(Component comp, DockableDragSource source) {
        Window w;
        ShapePainterStrategy newStrategy;
        if (comp == null) {
            comp = this.desktop;
        }
        if ((newStrategy = this.shapePainters.get(w = SwingUtilities.getWindowAncestor(comp))) == null) {
            newStrategy = this.createShapePainterStrategy(w);
            this.shapePainters.put(w, newStrategy);
            if (this.currentShapePainterStrategy != null) {
                this.currentShapePainterStrategy.endDrag();
            }
            this.currentShapePainterStrategy = newStrategy;
            newStrategy.startDrag(source);
            return newStrategy;
        }
        if (newStrategy == this.currentShapePainterStrategy) {
            return newStrategy;
        }
        this.currentShapePainterStrategy.endDrag();
        this.currentShapePainterStrategy = newStrategy;
        newStrategy.startDrag(source);
        return newStrategy;
    }

    @Override
    public void cancelDrag() {
        this.ignoreDrag = true;
        this.dropShape = null;
        this.dockableDragSource = null;
        this.startDrag = true;
        this.dragPoint = null;
        if (this.currentShapePainterStrategy != null) {
            this.currentShapePainterStrategy.endDrag();
        }
        this.clearStrategies();
        this.desktop.repaint();
    }

    private void clearStrategies() {
        Window w = SwingUtilities.getWindowAncestor(this.desktop);
        Window[] owned = w.getOwnedWindows();
        for (int i = 0; i < owned.length; ++i) {
            this.shapePainters.remove(w);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            if (this.dragPoint != null) {
                this.notifyDragSourceDragComplete(false);
                this.cancelDrag();
            }
        } else {
            if (this.ignoreDrag) {
                return;
            }
            try {
                boolean dropped = false;
                if (this.dragPoint != null && this.dockableDragSource != null) {
                    dropped = this.processMouseReleased(e);
                }
                this.notifyDragSourceDragComplete(dropped);
            }
            finally {
                this.notifyDragSourceDragComplete(false);
                this.cancelDrag();
            }
        }
    }

    private void notifyDragSourceDragComplete(boolean isDropped) {
        if (this.dockableDragSource != null) {
            this.dockableDragSource.endDragComponent(isDropped);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isDragAndDropEnabled()) {
            this.ignoreDrag = true;
        }
        if (this.ignoreDrag) {
            return;
        }
        if (this.startDrag) {
            this.startDrag = false;
            this.processDragGestureStart(e);
        } else {
            this.processMouseDragged(e);
        }
    }

    private boolean processMouseReleased(MouseEvent e) {
        DockableDragSource dragSource = (DockableDragSource)e.getSource();
        this.dragPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.desktop);
        UnderMouseInfo umInfo = this.findComponentUnderMouse(e);
        Component underMouse = umInfo.underMouse;
        Component underMouseNullDesktop = null;
        DockingDesktop targetDesktop = umInfo.desktop;
        if (targetDesktop == null) {
            underMouseNullDesktop = this.findDropReceiverOutsideDesktop(underMouseNullDesktop, e);
        }
        ShapePainterStrategy shapePainterStrategy = this.getShapePainter(underMouse, dragSource);
        int dx = this.dragPoint.x - this.startDragPoint.x;
        int dy = this.dragPoint.y - this.startDragPoint.y;
        if (Math.abs(dx) < 20 && Math.abs(dy) < 10) {
            return false;
        }
        if (targetDesktop == null) {
            if (underMouseNullDesktop != null) {
                DockDropEvent event = new DockDropEvent(this.desktop, dragSource, e);
                ((DockDropReceiver)((Object)underMouseNullDesktop)).processDockableDrop(event);
            }
            return false;
        }
        if (targetDesktop.getContext() != this.desktop.getContext()) {
            return false;
        }
        DockingPanel dp = targetDesktop.getDockingPanel();
        Insets i = targetDesktop.getDockingPanelInsets();
        Rectangle deskBounds = new Rectangle(i.left, i.top, targetDesktop.getWidth() - i.left - i.right, targetDesktop.getHeight() - i.top - i.bottom);
        Rectangle innerBounds = new Rectangle(deskBounds);
        innerBounds.x += 5;
        innerBounds.y += 5;
        innerBounds.width -= 10;
        innerBounds.height -= 10;
        if (deskBounds.contains(this.dragPoint) && !innerBounds.contains(this.dragPoint)) {
            underMouse = dp;
        }
        while (underMouse != null && underMouse != targetDesktop && !(underMouse instanceof DockDropReceiver)) {
            underMouse = underMouse.getParent();
        }
        umInfo.underMouse = underMouse;
        if (underMouse == null) {
            DropProcess dropProcess;
            if (underMouse instanceof DockDropReceiver) {
                this.dropReceiver = (DockDropReceiver)((Object)underMouse);
            }
            if ((dropProcess = new DropProcess(e, this.dockableDragSource, umInfo)).canDockableBeDetached() && dropProcess.checkDockableWillBeDetached()) {
                Point location = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(location, e.getComponent());
                dropProcess.setFloating(location);
                return true;
            }
            return false;
        }
        if (underMouse instanceof DockDropReceiver && e.isControlDown()) {
            this.processHotSwap(underMouse, e.getComponent(), null, true);
            return true;
        }
        if (underMouse instanceof DockDropReceiver) {
            DropProcess process = new DropProcess(e, this.dockableDragSource, umInfo);
            DockDragEvent event = process.findAcceptableEvent(e);
            if (event.isDragAccepted() && process.isDockingActionAccepted()) {
                return process.dropIfPossible();
            }
            if (process.canDockableBeDetached() && process.checkDockableWillBeDetached()) {
                Point location = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(location, e.getComponent());
                process.setFloating(location);
                return true;
            }
            return false;
        }
        DropProcess process = new DropProcess(e, this.dockableDragSource, umInfo);
        if (process.canDockableBeDetached() && process.checkDockableWillBeDetached()) {
            Point location = new Point(e.getPoint());
            SwingUtilities.convertPointToScreen(location, e.getComponent());
            process.setFloating(location);
            return true;
        }
        return false;
    }

    protected void processHotSwap(Component underMouse, Component dragged, ShapePainterStrategy shapePainterStrategy, boolean drop) {
        Component topLevel;
        for (topLevel = underMouse; topLevel != null && !(topLevel instanceof DockingPanel); topLevel = topLevel.getParent()) {
        }
        if (topLevel == null) {
            if (!drop) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
            return;
        }
        while (underMouse != null && !(underMouse.getParent() instanceof SplitContainer)) {
            underMouse = underMouse.getParent();
        }
        if (underMouse != null) {
            Component splitChild;
            for (splitChild = dragged; splitChild != null && !(splitChild.getParent() instanceof SplitContainer); splitChild = splitChild.getParent()) {
            }
            if (splitChild != null && splitChild != underMouse && underMouse instanceof DockDropReceiver) {
                if (drop) {
                    DockingUtilities.updateResizeWeights(this.desktop.getDockingPanel());
                    DockingUtilities.swapComponents(splitChild, underMouse);
                    DockingUtilities.updateResizeWeights(this.desktop.getDockingPanel());
                } else {
                    shapePainterStrategy.showSwapDragCursor();
                    Rectangle bounds = underMouse.getBounds();
                    Rectangle2D.Float shape = new Rectangle2D.Float(0.0f, 0.0f, bounds.width, bounds.height);
                    this.dropReceiver = (DockDropReceiver)((Object)underMouse);
                    this.setDropShape(shape, shapePainterStrategy);
                }
            } else if (!drop) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        } else if (!drop) {
            shapePainterStrategy.showStopDragCursor();
            this.setDropShape(null, shapePainterStrategy);
        }
    }

    private void processDragGestureStart(MouseEvent e) {
        DockableDragSource dragSource = (DockableDragSource)e.getSource();
        this.dragPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.desktop);
        this.dropShape = null;
        this.dockableDragSource = null;
        this.startDragPoint = e.getPoint();
        if (dragSource.startDragComponent(this.startDragPoint)) {
            this.dockableDragSource = dragSource;
            this.getShapePainter(e.getComponent(), dragSource).startDrag(dragSource);
            this.startDragPoint = new Point(this.dragPoint);
            this.processMouseDragged(e);
        } else {
            this.ignoreDrag = true;
        }
    }

    protected UnderMouseInfo findComponentUnderMouse(MouseEvent e) {
        Point p = new Point(e.getPoint());
        SwingUtilities.convertPointToScreen(p, e.getComponent());
        UnderMouseInfo umInfo = new UnderMouseInfo();
        Window w = SwingUtilities.getWindowAncestor(this.desktop);
        Window[] children = w.getOwnedWindows();
        for (int i = 0; i < children.length; ++i) {
            Window wChild;
            Rectangle bounds;
            if (!(children[i] instanceof FloatingDockableContainer) || !children[i].isVisible() || !(bounds = (wChild = children[i]).getBounds()).contains(p)) continue;
            Point p2 = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), wChild);
            Container contentPane = wChild instanceof JDialog ? ((JDialog)wChild).getContentPane() : ((JFrame)wChild).getContentPane();
            umInfo.underMouse = this.findComponentAt(contentPane, p2.x, p2.y);
            umInfo.desktop = this.desktop;
        }
        if (umInfo.underMouse == null && this.desktop.getContext().getDesktopList().size() > 1) {
            DockingContext ctx = this.desktop.getContext();
            ArrayList desktops = ctx.getDesktopList();
            ArrayList<Window> windows = new ArrayList<Window>();
            for (int i = 0; i < desktops.size(); ++i) {
                DockingDesktop desk = (DockingDesktop)desktops.get(i);
                Window deskWin = SwingUtilities.getWindowAncestor(desk);
                if (deskWin == null || windows.contains(deskWin) || !deskWin.getBounds().contains(p)) continue;
                windows.add(deskWin);
            }
            Window topWindow = null;
            for (Window win : ctx.getOwnedWindowActionOrder()) {
                if (!windows.contains(win)) continue;
                topWindow = win;
                break;
            }
            if (topWindow != null) {
                Point p2 = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), topWindow);
                Container contentPane = topWindow instanceof JDialog ? ((JDialog)topWindow).getContentPane() : ((JFrame)topWindow).getContentPane();
                for (Component c = umInfo.underMouse = this.findComponentAt(contentPane, p2.x, p2.y); c != null; c = c.getParent()) {
                    if (!(c instanceof DockingDesktop)) continue;
                    umInfo.desktop = (DockingDesktop)c;
                    break;
                }
            }
        }
        if (umInfo.underMouse == null) {
            umInfo.underMouse = this.findComponentAt(this.desktop, this.dragPoint.x, this.dragPoint.y);
            umInfo.desktop = this.desktop;
        }
        return umInfo;
    }

    protected abstract Component findComponentAt(Container var1, int var2, int var3);

    protected Component findDropReceiverOutsideDesktop(Component underMouse, MouseEvent e) {
        Container base = null;
        Window w = SwingUtilities.getWindowAncestor(this.desktop);
        if (w instanceof JFrame) {
            base = ((JFrame)w).getContentPane();
        } else if (w instanceof JDialog) {
            base = ((JDialog)w).getContentPane();
        }
        if (base != null) {
            Point pw = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), base);
            for (underMouse = this.findComponentAt(base, pw.x, pw.y); underMouse != null && !(underMouse instanceof DockDropReceiver); underMouse = underMouse.getParent()) {
            }
        }
        return underMouse;
    }

    protected void processMouseDragged(MouseEvent e) {
        Component dragged = (Component)e.getSource();
        DockableDragSource dragSource = (DockableDragSource)e.getSource();
        this.dragPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.desktop);
        UnderMouseInfo umInfo = this.findComponentUnderMouse(e);
        Component underMouse = umInfo.underMouse;
        Component underMouseNullDesktop = null;
        DockingDesktop targetDesktop = umInfo.desktop;
        if (targetDesktop == null) {
            underMouseNullDesktop = this.findDropReceiverOutsideDesktop(underMouseNullDesktop, e);
        }
        ShapePainterStrategy shapePainterStrategy = this.getShapePainter(underMouse, dragSource);
        if (this.dragPoint == null || this.startDragPoint == null) {
            this.ignoreDrag = true;
            return;
        }
        if (targetDesktop == null) {
            if (underMouseNullDesktop != null) {
                DockDragEvent event = new DockDragEvent(this.desktop, dragSource, e);
                ((DockDropReceiver)((Object)underMouseNullDesktop)).processDockableDrag(event);
            }
            shapePainterStrategy.showStopDragCursor();
            this.setDropShape(null, shapePainterStrategy);
            return;
        }
        if (targetDesktop.getContext() != this.desktop.getContext()) {
            shapePainterStrategy.showStopDragCursor();
            this.setDropShape(null, shapePainterStrategy);
            return;
        }
        int dx = this.dragPoint.x - this.startDragPoint.x;
        int dy = this.dragPoint.y - this.startDragPoint.y;
        if (Math.abs(dx) < 20 && Math.abs(dy) < 10) {
            shapePainterStrategy.showStopDragCursor();
            this.setDropShape(null, shapePainterStrategy);
            return;
        }
        DockingPanel dp = targetDesktop.getDockingPanel();
        Insets i = targetDesktop.getDockingPanelInsets();
        Rectangle deskBounds = new Rectangle(i.left, i.top, targetDesktop.getWidth() - i.left - i.right, targetDesktop.getHeight() - i.top - i.bottom);
        Rectangle innerBounds = new Rectangle(deskBounds);
        innerBounds.x += 5;
        innerBounds.y += 5;
        innerBounds.width -= 10;
        innerBounds.height -= 10;
        if (deskBounds.contains(this.dragPoint) && !innerBounds.contains(this.dragPoint) && underMouse != null && targetDesktop.isAncestorOf(underMouse)) {
            underMouse = dp;
        }
        while (underMouse != null && underMouse != targetDesktop && !(underMouse instanceof DockDropReceiver)) {
            underMouse = underMouse.getParent();
        }
        umInfo.underMouse = underMouse;
        if (underMouse == null) {
            DragProcess process;
            if (underMouse instanceof DockDropReceiver) {
                this.dropReceiver = (DockDropReceiver)((Object)underMouse);
            }
            if (!(process = new DragProcess(this.dockableDragSource, umInfo)).canDockableBeDetached() || !process.checkAndDetachDockable(shapePainterStrategy)) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        } else if (underMouse instanceof DockDropReceiver && e.isControlDown()) {
            this.processHotSwap(underMouse, dragged, shapePainterStrategy, false);
        } else if (underMouse instanceof DockDropReceiver) {
            DragProcess process = new DragProcess(this.dockableDragSource, umInfo);
            DockDragEvent event = process.findAcceptableEvent(e);
            if (event.isDragAccepted() && process.isDockingActionAccepted()) {
                shapePainterStrategy.showDragCursor();
                this.setDropShape(event.getDropShape(), shapePainterStrategy);
            } else if (!process.canDockableBeDetached() || !process.checkAndDetachDockable(shapePainterStrategy)) {
                event.rejectDrag();
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        } else {
            DragProcess process = new DragProcess(this.dockableDragSource, umInfo);
            if (!process.canDockableBeDetached() || !process.checkAndDetachDockable(shapePainterStrategy)) {
                shapePainterStrategy.showStopDragCursor();
                this.setDropShape(null, shapePainterStrategy);
            }
        }
    }

    protected void setDropShape(Shape shape, ShapePainterStrategy shapePainterStrategy) {
        this.setDropShape(shape, shapePainterStrategy, false);
    }

    protected void setDropShape(Shape shape, ShapePainterStrategy shapePainterStrategy, boolean floating) {
        if (this.dropShape == null) {
            if (shape != null) {
                this.dropShape = shape;
                this.isFloatingShape = floating;
                shapePainterStrategy.repaint();
            }
        } else if (shape != null) {
            if (!this.dropShape.equals(shape)) {
                this.dropShape = shape;
                this.isFloatingShape = floating;
                shapePainterStrategy.repaint();
            }
        } else {
            this.dropShape = shape;
            this.isFloatingShape = floating;
            shapePainterStrategy.repaint();
        }
    }

    class UnderMouseInfo {
        DockingDesktop desktop;
        Component underMouse;

        UnderMouseInfo() {
        }
    }

    class DropProcess
    extends DragProcess {
        MouseEvent event;

        DropProcess(MouseEvent event, DockableDragSource source, UnderMouseInfo umInfo) {
            super(source, umInfo);
            this.event = event;
        }

        public boolean dropIfPossible() {
            MouseEvent convertMouse = SwingUtilities.convertMouseEvent((Component)this.event.getSource(), this.event, this.umInfo.underMouse);
            DockDropEvent dropEvent = new DockDropEvent(this.umInfo.desktop, this.source, convertMouse);
            AbstractDragControler.this.dropReceiver.processDockableDrop(dropEvent);
            Component underMouse = this.umInfo.underMouse;
            if (dropEvent.isDropAccepted()) {
                if (underMouse instanceof JComponent) {
                    ((JComponent)underMouse).revalidate();
                } else if (underMouse instanceof Component) {
                    underMouse.validate();
                    underMouse.repaint();
                }
                this.fireDockingActionEvent();
                return true;
            }
            return false;
        }

        public void fireDockingActionEvent() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    this.fireSingleDockingActionEvent(tdc.getDockableAt(i));
                }
            } else {
                this.fireSingleDockingActionEvent(this.source.getDockable());
            }
        }

        private void fireSingleDockingActionEvent(Dockable dockable) {
            if (this.stateChange) {
                DockableState currentState = AbstractDragControler.this.desktop.getDockableState(dockable);
                dockable.getDockKey().setLocation(this.futureLocation);
                AbstractDragControler.this.dockingContext.fireDockableStateChange(new DockableStateChangeEvent(currentState, new DockableState(AbstractDragControler.this.desktop, dockable, this.futureLocation)));
            }
            if (this.dockingActionEvent instanceof DockingActionDockableEvent) {
                DockingActionDockableEvent dde = (DockingActionDockableEvent)this.dockingActionEvent;
                if (dde.getDockable() == dockable) {
                    AbstractDragControler.this.dockingContext.fireDockingActionPerformed(this.dockingActionEvent);
                } else {
                    DockingActionDockableEvent dae = (DockingActionDockableEvent)dde.clone();
                    dae.setDockable(dockable);
                    AbstractDragControler.this.dockingContext.fireDockingActionPerformed(dae);
                }
            } else if (!(this.dockingActionEvent instanceof DockingActionSplitDockableContainerEvent)) {
                throw new RuntimeException("Unmanaged docking action");
            }
        }

        public void setFloating(Point location) {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                AbstractDragControler.this.desktop.setFloating((TabbedDockableContainer)((Object)this.source.getDockableContainer()), location);
            } else {
                Dockable dockable = this.source.getDockable();
                AbstractDragControler.this.desktop.setFloating(this.source.getDockable(), true, location);
            }
        }
    }

    class DragProcess {
        DockableDragSource source;
        UnderMouseInfo umInfo;
        boolean stateChange = false;
        DockableState.Location futureLocation;
        DockingActionEvent dockingActionEvent;

        DragProcess(DockableDragSource source, UnderMouseInfo umInfo) {
            this.source = source;
            this.umInfo = umInfo;
            this.futureLocation = DockingUtilities.getDockableLocationFromHierarchy(umInfo.underMouse);
        }

        public DockDragEvent findAcceptableEvent(MouseEvent e) {
            DockDragEvent event;
            boolean loop = false;
            Component underMouse = this.umInfo.underMouse;
            do {
                AbstractDragControler.this.dropReceiver = (DockDropReceiver)((Object)underMouse);
                MouseEvent convertMouse = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, underMouse);
                DockableDragSource dragSource = (DockableDragSource)e.getSource();
                event = new DockDragEvent(this.umInfo.desktop, dragSource, convertMouse);
                AbstractDragControler.this.dropReceiver.processDockableDrag(event);
                if (event.isDragAccepted() || !event.isDragDelegated()) continue;
                for (underMouse = underMouse.getParent(); underMouse != null && underMouse != this.umInfo.desktop && !(underMouse instanceof DockDropReceiver); underMouse = underMouse.getParent()) {
                }
            } while (loop = event.isDragAccepted() ? false : event.isDragDelegated() && underMouse instanceof DockDropReceiver);
            if (event != null) {
                this.dockingActionEvent = event.getDockingAction();
                this.umInfo.underMouse = underMouse;
            }
            return event;
        }

        public boolean isDockingActionAccepted() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    if (this.isSingleDockingActionAccepted(d)) continue;
                    return false;
                }
                return true;
            }
            return this.isSingleDockingActionAccepted(this.source.getDockable());
        }

        private boolean isSingleDockingActionAccepted(Dockable dockable) {
            DockableState currentState = this.umInfo.desktop.getDockableState(dockable);
            if (currentState.getLocation() != this.futureLocation) {
                this.stateChange = true;
                DockableState newState = new DockableState(this.umInfo.desktop, dockable, this.futureLocation);
                DockableStateWillChangeEvent dscwEvent = new DockableStateWillChangeEvent(currentState, newState);
                if (!AbstractDragControler.this.desktop.getContext().fireDockableStateWillChange(dscwEvent)) {
                    return false;
                }
            }
            if (this.dockingActionEvent instanceof DockingActionDockableEvent) {
                DockingActionDockableEvent dde = (DockingActionDockableEvent)this.dockingActionEvent;
                if (dde.getDockable() == dockable) {
                    return AbstractDragControler.this.desktop.getContext().fireAcceptDockingAction(this.dockingActionEvent);
                }
                DockingActionDockableEvent dae = (DockingActionDockableEvent)dde.clone();
                dae.setDockable(dockable);
                return AbstractDragControler.this.desktop.getContext().fireAcceptDockingAction(dae);
            }
            if (this.dockingActionEvent instanceof DockingActionSplitDockableContainerEvent) {
                return true;
            }
            throw new RuntimeException("unmanaged docking action " + this.dockingActionEvent);
        }

        public boolean canDockableBeDetached() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    if (this.canSingleDockableBeDetached(d)) continue;
                    return false;
                }
                Dockable any = tdc.getDockableAt(0);
                return any.getDockKey().getLocation() != DockableState.Location.FLOATING;
            }
            return this.canSingleDockableBeDetached(this.source.getDockable());
        }

        private boolean canSingleDockableBeDetached(Dockable dockable) {
            DockKey key = dockable.getDockKey();
            if (key.getLocation() == DockableState.Location.FLOATING) {
                return DockingUtilities.findTabbedDockableContainer(dockable) != null;
            }
            if (key.isFloatEnabled()) {
                return key.getLocation() != DockableState.Location.MAXIMIZED;
            }
            return false;
        }

        public boolean checkDockableWillBeDetached() {
            if (this.source.getDockableContainer() instanceof TabbedDockableContainer) {
                TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)this.source.getDockableContainer());
                for (int i = 0; i < tdc.getTabCount(); ++i) {
                    Dockable d = tdc.getDockableAt(i);
                    if (this.checkSingleDockableWillBeDetached(d)) continue;
                    return false;
                }
                return true;
            }
            return this.checkSingleDockableWillBeDetached(this.source.getDockable());
        }

        private boolean checkSingleDockableWillBeDetached(Dockable dockable) {
            DockableState newState = new DockableState(AbstractDragControler.this.desktop, dockable, DockableState.Location.FLOATING);
            DockableState currentState = AbstractDragControler.this.desktop.getDockableState(dockable);
            if (currentState == null) {
                return false;
            }
            DockableStateWillChangeEvent dscwEvent = new DockableStateWillChangeEvent(currentState, newState);
            if (!AbstractDragControler.this.desktop.getContext().fireDockableStateWillChange(dscwEvent)) {
                return false;
            }
            DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(AbstractDragControler.this.desktop, dockable, currentState.getLocation(), DockableState.Location.FLOATING);
            return AbstractDragControler.this.desktop.getContext().fireAcceptDockingAction(dae);
        }

        public boolean checkAndDetachDockable(ShapePainterStrategy shapePainterStrategy) {
            if (this.checkDockableWillBeDetached()) {
                if (DockingPreferences.isLightWeightUsageEnabled() && AbstractDragControler.this.paintFloatingDragShape) {
                    Point shapePoint = new Point(AbstractDragControler.this.dragPoint);
                    SwingUtilities.convertPointToScreen(shapePoint, AbstractDragControler.this.desktop);
                    if (AbstractDragControler.this.dropReceiver != null) {
                        SwingUtilities.convertPointFromScreen(shapePoint, (Component)((Object)AbstractDragControler.this.dropReceiver));
                        Dimension dragSize = AbstractDragControler.this.dockableDragSource.getDockableContainer().getSize();
                        AbstractDragControler.this.setDropShape(new Rectangle2D.Float(shapePoint.x, shapePoint.y, dragSize.width, dragSize.height), shapePainterStrategy, true);
                    } else {
                        AbstractDragControler.this.setDropShape(null, shapePainterStrategy);
                    }
                } else {
                    AbstractDragControler.this.setDropShape(null, shapePainterStrategy);
                }
                shapePainterStrategy.showFloatCursor();
                return true;
            }
            return false;
        }
    }
}

