/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd.validation;

import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public abstract class ValidationUtil {
    public static CommandLineValidation isSet(final String parameterName, final int min, final int max) {
        return new CommandLineValidation(){

            public boolean validate(CommandLine cli) {
                String[] values = cli.getOptionValues(parameterName);
                int len = values == null ? 0 : values.length;
                return min <= len && (max < 0 || len <= max);
            }
        };
    }

    public static CommandLineValidation isNonOptionSet(final int min, final int max) {
        return new CommandLineValidation(){

            public boolean validate(CommandLine cli) {
                String[] values = cli.getArgs();
                int len = values == null ? 0 : values.length;
                return min <= len && (max < 0 || len <= max);
            }
        };
    }

    public static CommandLineValidation choice(final boolean optional, final CommandLineValidation ... validations) {
        return new CommandLineValidation(){

            public boolean validate(CommandLine cli) {
                boolean foundValid = false;
                for (CommandLineValidation validation : validations) {
                    if (!validation.validate(cli)) continue;
                    if (foundValid) {
                        return false;
                    }
                    foundValid = true;
                }
                return foundValid || optional;
            }
        };
    }

    public static CommandLineValidation or(final CommandLineValidation ... validations) {
        return new CommandLineValidation(){

            public boolean validate(CommandLine cli) {
                for (CommandLineValidation validation : validations) {
                    if (!validation.validate(cli)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static void checkRequiredArguments(BaseCmd cmd, String ... arguments) {
        ArrayList<String> missingArguments = new ArrayList<String>();
        if (arguments.length % 2 != 0) {
            throw new RuntimeException("Expecting argument name, display option pairs");
        }
        for (int i = 0; i < arguments.length; i += 2) {
            if (cmd.getOptionValue(arguments[i]) != null) continue;
            missingArguments.add(arguments[i + 1]);
        }
        if (!missingArguments.isEmpty()) {
            throw new MissingAtLeastOneArgument(missingArguments.toArray(new String[missingArguments.size()]));
        }
    }

    public static interface CommandLineValidation {
        public boolean validate(CommandLine var1);
    }
}

