/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.util.EventListener;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TracerEvent
implements EventListener {
    public final ElemTemplateElement m_styleNode;
    public final TransformerImpl m_processor;
    public final Node m_sourceNode;
    public final QName m_mode;

    public TracerEvent(TransformerImpl processor, Node sourceNode, QName mode, ElemTemplateElement styleNode) {
        this.m_processor = processor;
        this.m_sourceNode = sourceNode;
        this.m_mode = mode;
        this.m_styleNode = styleNode;
    }

    public static String printNode(Node n) {
        String r = String.valueOf(n.hashCode()) + " ";
        if (n instanceof Element) {
            r = String.valueOf(r) + "<" + n.getNodeName();
            Node c = n.getFirstChild();
            while (c != null) {
                if (c instanceof Attr) {
                    r = String.valueOf(r) + TracerEvent.printNode(c) + " ";
                }
                c = c.getNextSibling();
            }
            r = String.valueOf(r) + ">";
        } else {
            r = n instanceof Attr ? String.valueOf(r) + n.getNodeName() + "=" + n.getNodeValue() : String.valueOf(r) + n.getNodeName();
        }
        return r;
    }

    public static String printNodeList(NodeList l) {
        Node n;
        String r = String.valueOf(l.hashCode()) + "[";
        int len = l.getLength() - 1;
        int i = 0;
        while (i < len) {
            n = l.item(i);
            if (n != null) {
                r = String.valueOf(r) + TracerEvent.printNode(n) + ", ";
            }
            ++i;
        }
        if (i == len && (n = l.item(len)) != null) {
            r = String.valueOf(r) + TracerEvent.printNode(n);
        }
        return String.valueOf(r) + "]";
    }
}

