/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.OperationMode;

public class OperationModeUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(OperationModeUpdateTask.class);
    private final OperationMode mode;

    public OperationModeUpdateTask(OperationMode mode) {
        this.mode = mode;
    }

    OperationMode getOperationMode() {
        return this.mode;
    }

    public ClusterState execute(ClusterState currentState) {
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metaData().custom("index_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.mode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = IndexLifecycleMetadata.EMPTY;
        }
        OperationMode newMode = currentMetadata.getOperationMode().isValidChange(this.mode) ? this.mode : currentMetadata.getOperationMode();
        ClusterState.Builder builder = new ClusterState.Builder(currentState);
        MetaData.Builder metadataBuilder = MetaData.builder((MetaData)currentState.metaData());
        metadataBuilder.putCustom("index_lifecycle", (MetaData.Custom)new IndexLifecycleMetadata(currentMetadata.getPolicyMetadatas(), newMode));
        builder.metaData(metadataBuilder.build());
        return builder.build();
    }

    public void onFailure(String source, Exception e) {
        logger.error("unable to update lifecycle metadata with new mode [" + this.mode + "]", (Throwable)e);
    }
}

