/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;

public class ExpressionRoleMapping
implements ToXContentObject,
Writeable {
    private static final ObjectParser<Builder, String> PARSER = new ObjectParser("role-mapping", () -> new Builder());
    private static final String UPGRADE_API_TYPE_FIELD = "type";
    private final String name;
    private final RoleMapperExpression expression;
    private final List<String> roles;
    private final Map<String, Object> metadata;
    private final boolean enabled;

    public ExpressionRoleMapping(String name, RoleMapperExpression expr, List<String> roles, Map<String, Object> metadata, boolean enabled) {
        this.name = name;
        this.expression = expr;
        this.roles = roles;
        this.metadata = metadata;
        this.enabled = enabled;
    }

    public ExpressionRoleMapping(StreamInput in) throws IOException {
        this.name = in.readString();
        this.enabled = in.readBoolean();
        this.roles = in.readStringList();
        this.expression = ExpressionParser.readExpression(in);
        this.metadata = in.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.enabled);
        out.writeStringCollection(this.roles);
        ExpressionParser.writeExpression(this.expression, out);
        out.writeMap(this.metadata);
    }

    public String getName() {
        return this.name;
    }

    public RoleMapperExpression getExpression() {
        return this.expression;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.name + " ; " + this.roles + " = " + Strings.toString((ToXContent)this.expression) + ">";
    }

    public static ExpressionRoleMapping parse(String name, BytesReference source, XContentType xContentType) throws IOException {
        NamedXContentRegistry registry = NamedXContentRegistry.EMPTY;
        try (StreamInput stream = source.streamInput();){
            ExpressionRoleMapping expressionRoleMapping;
            block12: {
                XContentParser parser = xContentType.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    expressionRoleMapping = ExpressionRoleMapping.parse(name, parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return expressionRoleMapping;
        }
    }

    public static ExpressionRoleMapping parse(String name, XContentParser parser) throws IOException {
        try {
            Builder builder = (Builder)PARSER.parse(parser, null);
            return builder.build(name);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean includeDocType) throws IOException {
        builder.startObject();
        builder.field(Fields.ENABLED.getPreferredName(), this.enabled);
        builder.startArray(Fields.ROLES.getPreferredName());
        for (String r : this.roles) {
            builder.value(r);
        }
        builder.endArray();
        builder.field(Fields.RULES.getPreferredName());
        this.expression.toXContent(builder, params);
        builder.field(Fields.METADATA.getPreferredName(), this.metadata);
        if (includeDocType) {
            builder.field("doc_type", "role-mapping");
        }
        return builder.endObject();
    }

    static {
        PARSER.declareStringArray(Builder::roles, Fields.ROLES);
        PARSER.declareField(Builder::rules, ExpressionParser::parseObject, Fields.RULES, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(Builder::metadata, XContentParser::map, Fields.METADATA, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(Builder::enabled, Fields.ENABLED);
        BiConsumer<Builder, String> ignored = (b, v) -> {};
        PARSER.declareString(ignored, new ParseField("doc_type", new String[0]));
        PARSER.declareString(ignored, new ParseField(UPGRADE_API_TYPE_FIELD, new String[0]));
    }

    public static interface Fields {
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
        public static final ParseField RULES = new ParseField("rules", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    }

    private static class Builder {
        private RoleMapperExpression rules;
        private List<String> roles;
        private Map<String, Object> metadata = Collections.emptyMap();
        private Boolean enabled;

        private Builder() {
        }

        Builder rules(RoleMapperExpression expression) {
            this.rules = expression;
            return this;
        }

        Builder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        private ExpressionRoleMapping build(String name) {
            if (this.roles == null) {
                throw this.missingField(name, Fields.ROLES);
            }
            if (this.rules == null) {
                throw this.missingField(name, Fields.RULES);
            }
            if (this.enabled == null) {
                throw this.missingField(name, Fields.ENABLED);
            }
            return new ExpressionRoleMapping(name, this.rules, this.roles, this.metadata, this.enabled);
        }

        private IllegalStateException missingField(String id, ParseField field) {
            return new IllegalStateException("failed to parse role-mapping [" + id + "]. missing field [" + field + "]");
        }
    }
}

