/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.HealthCheckListener;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.health.HealthCheckIQ;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

public class JvbDoctor
implements BridgeSelector.EventHandler {
    private static final Logger logger = new LoggerImpl(JvbDoctor.class.getName());
    private final long healthCheckInterval = BridgeConfig.config.getHealthChecksInterval().toMillis();
    private final long secondChanceDelay = BridgeConfig.config.getHealthChecksRetryDelay().toMillis();
    private final Map<Bridge, ScheduledFuture<?>> tasks = new ConcurrentHashMap();
    private final HealthCheckListener listener;
    @NotNull
    private final XmppProvider xmppProvider;

    public JvbDoctor(HealthCheckListener listener, @NotNull XmppProvider xmppProvider) {
        this.xmppProvider = xmppProvider;
        this.listener = listener;
    }

    private AbstractXMPPConnection getConnection() {
        return this.xmppProvider.getXmppConnection();
    }

    public synchronized void shutdown() {
        ArrayList<Bridge> bridges = new ArrayList<Bridge>(this.tasks.keySet());
        for (Bridge bridge2 : bridges) {
            this.bridgeRemoved(bridge2);
        }
    }

    @Override
    public void bridgeRemoved(Bridge bridge2) {
        ScheduledFuture<?> healthTask = this.tasks.remove(bridge2);
        if (healthTask == null) {
            logger.warn((Object)("Trying to remove a bridge that does not exist anymore: " + bridge2));
            return;
        }
        logger.info((Object)("Stopping health-check task for: " + bridge2));
        healthTask.cancel(true);
    }

    @Override
    public void bridgeAdded(Bridge bridge2) {
        if (this.tasks.containsKey(bridge2)) {
            logger.warn((Object)("Trying to add already existing bridge: " + bridge2));
            return;
        }
        AbstractHealthCheckTask task = BridgeConfig.config.getUsePresenceForHealth() ? new HealthCheckPresenceTask(bridge2) : new HealthCheckTask(bridge2);
        ScheduledFuture<?> healthTask = TaskPools.getScheduledPool().scheduleAtFixedRate(task, this.healthCheckInterval, this.healthCheckInterval, TimeUnit.MILLISECONDS);
        this.tasks.put(bridge2, healthTask);
        logger.info((Object)("Scheduled health-check task for: " + bridge2));
    }

    @Override
    public void bridgeIsShuttingDown(@NotNull Bridge bridge2) {
    }

    private class HealthCheckPresenceTask
    extends AbstractHealthCheckTask {
        private HealthCheckPresenceTask(Bridge bridge2) {
            super(bridge2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doHealthCheck() {
            AbstractXMPPConnection connection = JvbDoctor.this.getConnection();
            if (!connection.isConnected()) {
                logger.warn((Object)("XMPP disconnected - skipping health check for: " + this.bridge));
                return;
            }
            if (this.taskInvalid()) {
                return;
            }
            logger.debug((Object)("Checking presence for health for: " + this.bridge));
            boolean healthy = this.bridge.isHealthy();
            boolean timeout = this.bridge.getTimeSinceLastPresence().compareTo(BridgeConfig.config.getPresenceHealthTimeout()) > 0;
            JvbDoctor jvbDoctor = JvbDoctor.this;
            synchronized (jvbDoctor) {
                if (this.taskInvalid()) {
                    return;
                }
                if (timeout) {
                    logger.warn((Object)("Health check timed out for: " + this.bridge));
                    JvbDoctor.this.listener.healthCheckTimedOut(this.bridge.getJid());
                } else if (!healthy) {
                    logger.warn((Object)("JVB reported unhealthy" + this.bridge));
                    JvbDoctor.this.listener.healthCheckFailed(this.bridge.getJid());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Health check passed on: " + this.bridge));
                    }
                    JvbDoctor.this.listener.healthCheckPassed(this.bridge.getJid());
                }
            }
        }
    }

    private class HealthCheckTask
    extends AbstractHealthCheckTask {
        private HealthCheckTask(Bridge bridge2) {
            super(bridge2);
        }

        private HealthCheckIQ newHealthCheckIQ(Bridge bridge2) {
            HealthCheckIQ healthIq = new HealthCheckIQ();
            healthIq.setTo(bridge2.getJid());
            healthIq.setType(IQ.Type.get);
            return healthIq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doHealthCheck() throws SmackException.NotConnectedException {
            AbstractXMPPConnection connection = JvbDoctor.this.getConnection();
            if (!connection.isConnected()) {
                logger.warn((Object)("XMPP disconnected - skipping health check for: " + this.bridge));
                return;
            }
            if (this.taskInvalid()) {
                return;
            }
            logger.debug((Object)("Sending health-check request to: " + this.bridge));
            IQ response = UtilKt.sendIqAndGetResponse((AbstractXMPPConnection)connection, (IQ)this.newHealthCheckIQ(this.bridge));
            if (response == null && JvbDoctor.this.secondChanceDelay > 0L) {
                try {
                    if (this.taskInvalid()) {
                        return;
                    }
                    logger.warn((Object)(this.bridge + " health-check timed out, but will give it another try after: " + JvbDoctor.this.secondChanceDelay));
                    Thread.sleep(JvbDoctor.this.secondChanceDelay);
                    if (this.taskInvalid()) {
                        return;
                    }
                    response = UtilKt.sendIqAndGetResponse((AbstractXMPPConnection)connection, (IQ)this.newHealthCheckIQ(this.bridge));
                }
                catch (InterruptedException e) {
                    logger.error((Object)(this.bridge + " second chance delay wait interrupted"), (Throwable)e);
                }
            }
            JvbDoctor jvbDoctor = JvbDoctor.this;
            synchronized (jvbDoctor) {
                if (this.taskInvalid()) {
                    return;
                }
                if (response == null) {
                    logger.warn((Object)("Health check timed out for: " + this.bridge));
                    JvbDoctor.this.listener.healthCheckTimedOut(this.bridge.getJid());
                    return;
                }
                IQ.Type responseType = response.getType();
                if (IQ.Type.result.equals((Object)responseType)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Health check passed on: " + this.bridge));
                    }
                    JvbDoctor.this.listener.healthCheckPassed(this.bridge.getJid());
                    return;
                }
                if (IQ.Type.error.equals((Object)responseType)) {
                    StanzaError error = response.getError();
                    StanzaError.Condition condition = error.getCondition();
                    if (StanzaError.Condition.internal_server_error.equals((Object)condition) || StanzaError.Condition.service_unavailable.equals((Object)condition)) {
                        logger.warn((Object)("Health check failed for: " + this.bridge + ": " + error.toXML().toString()));
                        JvbDoctor.this.listener.healthCheckFailed(this.bridge.getJid());
                    } else {
                        logger.error((Object)("Unexpected error returned by the bridge: " + this.bridge + ", err: " + response.toXML()));
                    }
                }
            }
        }
    }

    private abstract class AbstractHealthCheckTask
    implements Runnable {
        protected final Bridge bridge;

        AbstractHealthCheckTask(Bridge bridge2) {
            this.bridge = bridge2;
        }

        protected abstract void doHealthCheck() throws SmackException.NotConnectedException, InterruptedException;

        @Override
        public void run() {
            try {
                this.doHealthCheck();
            }
            catch (Exception e) {
                if (this.taskInvalid() && e instanceof InterruptedException) {
                    logger.debug((Object)"The task has been canceled.");
                }
                logger.error((Object)("Error when doing health-check on: " + this.bridge), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean taskInvalid() {
            JvbDoctor jvbDoctor = JvbDoctor.this;
            synchronized (jvbDoctor) {
                if (!JvbDoctor.this.tasks.containsKey(this.bridge)) {
                    logger.info((Object)("Health check task canceled for: " + this.bridge));
                    return true;
                }
                return false;
            }
        }
    }
}

