/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.config.PropertiesLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClasspathPropertiesLoader
implements PropertiesLoader {
    @NotNull
    private final String fileName;
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final ILogger logger;

    public ClasspathPropertiesLoader(@NotNull String fileName, @NotNull ClassLoader classLoader, @NotNull ILogger logger) {
        this.fileName = fileName;
        this.classLoader = classLoader;
        this.logger = logger;
    }

    public ClasspathPropertiesLoader(@NotNull ILogger logger) {
        this("sentry.properties", ClasspathPropertiesLoader.class.getClassLoader(), logger);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Properties load() {
        block13: {
            try (InputStream inputStream = this.classLoader.getResourceAsStream(this.fileName);){
                Properties properties2;
                if (inputStream == null) break block13;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                    Properties properties3 = new Properties();
                    properties3.load(bufferedInputStream);
                    properties2 = properties3;
                }
                return properties2;
            }
            catch (IOException e) {
                this.logger.log(SentryLevel.ERROR, e, "Failed to load Sentry configuration from classpath resource: %s", this.fileName);
                return null;
            }
        }
        return null;
    }
}

