/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinLanguage;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTag;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class ScenarioToOutlineIntention
implements IntentionAction {
    public static final String ARGUMENT = "argument";

    @NotNull
    public String getText() {
        if ("Convert scenario to outline" == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(0);
        }
        return "Convert scenario to outline";
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert scenario to outline" == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(1);
        }
        return "Convert scenario to outline";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(2);
        }
        if (!(file.getLanguage() instanceof GherkinLanguage)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinScenario.class);
        return scenario != null && ScenarioToOutlineIntention.canConvertScenario(scenario);
    }

    private static boolean canConvertScenario(GherkinScenario scenario) {
        if (scenario.isBackground()) {
            return false;
        }
        for (GherkinStep step : scenario.getSteps()) {
            if (step.getTable() == null && step.getPystring() == null) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(3);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinScenario.class);
        assert (scenario != null);
        String language = GherkinKeywordTable.getFeatureLanguage((PsiFile)file);
        GherkinKeywordTable keywordsTable = GherkinKeywordTable.getKeywordsTable((PsiFile)file, (Project)project);
        StringBuilder newScenarioText = new StringBuilder();
        for (GherkinTag tag : scenario.getTags()) {
            newScenarioText.append(tag.getName()).append(' ');
        }
        if (scenario.getTags().length > 0) {
            newScenarioText.append('\n');
        }
        newScenarioText.append(keywordsTable.getScenarioOutlineKeyword()).append(": ").append(scenario.getScenarioName());
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        for (GherkinStep step : scenario.getSteps()) {
            AbstractStepDefinition definition;
            PsiReference[] references = step.getReferences();
            CucumberStepReference reference = references.length > 0 ? (CucumberStepReference)step.getReferences()[0] : null;
            AbstractStepDefinition abstractStepDefinition = definition = reference != null ? reference.resolveToDefinition() : null;
            if (definition != null) {
                String stepName = ScenarioToOutlineIntention.replaceVarNames(step.getStepName(), definition, examples);
                newScenarioText.append("\n").append(step.getKeyword().getText()).append(" ").append(stepName);
                continue;
            }
            newScenarioText.append("\n").append(step.getText());
        }
        newScenarioText.append("\n").append(ScenarioToOutlineIntention.buildExamplesSection(examples, keywordsTable.getExampleSectionKeyword()));
        GherkinStepsHolder newScenario = GherkinElementFactory.createScenarioFromText((Project)project, (String)language, (String)newScenarioText.toString());
        scenario.replace((PsiElement)newScenario);
    }

    private static String replaceVarNames(String stepName, AbstractStepDefinition definition, Map<String, String> examples) {
        Matcher matcher;
        Pattern pattern;
        List varNames = definition.getVariableNames();
        if (varNames.size() > 0 && (pattern = definition.getPattern()) != null && (matcher = pattern.matcher(stepName)).matches()) {
            int groupCount = matcher.groupCount();
            for (int i = 0; i < groupCount; ++i) {
                int end;
                String name = i < varNames.size() ? (String)varNames.get(i) : ARGUMENT;
                name = ScenarioToOutlineIntention.uniqueName(name, examples, matcher.group(i + 1));
                int start = matcher.start(i + 1);
                if (!(matcher = pattern.matcher(stepName = StringUtil.replaceSubstring((String)stepName, (TextRange)new TextRange(start, end = matcher.end(i + 1)), (String)("<" + name + ">")))).matches()) break;
            }
        }
        return stepName;
    }

    private static String buildExamplesSection(Map<String, String> examples, String keyword) {
        StringBuilder builder = new StringBuilder(keyword);
        builder.append(":\n");
        if (examples.size() > 0) {
            for (String key : examples.keySet()) {
                builder.append("|").append(key);
            }
            builder.append("|\n");
            for (String key : examples.keySet()) {
                builder.append("|").append(examples.get(key));
            }
            builder.append("|\n");
        }
        return builder.toString();
    }

    private static String uniqueName(String name, Map<String, String> examples, String group) {
        String candidate = name;
        if (name.equals(ARGUMENT)) {
            int i = 1;
            while (examples.containsKey(candidate)) {
                candidate = name + i++;
            }
        }
        examples.put(candidate, group);
        return candidate;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/actions/ScenarioToOutlineIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/actions/ScenarioToOutlineIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

