/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.messages;

import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class Either3<T1, T2, T3>
extends Either<T1, Either<T2, T3>> {
    public static <T1, T2, T3> Either3<T1, T2, T3> forFirst(@NonNull T1 first) {
        return new Either3<T1, T2, T3>(first, null);
    }

    public static <T1, T2, T3> Either3<T1, T2, T3> forSecond(@NonNull T2 second) {
        return new Either3<Object, T2, Object>(null, new Either<T2, Object>(second, null));
    }

    public static <T1, T2, T3> Either3<T1, T2, T3> forThird(@NonNull T3 third) {
        return new Either3<Object, Object, T3>(null, new Either<Object, T3>(null, third));
    }

    public static <T1, T2, T3> Either3<T1, T2, T3> forLeft3(@NonNull T1 first) {
        return new Either3<T1, T2, T3>(first, null);
    }

    public static <T1, T2, T3> Either3<T1, T2, T3> forRight3(@NonNull Either<T2, T3> right) {
        return new Either3<Object, T2, T3>(null, right);
    }

    protected Either3(T1 left, Either<T2, T3> right) {
        super(left, right);
    }

    public T1 getFirst() {
        return (T1)this.getLeft();
    }

    public T2 getSecond() {
        Either right = (Either)this.getRight();
        if (right == null) {
            return null;
        }
        return (T2)right.getLeft();
    }

    public T3 getThird() {
        Either right = (Either)this.getRight();
        if (right == null) {
            return null;
        }
        return (T3)right.getRight();
    }

    public boolean isFirst() {
        return this.isLeft();
    }

    public boolean isSecond() {
        return this.isRight() && ((Either)this.getRight()).isLeft();
    }

    public boolean isThird() {
        return this.isRight() && ((Either)this.getRight()).isRight();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Either3 [").append(System.lineSeparator());
        builder.append("  first = ").append(this.getFirst()).append(System.lineSeparator());
        builder.append("  second = ").append(this.getSecond()).append(System.lineSeparator());
        builder.append("  third = ").append(this.getThird()).append(System.lineSeparator());
        return builder.append("]").toString();
    }
}

